/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MergeTwoValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = 2925048980504034018L;
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private SingleIndex m_FirstIndex = new SingleIndex("first");
    private SingleIndex m_SecondIndex = new SingleIndex("last");

    public String globalInfo() {
        return "Merges two values of a nominal attribute into one value.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        this.m_FirstIndex.setUpper(instances.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        this.m_SecondIndex.setUpper(instances.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (!instances.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instances.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        if (this.m_SecondIndex.getIndex() <= this.m_FirstIndex.getIndex()) {
            throw new Exception("The second index has to be greater than the first.");
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) {
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if ((int)(instance2 = (Instance)instance.copy()).value(this.m_AttIndex.getIndex()) == this.m_SecondIndex.getIndex()) {
            instance2.setValue(this.m_AttIndex.getIndex(), (double)this.m_FirstIndex.getIndex());
        } else if ((int)instance2.value(this.m_AttIndex.getIndex()) > this.m_SecondIndex.getIndex()) {
            instance2.setValue(this.m_AttIndex.getIndex(), instance2.value(this.m_AttIndex.getIndex()) - 1.0);
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSets the first value's index (default first).", "F", 1, "-F <value index>"));
        vector.addElement(new Option("\tSets the second value's index (default last).", "S", 1, "-S <value index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        String string2 = Utils.getOption('F', stringArray);
        if (string2.length() != 0) {
            this.setFirstValueIndex(string2);
        } else {
            this.setFirstValueIndex("first");
        }
        String string3 = Utils.getOption('S', stringArray);
        if (string3.length() != 0) {
            this.setSecondValueIndex(string3);
        } else {
            this.setSecondValueIndex("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getFirstValueIndex();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSecondValueIndex();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public String firstValueIndexTipText() {
        return "Sets the first value to be merged. (\"first\" and \"last\" are valid values)";
    }

    public String getFirstValueIndex() {
        return this.m_FirstIndex.getSingleIndex();
    }

    public void setFirstValueIndex(String string) {
        this.m_FirstIndex.setSingleIndex(string);
    }

    public String secondValueIndexTipText() {
        return "Sets the second value to be merged. (\"first\" and \"last\" are valid values)";
    }

    public String getSecondValueIndex() {
        return this.m_SecondIndex.getSingleIndex();
    }

    public void setSecondValueIndex(String string) {
        this.m_SecondIndex.setSingleIndex(string);
    }

    private void setOutputFormat() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i != this.m_AttIndex.getIndex()) {
                fastVector.addElement(attribute.copy());
                continue;
            }
            if (attribute.value(this.m_FirstIndex.getIndex()).endsWith("'")) {
                bl = true;
            }
            if (attribute.value(this.m_SecondIndex.getIndex()).endsWith("'")) {
                bl2 = true;
            }
            if (bl || bl2) {
                stringBuffer.append("'");
            }
            if (bl) {
                stringBuffer.append(attribute.value(this.m_FirstIndex.getIndex()).substring(1, attribute.value(this.m_FirstIndex.getIndex()).length() - 1));
            } else {
                stringBuffer.append(attribute.value(this.m_FirstIndex.getIndex()));
            }
            stringBuffer.append('_');
            if (bl2) {
                stringBuffer.append(attribute.value(this.m_SecondIndex.getIndex()).substring(1, attribute.value(this.m_SecondIndex.getIndex()).length() - 1));
            } else {
                stringBuffer.append(attribute.value(this.m_SecondIndex.getIndex()));
            }
            if (bl || bl2) {
                stringBuffer.append("'");
            }
            FastVector fastVector2 = new FastVector(attribute.numValues() - 1);
            for (int j = 0; j < attribute.numValues(); ++j) {
                if (j == this.m_FirstIndex.getIndex()) {
                    fastVector2.addElement(stringBuffer.toString());
                    continue;
                }
                if (j == this.m_SecondIndex.getIndex()) continue;
                fastVector2.addElement(attribute.value(j));
            }
            fastVector.addElement(new Attribute(attribute.name(), fastVector2));
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(instances);
    }

    public static void main(String[] stringArray) {
        MergeTwoValues.runFilter(new MergeTwoValues(), stringArray);
    }
}

