/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.visualize.JComponentWriter;
import weka.gui.visualize.PrintableHandler;
import weka.gui.visualize.VisualizeUtils;

public class PrintableComponent
implements PrintableHandler {
    protected JComponent m_Component;
    protected static JFileChooser m_FileChooserPanel;
    protected static JCheckBox m_CustomDimensionsCheckBox;
    protected static JTextField m_CustomWidthText;
    protected static JTextField m_CustomHeightText;
    protected static JCheckBox m_AspectRatioCheckBox;
    protected String m_SaveDialogTitle = "Save as...";
    protected double m_xScale = 1.0;
    protected double m_yScale = 1.0;
    protected double m_AspectRatio;
    protected boolean m_IgnoreChange;
    private static final boolean DEBUG = false;
    protected static boolean m_ToolTipUserAsked;
    protected static final String PROPERTY_SHOW = "PrintableComponentToolTipShow";
    protected static final String PROPERTY_USERASKED = "PrintableComponentToolTipUserAsked";
    protected static boolean m_ShowToolTip;

    public PrintableComponent(JComponent jComponent) {
        this.m_Component = jComponent;
        this.m_AspectRatio = Double.NaN;
        this.getComponent().addMouseListener(new PrintMouseListener(this));
        this.getComponent().setToolTipText(PrintableComponent.getToolTipText(this));
        this.initFileChooser();
    }

    public JComponent getComponent() {
        return this.m_Component;
    }

    public static String getToolTipText(PrintableComponent printableComponent) {
        return null;
    }

    protected void initFileChooser() {
        if (m_FileChooserPanel != null) {
            return;
        }
        m_FileChooserPanel = new JFileChooser();
        m_FileChooserPanel.resetChoosableFileFilters();
        m_FileChooserPanel.setAcceptAllFileFilterUsed(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setPreferredSize(new Dimension(200, 200));
        jPanel.revalidate();
        m_FileChooserPanel.setAccessory(jPanel);
        m_CustomDimensionsCheckBox = new JCheckBox("Use custom dimensions");
        m_CustomDimensionsCheckBox.setBounds(14, 7, 200, 21);
        m_CustomDimensionsCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = m_CustomDimensionsCheckBox.isSelected();
                m_CustomWidthText.setEnabled(bl);
                m_CustomHeightText.setEnabled(bl);
                m_AspectRatioCheckBox.setEnabled(bl);
                if (bl) {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("" + PrintableComponent.this.m_Component.getWidth());
                    m_CustomHeightText.setText("" + PrintableComponent.this.m_Component.getHeight());
                    PrintableComponent.this.m_IgnoreChange = false;
                } else {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("-1");
                    m_CustomHeightText.setText("-1");
                    PrintableComponent.this.m_IgnoreChange = false;
                }
            }
        });
        jPanel.add(m_CustomDimensionsCheckBox);
        m_CustomWidthText = new JTextField(5);
        m_CustomWidthText.setText("-1");
        m_CustomWidthText.setEnabled(false);
        m_CustomWidthText.setBounds(65, 35, 50, 21);
        m_CustomWidthText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomWidthText);
            }
        });
        JLabel jLabel = new JLabel("Width");
        jLabel.setLabelFor(m_CustomWidthText);
        jLabel.setDisplayedMnemonic('W');
        jLabel.setBounds(14, 35, 50, 21);
        jPanel.add(jLabel);
        jPanel.add(m_CustomWidthText);
        m_CustomHeightText = new JTextField(5);
        m_CustomHeightText.setText("-1");
        m_CustomHeightText.setEnabled(false);
        m_CustomHeightText.setBounds(65, 63, 50, 21);
        m_CustomHeightText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PrintableComponent.this.updateDimensions(m_CustomHeightText);
            }
        });
        jLabel = new JLabel("Height");
        jLabel.setLabelFor(m_CustomHeightText);
        jLabel.setDisplayedMnemonic('H');
        jLabel.setBounds(14, 63, 50, 21);
        jPanel.add(jLabel);
        jPanel.add(m_CustomHeightText);
        m_AspectRatioCheckBox = new JCheckBox("Keep aspect ratio");
        m_AspectRatioCheckBox.setBounds(14, 91, 200, 21);
        m_AspectRatioCheckBox.setEnabled(false);
        m_AspectRatioCheckBox.setSelected(true);
        m_AspectRatioCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = m_AspectRatioCheckBox.isSelected();
                if (bl) {
                    PrintableComponent.this.m_IgnoreChange = true;
                    m_CustomWidthText.setText("" + PrintableComponent.this.m_Component.getWidth());
                    m_CustomHeightText.setText("" + PrintableComponent.this.m_Component.getHeight());
                    PrintableComponent.this.m_IgnoreChange = false;
                }
            }
        });
        jPanel.add(m_AspectRatioCheckBox);
        Vector<String> vector = GenericObjectEditor.getClassnames(JComponentWriter.class.getName());
        Collections.sort(vector);
        for (int i = 0; i < vector.size(); ++i) {
            try {
                Class<?> clazz = Class.forName(vector.get(i).toString());
                JComponentWriter jComponentWriter = (JComponentWriter)clazz.newInstance();
                m_FileChooserPanel.addChoosableFileFilter(new JComponentWriterFileFilter(jComponentWriter.getExtension(), jComponentWriter.getDescription() + " (*" + jComponentWriter.getExtension() + ")", jComponentWriter));
                continue;
            }
            catch (Exception exception) {
                System.err.println(vector.get(i) + ": " + exception);
            }
        }
        if (m_FileChooserPanel.getChoosableFileFilters().length > 0) {
            m_FileChooserPanel.setFileFilter(m_FileChooserPanel.getChoosableFileFilters()[0]);
        }
    }

    protected void updateDimensions(JTextField jTextField) {
        int n;
        int n2;
        if (!m_AspectRatioCheckBox.isSelected() || this.m_IgnoreChange) {
            return;
        }
        if (!(jTextField instanceof JTextField) || jTextField == null) {
            return;
        }
        if (jTextField.getText().length() == 0) {
            return;
        }
        try {
            n2 = Integer.parseInt(jTextField.getText());
            n = 0;
            if (n2 <= 0) {
                return;
            }
            if (Double.isNaN(this.m_AspectRatio)) {
                this.m_AspectRatio = (double)this.getComponent().getWidth() / (double)this.getComponent().getHeight();
            }
        }
        catch (Exception exception) {
            return;
        }
        this.m_IgnoreChange = true;
        if (jTextField == m_CustomWidthText) {
            n = (int)((double)n2 * (1.0 / this.m_AspectRatio));
            m_CustomHeightText.setText("" + n);
        } else if (jTextField == m_CustomHeightText) {
            n = (int)((double)n2 * this.m_AspectRatio);
            m_CustomWidthText.setText("" + n);
        }
        this.m_IgnoreChange = false;
    }

    public Hashtable getWriters() {
        Hashtable<String, JComponentWriter> hashtable = new Hashtable<String, JComponentWriter>();
        for (int i = 0; i < m_FileChooserPanel.getChoosableFileFilters().length; ++i) {
            JComponentWriter jComponentWriter = ((JComponentWriterFileFilter)m_FileChooserPanel.getChoosableFileFilters()[i]).getWriter();
            hashtable.put(jComponentWriter.getDescription(), jComponentWriter);
        }
        return hashtable;
    }

    public JComponentWriter getWriter(String string) {
        return (JComponentWriter)this.getWriters().get(string);
    }

    public void setSaveDialogTitle(String string) {
        this.m_SaveDialogTitle = string;
    }

    public String getSaveDialogTitle() {
        return this.m_SaveDialogTitle;
    }

    public void setScale(double d, double d2) {
        this.m_xScale = d;
        this.m_yScale = d2;
    }

    public double getXScale() {
        return this.m_xScale;
    }

    public double getYScale() {
        return this.m_xScale;
    }

    public void saveComponent() {
        m_FileChooserPanel.setDialogTitle(this.getSaveDialogTitle());
        do {
            int n;
            if ((n = m_FileChooserPanel.showSaveDialog(this.getComponent())) == 0) continue;
            return;
        } while (m_FileChooserPanel.getSelectedFile() == null);
        try {
            JComponentWriterFileFilter jComponentWriterFileFilter = (JComponentWriterFileFilter)m_FileChooserPanel.getFileFilter();
            File file = m_FileChooserPanel.getSelectedFile();
            JComponentWriter jComponentWriter = jComponentWriterFileFilter.getWriter();
            if (!file.getAbsolutePath().toLowerCase().endsWith(jComponentWriter.getExtension().toLowerCase())) {
                file = new File(file.getAbsolutePath() + jComponentWriter.getExtension());
            }
            jComponentWriter.setComponent(this.getComponent());
            jComponentWriter.setFile(file);
            jComponentWriter.setScale(this.getXScale(), this.getYScale());
            jComponentWriter.setUseCustomDimensions(m_CustomDimensionsCheckBox.isSelected());
            if (m_CustomDimensionsCheckBox.isSelected()) {
                jComponentWriter.setCustomWidth(Integer.parseInt(m_CustomWidthText.getText()));
                jComponentWriter.setCustomHeight(Integer.parseInt(m_CustomHeightText.getText()));
            } else {
                jComponentWriter.setCustomWidth(-1);
                jComponentWriter.setCustomHeight(-1);
            }
            jComponentWriter.toOutput();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        m_ToolTipUserAsked = false;
        m_ShowToolTip = true;
        try {
            m_ShowToolTip = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_SHOW, "true"));
            m_ToolTipUserAsked = Boolean.valueOf(VisualizeUtils.VISUALIZE_PROPERTIES.getProperty(PROPERTY_USERASKED, "false"));
        }
        catch (Exception exception) {
            m_ToolTipUserAsked = false;
            m_ShowToolTip = true;
        }
    }

    private class PrintMouseListener
    extends MouseAdapter {
        private PrintableComponent m_Component;

        public PrintMouseListener(PrintableComponent printableComponent2) {
            this.m_Component = printableComponent2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if ((n & 1) == 1 && (n & 8) == 8 && (n & 0x10) == 16) {
                mouseEvent.consume();
                this.m_Component.saveComponent();
            }
        }
    }

    protected class JComponentWriterFileFilter
    extends ExtensionFileFilter {
        private JComponentWriter m_Writer;

        public JComponentWriterFileFilter(String string, String string2, JComponentWriter jComponentWriter) {
            super(string, string2);
            this.m_Writer = jComponentWriter;
        }

        public JComponentWriter getWriter() {
            return this.m_Writer;
        }
    }
}

