/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.ConverterUtils;
import weka.core.converters.IncrementalConverter;

public class C45Loader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 5454329403218219L;
    public static String FILE_EXTENSION = ".names";
    private File m_sourceFileData = null;
    private transient Reader m_namesReader = null;
    private transient Reader m_dataReader = null;
    private String m_fileStem;
    private int m_numAttribs;
    private boolean[] m_ignore;

    public String globalInfo() {
        return "Reads a file that is C45 format. Can take a filestem or filestem with .names or .data appended. Assumes that path/<filestem>.names and path/<filestem>.data exist and contain the names and data respectively.";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{".names", ".data"};
    }

    public String getFileDescription() {
        return "C4.5 data files";
    }

    public void setSource(File file) throws IOException {
        BufferedReader bufferedReader;
        String string;
        this.m_structure = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        String string2 = file.getName();
        String string3 = file.getParent();
        string3 = string3 != null ? string3 + File.separator : "";
        if (string2.indexOf(46) < 0) {
            string = string2;
            string2 = string2 + ".names";
        } else {
            string = string2.substring(0, string2.lastIndexOf(46));
            string2 = string + ".names";
        }
        this.m_fileStem = string;
        this.m_sourceFile = file = new File(string3 + string2);
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.m_namesReader = bufferedReader;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found : " + string3 + string2);
        }
        this.m_sourceFileData = new File(string3 + string + ".data");
        try {
            bufferedReader = new BufferedReader(new FileReader(this.m_sourceFileData));
            this.m_dataReader = bufferedReader;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File not found : " + string3 + string2);
        }
        this.m_File = file.getAbsolutePath();
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has beenspecified");
        }
        if (this.m_structure == null) {
            this.setSource(this.m_sourceFile);
            StreamTokenizer streamTokenizer = new StreamTokenizer(this.m_namesReader);
            this.initTokenizer(streamTokenizer);
            this.readHeader(streamTokenizer);
        }
        return this.m_structure;
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(this.m_dataReader);
        this.initTokenizer(streamTokenizer);
        Instances instances = new Instances(this.m_structure);
        Instance instance = this.getInstance(streamTokenizer);
        while (instance != null) {
            instances.add(instance);
            instance = this.getInstance(streamTokenizer);
        }
        try {
            this.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return instances;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        if (this.m_sourceFile == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(2);
        if (this.m_structure == null) {
            this.getStructure();
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(this.m_dataReader);
        this.initTokenizer(streamTokenizer);
        Instance instance = this.getInstance(streamTokenizer);
        if (instance != null) {
            instance.setDataset(this.m_structure);
        } else {
            try {
                this.reset();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return instance;
    }

    private Instance getInstance(StreamTokenizer streamTokenizer) throws IOException {
        double[] dArray = new double[this.m_structure.numAttributes()];
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            return null;
        }
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (i > 0) {
                ConverterUtils.getToken(streamTokenizer);
            }
            if (this.m_ignore[i]) continue;
            if (streamTokenizer.ttype == 63) {
                dArray[n++] = Instance.missingValue();
                continue;
            }
            String string = streamTokenizer.sval;
            if (i == this.m_numAttribs - 1 && string.charAt(string.length() - 1) == '.') {
                string = string.substring(0, string.length() - 1);
            }
            if (this.m_structure.attribute(n).isNominal()) {
                int n2 = this.m_structure.attribute(n).indexOfValue(string);
                if (n2 == -1) {
                    ConverterUtils.errms(streamTokenizer, "nominal value not declared in header :" + string + " column " + i);
                }
                dArray[n++] = n2;
                continue;
            }
            if (this.m_structure.attribute(n).isNumeric()) {
                try {
                    dArray[n++] = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    ConverterUtils.errms(streamTokenizer, "number expected");
                }
                continue;
            }
            System.err.println("Shouldn't get here");
            System.exit(1);
        }
        return new Instance(1.0, dArray);
    }

    private String removeTrailingPeriod(String string) {
        if (string.charAt(string.length() - 1) == '.') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void readHeader(StreamTokenizer streamTokenizer) throws IOException {
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        ConverterUtils.getFirstToken(streamTokenizer);
        if (streamTokenizer.ttype == -1) {
            ConverterUtils.errms(streamTokenizer, "premature end of file");
        }
        this.m_numAttribs = 1;
        FastVector fastVector3 = new FastVector();
        while (streamTokenizer.ttype != 10) {
            String string = streamTokenizer.sval.trim();
            if (string.length() > 0) {
                string = this.removeTrailingPeriod(string);
                fastVector3.addElement(string);
            }
            ConverterUtils.getToken(streamTokenizer);
        }
        int n = 0;
        while (streamTokenizer.ttype != -1) {
            String string;
            ConverterUtils.getFirstToken(streamTokenizer);
            if (streamTokenizer.ttype == -1) continue;
            String string2 = streamTokenizer.sval;
            ConverterUtils.getToken(streamTokenizer);
            if (streamTokenizer.ttype == 10) {
                ConverterUtils.errms(streamTokenizer, "premature end of line. Expected attribute type.");
            }
            if ((string = streamTokenizer.sval.toLowerCase().trim()).startsWith("ignore") || string.startsWith("label")) {
                fastVector2.addElement(new Integer(n));
                ++n;
                continue;
            }
            if (string.startsWith("continuous")) {
                fastVector.addElement(new Attribute(string2));
                ++n;
                continue;
            }
            ++n;
            FastVector fastVector4 = new FastVector();
            while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                String string3 = streamTokenizer.sval.trim();
                if (string3.length() > 0) {
                    string3 = this.removeTrailingPeriod(string3);
                    fastVector4.addElement(string3);
                }
                ConverterUtils.getToken(streamTokenizer);
            }
            fastVector.addElement(new Attribute(string2, fastVector4));
        }
        boolean bl = true;
        int n2 = -1;
        if (fastVector3.size() == 1) {
            for (n2 = 0; n2 < fastVector.size(); ++n2) {
                if (((Attribute)fastVector.elementAt(n2)).name().compareTo((String)fastVector3.elementAt(0)) != 0) continue;
                bl = false;
                --this.m_numAttribs;
                break;
            }
        }
        if (bl) {
            fastVector.addElement(new Attribute("Class", fastVector3));
        }
        this.m_structure = new Instances(this.m_fileStem, fastVector, 0);
        try {
            if (bl) {
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            } else {
                this.m_structure.setClassIndex(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_numAttribs = this.m_structure.numAttributes() + fastVector2.size();
        this.m_ignore = new boolean[this.m_numAttribs];
        for (n2 = 0; n2 < fastVector2.size(); ++n2) {
            this.m_ignore[((Integer)fastVector2.elementAt((int)n2)).intValue()] = true;
        }
    }

    private void initTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 31);
        streamTokenizer.wordChars(32, 255);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.whitespaceChars(58, 58);
        streamTokenizer.commentChar(124);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.eolIsSignificant(true);
    }

    public static void main(String[] stringArray) {
        C45Loader.runFileLoader(new C45Loader(), stringArray);
    }
}

