/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.ClassifierSubsetEval;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.attributeSelection.LFSMethods;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class SubsetSizeForwardSelection
extends ASSearch
implements OptionHandler {
    protected static final int TYPE_FIXED_SET = 0;
    protected static final int TYPE_FIXED_WIDTH = 1;
    public static final Tag[] TAGS_TYPE = new Tag[]{new Tag(0, "Fixed-set"), new Tag(1, "Fixed-width")};
    protected boolean m_performRanking;
    protected int m_numUsedAttributes;
    protected int m_linearSelectionType;
    private SubsetEvaluator m_setSizeEval;
    protected int m_numFolds;
    protected int m_seed;
    protected int m_numAttribs;
    protected int m_totalEvals;
    protected boolean m_verbose;
    protected double m_bestMerit;
    protected int m_cacheSize;

    public SubsetSizeForwardSelection() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "SubsetSizeForwardSelection:\n\nExtension of LinearForwardSelection. The search performs an interior cross-validation (seed and number of folds can be specified). A LinearForwardSelection is performed on each foldto determine the optimal subset-size (using the given SubsetSizeEvaluator). Finally, a LinearForwardSelection up to the optimal subset-size is performed on the whole data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Martin Guetlein");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2006");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Large Scale Attribute Selection Using Wrappers");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "Albert-Ludwigs-Universitat");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Freiburg, Germany");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(9);
        vector.addElement(new Option("\tPerform initial ranking to select the\n\ttop-ranked attributes.", "I", 0, "-I"));
        vector.addElement(new Option("\tNumber of top-ranked attributes that are \n\ttaken into account by the search.", "K", 1, "-K <num>"));
        vector.addElement(new Option("\tType of Linear Forward Selection (default = 0).", "T", 1, "-T <0 = fixed-set | 1 = fixed-width>"));
        vector.addElement(new Option("\tSize of lookup cache for evaluated subsets.\n\tExpressed as a multiple of the number of\n\tattributes in the data set. (default = 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tSubset-evaluator used for subset-size determination.-- -M", "E", 1, "-E <subset evaluator>"));
        vector.addElement(new Option("\tNumber of cross validation folds\n\tfor subset size determination (default = 5).", "F", 1, "-F <num>"));
        vector.addElement(new Option("\tSeed for cross validation\n\tsubset size determination. (default = 1)", "R", 1, "-R <num>"));
        vector.addElement(new Option("\tverbose on/off", "Z", 0, "-Z"));
        if (this.m_setSizeEval != null && this.m_setSizeEval instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to evaluator " + this.m_setSizeEval.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_setSizeEval)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setPerformRanking(Utils.getFlag('I', stringArray));
        String string = Utils.getOption('K', stringArray);
        if (string.length() != 0) {
            this.setNumUsedAttributes(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            this.setType(new SelectedTag(Integer.parseInt(string), TAGS_TYPE));
        } else {
            this.setType(new SelectedTag(0, TAGS_TYPE));
        }
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setLookupCacheSize(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('E', stringArray)).length() == 0) {
            System.out.println("No subset size evaluator given, using evaluator that is used for final search.");
            this.m_setSizeEval = null;
        } else {
            this.setSubsetSizeEvaluator(ASEvaluation.forName(string, Utils.partitionOptions(stringArray)));
        }
        string = Utils.getOption('F', stringArray);
        if (string.length() != 0) {
            this.setNumSubsetSizeCVFolds(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        this.m_verbose = Utils.getFlag('Z', stringArray);
    }

    public void setLookupCacheSize(int n) {
        if (n >= 0) {
            this.m_cacheSize = n;
        }
    }

    public int getLookupCacheSize() {
        return this.m_cacheSize;
    }

    public String lookupCacheSizeTipText() {
        return "Set the maximum size of the lookup cache of evaluated subsets. This is expressed as a multiplier of the number of attributes in the data set. (default = 1).";
    }

    public String performRankingTipText() {
        return "Perform initial ranking to select top-ranked attributes.";
    }

    public void setPerformRanking(boolean bl) {
        this.m_performRanking = bl;
    }

    public boolean getPerformRanking() {
        return this.m_performRanking;
    }

    public String numUsedAttributesTipText() {
        return "Set the amount of top-ranked attributes that are taken into account by the search process.";
    }

    public void setNumUsedAttributes(int n) throws Exception {
        if (n < 2) {
            throw new Exception("Value of -K must be >= 2.");
        }
        this.m_numUsedAttributes = n;
    }

    public int getNumUsedAttributes() {
        return this.m_numUsedAttributes;
    }

    public String typeTipText() {
        return "Set the type of the search.";
    }

    public void setType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TYPE) {
            this.m_linearSelectionType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getType() {
        return new SelectedTag(this.m_linearSelectionType, TAGS_TYPE);
    }

    public String subsetSizeEvaluatorTipText() {
        return "Subset evaluator to use for subset size determination.";
    }

    public void setSubsetSizeEvaluator(ASEvaluation aSEvaluation) throws Exception {
        if (!SubsetEvaluator.class.isInstance(aSEvaluation)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is no subset evaluator.");
        }
        this.m_setSizeEval = (SubsetEvaluator)aSEvaluation;
    }

    public ASEvaluation getSubsetSizeEvaluator() {
        return this.m_setSizeEval;
    }

    public String numSubsetSizeCVFoldsTipText() {
        return "Number of cross validation folds for subset size determination";
    }

    public void setNumSubsetSizeCVFolds(int n) {
        this.m_numFolds = n;
    }

    public int getNumSubsetSizeCVFolds() {
        return this.m_numFolds;
    }

    public String seedTipText() {
        return "Seed for cross validation subset size determination. (default = 1)";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String verboseTipText() {
        return "Turn on verbose output for monitoring the search's progress.";
    }

    public void setVerbose(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_setSizeEval != null && this.m_setSizeEval instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_setSizeEval)).getOptions();
        }
        String[] stringArray2 = new String[15 + stringArray.length];
        int n = 0;
        if (this.m_performRanking) {
            stringArray2[n++] = "-I";
        }
        stringArray2[n++] = "-K";
        stringArray2[n++] = "" + this.m_numUsedAttributes;
        stringArray2[n++] = "-T";
        stringArray2[n++] = "" + this.m_linearSelectionType;
        stringArray2[n++] = "-F";
        stringArray2[n++] = "" + this.m_numFolds;
        stringArray2[n++] = "-S";
        stringArray2[n++] = "" + this.m_seed;
        stringArray2[n++] = "-Z";
        stringArray2[n++] = "" + this.m_verbose;
        if (this.m_setSizeEval != null) {
            stringArray2[n++] = "-E";
            stringArray2[n++] = this.m_setSizeEval.getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tSubset Size Forward Selection.\n");
        stringBuffer.append("\tLinear Forward Selection Type: ");
        if (this.m_linearSelectionType == 0) {
            stringBuffer.append("fixed-set\n");
        } else {
            stringBuffer.append("fixed-width\n");
        }
        stringBuffer.append("\tNumber of top-ranked attributes that are used: " + this.m_numUsedAttributes + "\n");
        stringBuffer.append("\tNumber of cross validation folds for subset size determination: " + this.m_numFolds + "\n");
        stringBuffer.append("\tSeed for cross validation subset size determination: " + this.m_seed + "\n");
        stringBuffer.append("\tTotal number of subsets evaluated: " + this.m_totalEvals + "\n");
        stringBuffer.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        int n;
        int n2;
        int n3;
        int[] nArray;
        this.m_totalEvals = 0;
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (this.m_setSizeEval == null) {
            this.m_setSizeEval = (SubsetEvaluator)aSEvaluation;
        }
        this.m_numAttribs = instances.numAttributes();
        if (this.m_numUsedAttributes > this.m_numAttribs) {
            System.out.println("Decreasing number of top-ranked attributes to total number of attributes: " + instances.numAttributes());
            this.m_numUsedAttributes = this.m_numAttribs;
        }
        Instances[] instancesArray = new Instances[this.m_numFolds];
        Instances[] instancesArray2 = new Instances[this.m_numFolds];
        LFSMethods[] lFSMethodsArray = new LFSMethods[this.m_numFolds];
        Random random = new Random(this.m_seed);
        Instances instances2 = new Instances(instances);
        instances2.randomize(random);
        if (instances2.classAttribute().isNominal()) {
            instances2.stratify(this.m_numFolds);
        }
        for (int i = 0; i < this.m_numFolds; ++i) {
            instancesArray[i] = instances2.trainCV(this.m_numFolds, i, random);
            instancesArray2[i] = instances2.testCV(this.m_numFolds, i);
        }
        LFSMethods lFSMethods = new LFSMethods();
        if (this.m_performRanking) {
            ((SubsetEvaluator)aSEvaluation).buildEvaluator(instances);
            nArray = lFSMethods.rankAttributes(instances, (SubsetEvaluator)aSEvaluation, this.m_verbose);
        } else {
            nArray = new int[this.m_numAttribs];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.m_numFolds; ++n2) {
            if (this.m_verbose) {
                System.out.println("perform search on internal fold: " + (n2 + 1) + "/" + this.m_numFolds);
            }
            this.m_setSizeEval.buildEvaluator(instancesArray[n2]);
            lFSMethodsArray[n2] = new LFSMethods();
            lFSMethodsArray[n2].forwardSearch(this.m_cacheSize, new BitSet(this.m_numAttribs), nArray, this.m_numUsedAttributes, this.m_linearSelectionType == 1, 1, -1, instancesArray[n2], this.m_setSizeEval, this.m_verbose);
            n3 = Math.max(n3, lFSMethodsArray[n2].getBestGroup().cardinality());
        }
        if (this.m_verbose) {
            System.out.println("continue searches on internal folds to maxSubsetSize (" + n3 + ")");
        }
        for (n2 = 0; n2 < this.m_numFolds; ++n2) {
            if (this.m_verbose) {
                System.out.print("perform search on internal fold: " + (n2 + 1) + "/" + this.m_numFolds + " with starting set ");
                LFSMethods.printGroup(lFSMethodsArray[n2].getBestGroup(), instancesArray[n2].numAttributes());
            }
            if (lFSMethodsArray[n2].getBestGroup().cardinality() >= n3) continue;
            this.m_setSizeEval.buildEvaluator(instancesArray[n2]);
            lFSMethodsArray[n2].forwardSearch(this.m_cacheSize, lFSMethodsArray[n2].getBestGroup(), nArray, this.m_numUsedAttributes, this.m_linearSelectionType == 1, 1, n3, instancesArray[n2], this.m_setSizeEval, this.m_verbose);
        }
        double[][] dArray = new double[this.m_numFolds][n3 + 1];
        for (int i = 0; i < this.m_numFolds; ++i) {
            for (n = 1; n <= n3; ++n) {
                if (HoldOutSubsetEvaluator.class.isInstance(this.m_setSizeEval)) {
                    this.m_setSizeEval.buildEvaluator(instancesArray[i]);
                    dArray[i][n] = ((HoldOutSubsetEvaluator)this.m_setSizeEval).evaluateSubset(lFSMethodsArray[i].getBestGroupOfSize(n), instancesArray2[i]);
                    continue;
                }
                this.m_setSizeEval.buildEvaluator(instancesArray2[i]);
                dArray[i][n] = this.m_setSizeEval.evaluateSubset(lFSMethodsArray[i].getBestGroupOfSize(n));
            }
        }
        double[] dArray2 = new double[n3 + 1];
        n = -1;
        for (int i = 1; i <= n3; ++i) {
            for (int j = 0; j < this.m_numFolds; ++j) {
                dArray2[i] = (dArray2[i] * (double)j + dArray[j][i]) / (double)(j + 1);
            }
            if (n == -1 || dArray2[i] > dArray2[n]) {
                n = i;
            }
            if (!this.m_verbose) continue;
            System.out.println("average merit for subset-size " + i + ": " + dArray2[i]);
        }
        if (this.m_verbose) {
            System.out.println("performing final forward selection to subset-size: " + n);
        }
        ((SubsetEvaluator)aSEvaluation).buildEvaluator(instances);
        lFSMethods.forwardSearch(this.m_cacheSize, new BitSet(this.m_numAttribs), nArray, this.m_numUsedAttributes, this.m_linearSelectionType == 1, 1, n, instances, (SubsetEvaluator)aSEvaluation, this.m_verbose);
        this.m_totalEvals = lFSMethods.getNumEvalsTotal();
        this.m_bestMerit = lFSMethods.getBestMerit();
        return this.attributeList(lFSMethods.getBestGroup());
    }

    protected void resetOptions() {
        this.m_performRanking = true;
        this.m_numUsedAttributes = 50;
        this.m_linearSelectionType = 0;
        this.m_setSizeEval = new ClassifierSubsetEval();
        this.m_numFolds = 5;
        this.m_seed = 1;
        this.m_totalEvals = 0;
        this.m_cacheSize = 1;
        this.m_verbose = false;
    }

    protected int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }
}

