/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.RandomTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomCommittee
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler {
    static final long serialVersionUID = -9204394360557300092L;

    public RandomCommittee() {
        this.m_Classifier = new RandomTree();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.RandomTree";
    }

    public String globalInfo() {
        return "Class for building an ensemble of randomizable base classifiers. Each base classifiers is built using a different random number seed (but based one the same data). The final prediction is a straight average of the predictions generated by the individual base classifiers.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (!(this.m_Classifier instanceof Randomizable)) {
            throw new IllegalArgumentException("Base learner must implement Randomizable!");
        }
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, this.m_NumIterations);
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            this.m_Classifiers[i].buildClassifier(instances);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "RandomCommittee: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        RandomCommittee.runClassifier(new RandomCommittee(), stringArray);
    }
}

