/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.ClassDiscovery;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public class TestInstances
implements Cloneable,
Serializable,
OptionHandler {
    private static final long serialVersionUID = -6263968936330390469L;
    public static final int CLASS_IS_LAST = -1;
    public static final int NO_CLASS = -2;
    public static final String[] DEFAULT_WORDS = new String[]{"The", "quick", "brown", "fox", "jumps", "over", "the", "lazy", "dog"};
    public static final String DEFAULT_SEPARATORS = " ";
    protected String[] m_Words = DEFAULT_WORDS;
    protected String m_WordSeparators = " ";
    protected String m_Relation = "Testdata";
    protected int m_Seed = 1;
    protected Random m_Random = new Random(this.m_Seed);
    protected int m_NumInstances = 20;
    protected int m_ClassType = 1;
    protected int m_NumClasses = 2;
    protected int m_ClassIndex = -1;
    protected int m_NumNominal = 1;
    protected int m_NumNominalValues = 2;
    protected int m_NumNumeric = 0;
    protected int m_NumString = 0;
    protected int m_NumDate = 0;
    protected int m_NumRelational = 0;
    protected boolean m_MultiInstance = false;
    protected int m_NumInstancesRelational = 10;
    protected Instances[] m_RelationalFormat = null;
    protected Instances m_RelationalClassFormat = null;
    protected Instances m_Data = null;
    protected CapabilitiesHandler m_Handler = null;

    public TestInstances() {
        this.setRelation("Testdata");
        this.setSeed(1);
        this.setNumInstances(20);
        this.setClassType(1);
        this.setNumClasses(2);
        this.setClassIndex(-1);
        this.setNumNominal(1);
        this.setNumNominalValues(2);
        this.setNumNumeric(0);
        this.setNumString(0);
        this.setNumDate(0);
        this.setNumRelational(0);
        this.setNumInstancesRelational(10);
        this.setMultiInstance(false);
        this.setWords(TestInstances.arrayToList(DEFAULT_WORDS));
        this.setWordSeparators(DEFAULT_SEPARATORS);
    }

    public Object clone() {
        TestInstances testInstances = new TestInstances();
        testInstances.assign(this);
        return testInstances;
    }

    public void assign(TestInstances testInstances) {
        this.setRelation(testInstances.getRelation());
        this.setSeed(testInstances.getSeed());
        this.setNumInstances(testInstances.getNumInstances());
        this.setClassType(testInstances.getClassType());
        this.setNumClasses(testInstances.getNumClasses());
        this.setClassIndex(testInstances.getClassIndex());
        this.setNumNominal(testInstances.getNumNominal());
        this.setNumNominalValues(testInstances.getNumNominalValues());
        this.setNumNumeric(testInstances.getNumNumeric());
        this.setNumString(testInstances.getNumString());
        this.setNumDate(testInstances.getNumDate());
        this.setNumRelational(testInstances.getNumRelational());
        this.setMultiInstance(testInstances.getMultiInstance());
        for (int i = 0; i < testInstances.getNumRelational(); ++i) {
            this.setRelationalFormat(i, testInstances.getRelationalFormat(i));
        }
        this.setRelationalClassFormat(testInstances.getRelationalClassFormat());
        this.setNumInstancesRelational(testInstances.getNumInstancesRelational());
        this.setWords(testInstances.getWords());
        this.setWordSeparators(testInstances.getWordSeparators());
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe name of the data set.", "relation", 1, "-relation <name>"));
        vector.addElement(new Option("\tThe seed value.", "seed", 1, "-seed <num>"));
        vector.addElement(new Option("\tThe number of instances in the datasets (default 20).", "num-instances", 1, "-num-instances <num>"));
        vector.addElement(new Option("\tThe class type, see constants in weka.core.Attribute\n\t(default 1=nominal).", "class-type", 1, "-class-type <num>"));
        vector.addElement(new Option("\tThe number of classes to generate (for nominal classes only)\n\t(default 2).", "class-values", 1, "-classes-values <num>"));
        vector.addElement(new Option("\tThe class index, with -1=last, (default -1).", "class-index", 1, "-class-index <num>"));
        vector.addElement(new Option("\tDoesn't include a class attribute in the output.", "no-class", 0, "-no-class"));
        vector.addElement(new Option("\tThe number of nominal attributes (default 1).", "nominal", 1, "-nominal <num>"));
        vector.addElement(new Option("\tThe number of values for nominal attributes (default 2).", "nominal-values", 1, "-nominal-values <num>"));
        vector.addElement(new Option("\tThe number of numeric attributes (default 0).", "numeric", 1, "-numeric <num>"));
        vector.addElement(new Option("\tThe number of string attributes (default 0).", "string", 1, "-string <num>"));
        vector.addElement(new Option("\tThe words to use in string attributes.", "words", 1, "-words <comma-separated-list>"));
        vector.addElement(new Option("\tThe word separators to use in string attributes.", "word-separators", 1, "-word-separators <chars>"));
        vector.addElement(new Option("\tThe number of date attributes (default 0).", "date", 1, "-date <num>"));
        vector.addElement(new Option("\tThe number of relational attributes (default 0).", "relational", 1, "-relational <num>"));
        vector.addElement(new Option("\tThe number of instances in relational/bag attributes (default 10).", "num-instances-relational", 1, "-num-instances-relational <num>"));
        vector.addElement(new Option("\tGenerates multi-instance data.", "multi-instance", 0, "-multi-instance"));
        vector.addElement(new Option("\tThe Capabilities handler to base the dataset on.\n\tThe other parameters can be used to override the ones\n\tdetermined from the handler. Additional parameters for\n\thandler can be passed on after the '--'.", "W", 1, "-W <classname>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            Class<?> clazz = Class.forName(string);
            if (ClassDiscovery.hasInterface(CapabilitiesHandler.class, clazz)) {
                bl = true;
                CapabilitiesHandler capabilitiesHandler = (CapabilitiesHandler)clazz.newInstance();
                if (capabilitiesHandler instanceof OptionHandler) {
                    ((OptionHandler)((Object)capabilitiesHandler)).setOptions(Utils.partitionOptions(stringArray));
                }
                this.setHandler(capabilitiesHandler);
                this.assign(TestInstances.forCapabilities(capabilitiesHandler.getCapabilities()));
            } else {
                throw new IllegalArgumentException("Class '" + string + "' is not a CapabilitiesHandler!");
            }
        }
        if ((string = Utils.getOption("relation", stringArray)).length() != 0) {
            this.setRelation(string);
        } else if (!bl) {
            this.setRelation("Testdata");
        }
        string = Utils.getOption("seed", stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else if (!bl) {
            this.setSeed(1);
        }
        string = Utils.getOption("num-instances", stringArray);
        if (string.length() != 0) {
            this.setNumInstances(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumInstances(20);
        }
        this.setNoClass(Utils.getFlag("no-class", stringArray));
        if (!this.getNoClass()) {
            string = Utils.getOption("class-type", stringArray);
            if (string.length() != 0) {
                this.setClassType(Integer.parseInt(string));
            } else if (!bl) {
                this.setClassType(1);
            }
            string = Utils.getOption("class-values", stringArray);
            if (string.length() != 0) {
                this.setNumClasses(Integer.parseInt(string));
            } else if (!bl) {
                this.setNumClasses(2);
            }
            string = Utils.getOption("class-index", stringArray);
            if (string.length() != 0) {
                this.setClassIndex(Integer.parseInt(string));
            } else if (!bl) {
                this.setClassIndex(-1);
            }
        }
        if ((string = Utils.getOption("nominal", stringArray)).length() != 0) {
            this.setNumNominal(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumNominal(1);
        }
        string = Utils.getOption("nominal-values", stringArray);
        if (string.length() != 0) {
            this.setNumNominalValues(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumNominalValues(2);
        }
        string = Utils.getOption("numeric", stringArray);
        if (string.length() != 0) {
            this.setNumNumeric(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumNumeric(0);
        }
        string = Utils.getOption("string", stringArray);
        if (string.length() != 0) {
            this.setNumString(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumString(0);
        }
        string = Utils.getOption("words", stringArray);
        if (string.length() != 0) {
            this.setWords(string);
        } else if (!bl) {
            this.setWords(TestInstances.arrayToList(DEFAULT_WORDS));
        }
        if (Utils.getOptionPos("word-separators", stringArray) > -1) {
            string = Utils.getOption("word-separators", stringArray);
            this.setWordSeparators(string);
        } else if (!bl) {
            this.setWordSeparators(DEFAULT_SEPARATORS);
        }
        string = Utils.getOption("date", stringArray);
        if (string.length() != 0) {
            this.setNumDate(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumDate(0);
        }
        string = Utils.getOption("relational", stringArray);
        if (string.length() != 0) {
            this.setNumRelational(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumRelational(0);
        }
        string = Utils.getOption("num-instances-relational", stringArray);
        if (string.length() != 0) {
            this.setNumInstancesRelational(Integer.parseInt(string));
        } else if (!bl) {
            this.setNumInstancesRelational(10);
        }
        if (!bl) {
            this.setMultiInstance(Utils.getFlag("multi-instance", stringArray));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-relation");
        vector.add(this.getRelation());
        vector.add("-seed");
        vector.add("" + this.getSeed());
        vector.add("-num-instances");
        vector.add("" + this.getNumInstances());
        if (this.getNoClass()) {
            vector.add("-no-class");
        } else {
            vector.add("-class-type");
            vector.add("" + this.getClassType());
            vector.add("-class-values");
            vector.add("" + this.getNumClasses());
            vector.add("-class-index");
            vector.add("" + this.getClassIndex());
        }
        vector.add("-nominal");
        vector.add("" + this.getNumNominal());
        vector.add("-nominal-values");
        vector.add("" + this.getNumNominalValues());
        vector.add("-numeric");
        vector.add("" + this.getNumNumeric());
        vector.add("-string");
        vector.add("" + this.getNumString());
        vector.add("-words");
        vector.add("" + this.getWords());
        vector.add("-word-separators");
        vector.add("" + this.getWordSeparators());
        vector.add("-date");
        vector.add("" + this.getNumDate());
        vector.add("-relation");
        vector.add("" + this.getNumRelational());
        vector.add("-num-instances-relational");
        vector.add("" + this.getNumInstancesRelational());
        if (this.getMultiInstance()) {
            vector.add("-multi-instance");
        }
        if (this.getHandler() != null) {
            vector.add("-W");
            vector.add(this.getHandler().getClass().getName());
            if (this.getHandler() instanceof OptionHandler) {
                vector.add("--");
                String[] stringArray = ((OptionHandler)((Object)this.getHandler())).getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setRelation(String string) {
        this.m_Relation = string;
    }

    public String getRelation() {
        return this.m_Relation;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
        this.m_Random = new Random(this.m_Seed);
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setNumInstances(int n) {
        this.m_NumInstances = n;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setClassType(int n) {
        this.m_ClassType = n;
        this.m_RelationalClassFormat = null;
    }

    public int getClassType() {
        return this.m_ClassType;
    }

    public void setNumClasses(int n) {
        this.m_NumClasses = n;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public void setNoClass(boolean bl) {
        if (bl) {
            this.setClassIndex(-2);
        } else {
            this.setClassIndex(-1);
        }
    }

    public boolean getNoClass() {
        return this.getClassIndex() == -2;
    }

    public void setNumNominal(int n) {
        this.m_NumNominal = n;
    }

    public int getNumNominal() {
        return this.m_NumNominal;
    }

    public void setNumNominalValues(int n) {
        this.m_NumNominalValues = n;
    }

    public int getNumNominalValues() {
        return this.m_NumNominalValues;
    }

    public void setNumNumeric(int n) {
        this.m_NumNumeric = n;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumString(int n) {
        this.m_NumString = n;
    }

    public int getNumString() {
        return this.m_NumString;
    }

    protected static String[] listToArray(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected static String arrayToList(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    public void setWords(String string) {
        if (TestInstances.listToArray(string).length < 2) {
            throw new IllegalArgumentException("At least 2 words must be provided!");
        }
        this.m_Words = TestInstances.listToArray(string);
    }

    public String getWords() {
        return TestInstances.arrayToList(this.m_Words);
    }

    public void setWordSeparators(String string) {
        this.m_WordSeparators = string;
    }

    public String getWordSeparators() {
        return this.m_WordSeparators;
    }

    public void setNumDate(int n) {
        this.m_NumDate = n;
    }

    public int getNumDate() {
        return this.m_NumDate;
    }

    public void setNumRelational(int n) {
        this.m_NumRelational = n;
        this.m_RelationalFormat = new Instances[n];
    }

    public int getNumRelational() {
        return this.m_NumRelational;
    }

    public void setNumInstancesRelational(int n) {
        this.m_NumInstancesRelational = n;
    }

    public int getNumInstancesRelational() {
        return this.m_NumInstancesRelational;
    }

    public void setMultiInstance(boolean bl) {
        this.m_MultiInstance = bl;
    }

    public boolean getMultiInstance() {
        return this.m_MultiInstance;
    }

    public void setRelationalFormat(int n, Instances instances) {
        this.m_RelationalFormat[n] = instances != null ? new Instances(instances, 0) : null;
    }

    public Instances getRelationalFormat(int n) {
        return this.m_RelationalFormat[n];
    }

    public void setRelationalClassFormat(Instances instances) {
        this.m_RelationalClassFormat = instances != null ? new Instances(instances, 0) : null;
    }

    public Instances getRelationalClassFormat() {
        return this.m_RelationalClassFormat;
    }

    public int getNumAttributes() {
        int n = this.m_NumNominal + this.m_NumNumeric + this.m_NumString + this.m_NumDate + this.m_NumRelational;
        if (!this.getNoClass()) {
            ++n;
        }
        return n;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setHandler(CapabilitiesHandler capabilitiesHandler) {
        this.m_Handler = capabilitiesHandler;
    }

    public CapabilitiesHandler getHandler() {
        return this.m_Handler;
    }

    protected Attribute generateAttribute(int n, int n2) throws Exception {
        int n3;
        String string;
        String string2;
        int n4;
        Attribute attribute = null;
        if (n == -1) {
            n4 = 0;
            string2 = "Class";
            string = "class";
            n3 = this.getNumClasses();
        } else {
            n4 = n;
            n3 = this.getNumNominalValues();
            string = "att" + (n4 + 1) + "val";
            switch (n2) {
                case 1: {
                    string2 = "Nominal" + (n4 + 1);
                    break;
                }
                case 0: {
                    string2 = "Numeric" + (n4 + 1);
                    break;
                }
                case 2: {
                    string2 = "String" + (n4 + 1);
                    break;
                }
                case 3: {
                    string2 = "Date" + (n4 + 1);
                    break;
                }
                case 4: {
                    string2 = "Relational" + (n4 + 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Attribute type '" + n2 + "' unknown!");
                }
            }
        }
        switch (n2) {
            case 1: {
                FastVector fastVector = new FastVector(n4 + 1);
                for (int i = 0; i < n3; ++i) {
                    fastVector.addElement(string + (i + 1));
                }
                attribute = new Attribute(string2, fastVector);
                break;
            }
            case 0: {
                attribute = new Attribute(string2);
                break;
            }
            case 2: {
                attribute = new Attribute(string2, (FastVector)null);
                break;
            }
            case 3: {
                attribute = new Attribute(string2, "yyyy-mm-dd");
                break;
            }
            case 4: {
                Instances instances = n == -1 ? this.getRelationalClassFormat() : this.getRelationalFormat(n);
                if (instances == null) {
                    TestInstances testInstances = (TestInstances)this.clone();
                    testInstances.setMultiInstance(false);
                    testInstances.setNumRelational(0);
                    testInstances.setNumInstances(0);
                    testInstances.setClassType(1);
                    instances = new Instances(testInstances.generate());
                    if (!this.getNoClass()) {
                        int n5 = instances.classIndex();
                        instances.setClassIndex(-1);
                        instances.deleteAttributeAt(n5);
                    }
                }
                attribute = new Attribute(string2, instances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute type '" + n2 + "' unknown!");
            }
        }
        return attribute;
    }

    protected double generateClassValue(Instances instances) throws Exception {
        double d = Double.NaN;
        switch (this.m_ClassType) {
            case 0: {
                d = (double)this.m_Random.nextFloat() * 0.25 + (double)(Math.abs(this.m_Random.nextInt()) % Math.max(2, this.m_NumNominal));
                break;
            }
            case 1: {
                d = Math.abs(this.m_Random.nextInt()) % instances.numClasses();
                break;
            }
            case 2: {
                String string = "";
                for (int i = 0; i < this.m_Words.length; ++i) {
                    if (i > 0 && this.m_WordSeparators.length() != 0) {
                        string = string + this.m_WordSeparators.charAt(this.m_Random.nextInt(this.m_WordSeparators.length()));
                    }
                    string = string + this.m_Words[this.m_Random.nextInt(this.m_Words.length)];
                }
                d = instances.classAttribute().addStringValue(string);
                break;
            }
            case 3: {
                d = instances.classAttribute().parseDate(2000 + this.m_Random.nextInt(100) + "-01-01");
                break;
            }
            case 4: {
                if (this.getRelationalClassFormat() != null) {
                    d = instances.classAttribute().addRelation(this.getRelationalClassFormat());
                    break;
                }
                TestInstances testInstances = (TestInstances)this.clone();
                testInstances.setMultiInstance(false);
                testInstances.setNumRelational(0);
                testInstances.setClassType(1);
                Instances instances2 = new Instances(testInstances.generate());
                int n = instances2.classIndex();
                instances2.setClassIndex(-1);
                instances2.deleteAttributeAt(n);
                d = instances.classAttribute().addRelation(instances2);
            }
        }
        return d;
    }

    protected double generateAttributeValue(Instances instances, int n, double d) throws Exception {
        double d2 = Double.NaN;
        switch (instances.attribute(n).type()) {
            case 0: {
                d2 = d * 4.0 + (double)(this.m_Random.nextFloat() * 1.0f) - 0.5;
                break;
            }
            case 1: {
                if ((double)this.m_Random.nextFloat() < 0.2) {
                    d2 = Math.abs(this.m_Random.nextInt()) % instances.attribute(n).numValues();
                    break;
                }
                d2 = (int)d % instances.attribute(n).numValues();
                break;
            }
            case 2: {
                String string = "";
                for (int i = 0; i < this.m_Words.length; ++i) {
                    if (i > 0 && this.m_WordSeparators.length() != 0) {
                        string = string + this.m_WordSeparators.charAt(this.m_Random.nextInt(this.m_WordSeparators.length()));
                    }
                    string = string + this.m_Words[this.m_Random.nextInt(this.m_Words.length)];
                }
                d2 = instances.attribute(n).addStringValue(string);
                break;
            }
            case 3: {
                d2 = instances.attribute(n).parseDate(2000 + this.m_Random.nextInt(100) + "-01-01");
                break;
            }
            case 4: {
                Instances instances2 = new Instances(instances.attribute(n).relation(), 0);
                for (int i = 0; i < this.getNumInstancesRelational(); ++i) {
                    Instance instance = new Instance(instances2.numAttributes());
                    instance.setDataset(instances);
                    for (int j = 0; j < instances2.numAttributes(); ++j) {
                        instance.setValue(j, this.generateAttributeValue(instances2, j, 0.0));
                    }
                    instances2.add(instance);
                }
                d2 = instances.attribute(n).addRelation(instances2);
            }
        }
        return d2;
    }

    public Instances generate() throws Exception {
        if (this.getMultiInstance()) {
            TestInstances testInstances = (TestInstances)this.clone();
            testInstances.setMultiInstance(false);
            testInstances.setNumInstances(0);
            testInstances.setSeed(this.m_Random.nextInt());
            Instances instances = testInstances.generate();
            instances.setClassIndex(-1);
            instances.deleteAttributeAt(instances.numAttributes() - 1);
            TestInstances testInstances2 = new TestInstances();
            testInstances2.setSeed(this.m_Random.nextInt());
            testInstances2.setNumNominal(1);
            testInstances2.setNumRelational(1);
            testInstances2.setRelationalFormat(0, instances);
            testInstances2.setClassType(this.getClassType());
            testInstances2.setNumClasses(this.getNumClasses());
            testInstances2.setRelationalClassFormat(this.getRelationalClassFormat());
            testInstances2.setNumInstances(this.getNumInstances());
            this.m_Data = testInstances2.generate();
            testInstances.setNumInstances(this.getNumInstancesRelational());
            for (int i = 0; i < this.getNumInstances(); ++i) {
                testInstances.setSeed(this.m_Random.nextInt());
                Instances instances2 = new Instances(testInstances.generate());
                instances2.setClassIndex(-1);
                instances2.deleteAttributeAt(instances2.numAttributes() - 1);
                double d = this.m_Data.attribute(1).addRelation(instances2);
                this.m_Data.instance(i).setValue(1, d);
            }
        } else {
            int n;
            int n2 = this.m_ClassIndex;
            if (n2 == -1) {
                n2 = this.getNumAttributes() - 1;
            }
            FastVector fastVector = new FastVector(this.getNumAttributes());
            for (n = 0; n < this.getNumNominal(); ++n) {
                fastVector.addElement(this.generateAttribute(n, 1));
            }
            for (n = 0; n < this.getNumNumeric(); ++n) {
                fastVector.addElement(this.generateAttribute(n, 0));
            }
            for (n = 0; n < this.getNumString(); ++n) {
                fastVector.addElement(this.generateAttribute(n, 2));
            }
            for (n = 0; n < this.getNumDate(); ++n) {
                fastVector.addElement(this.generateAttribute(n, 3));
            }
            for (n = 0; n < this.getNumRelational(); ++n) {
                fastVector.addElement(this.generateAttribute(n, 4));
            }
            if (n2 != -2) {
                fastVector.insertElementAt(this.generateAttribute(-1, this.getClassType()), n2);
            }
            this.m_Data = new Instances(this.getRelation(), fastVector, this.getNumInstances());
            this.m_Data.setClassIndex(n2);
            for (n = 0; n < this.getNumInstances(); ++n) {
                double d;
                Instance instance = new Instance(this.getNumAttributes());
                instance.setDataset(this.m_Data);
                if (n2 != -2) {
                    d = this.generateClassValue(this.m_Data);
                    instance.setClassValue(d);
                } else {
                    d = this.m_Random.nextFloat();
                }
                for (int i = 0; i < this.getNumAttributes(); ++i) {
                    if (n2 == i) continue;
                    instance.setValue(i, this.generateAttributeValue(this.m_Data, i, d));
                }
                this.m_Data.add(instance);
            }
        }
        return this.getData();
    }

    public static TestInstances forCapabilities(Capabilities capabilities) {
        TestInstances testInstances = new TestInstances();
        if (capabilities.getOwner() instanceof MultiInstanceCapabilitiesHandler) {
            testInstances = TestInstances.forCapabilities(((MultiInstanceCapabilitiesHandler)capabilities.getOwner()).getMultiInstanceCapabilities());
            testInstances.setMultiInstance(true);
        } else {
            if (capabilities.handles(Capabilities.Capability.NO_CLASS)) {
                testInstances.setClassIndex(-2);
            } else if (capabilities.handles(Capabilities.Capability.NOMINAL_CLASS)) {
                testInstances.setClassType(1);
            } else if (capabilities.handles(Capabilities.Capability.BINARY_CLASS)) {
                testInstances.setClassType(1);
            } else if (capabilities.handles(Capabilities.Capability.NUMERIC_CLASS)) {
                testInstances.setClassType(0);
            } else if (capabilities.handles(Capabilities.Capability.DATE_CLASS)) {
                testInstances.setClassType(3);
            } else if (capabilities.handles(Capabilities.Capability.STRING_CLASS)) {
                testInstances.setClassType(2);
            } else if (capabilities.handles(Capabilities.Capability.RELATIONAL_CLASS)) {
                testInstances.setClassType(4);
            }
            if (capabilities.handles(Capabilities.Capability.BINARY_CLASS)) {
                testInstances.setNumClasses(2);
            }
            if (capabilities.handles(Capabilities.Capability.NOMINAL_CLASS)) {
                testInstances.setNumClasses(4);
            }
            if (capabilities.handles(Capabilities.Capability.NOMINAL_ATTRIBUTES)) {
                testInstances.setNumNominal(1);
            }
            if (capabilities.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
                testInstances.setNumNumeric(1);
            }
            if (capabilities.handles(Capabilities.Capability.DATE_ATTRIBUTES)) {
                testInstances.setNumDate(1);
            }
            if (capabilities.handles(Capabilities.Capability.STRING_ATTRIBUTES)) {
                testInstances.setNumString(1);
            }
            if (capabilities.handles(Capabilities.Capability.RELATIONAL_ATTRIBUTES)) {
                testInstances.setNumRelational(1);
            }
        }
        return testInstances;
    }

    public String toString() {
        String string = "";
        string = string + "Relation: " + this.getRelation() + "\n";
        string = string + "Seed: " + this.getSeed() + "\n";
        string = string + "# Instances: " + this.getNumInstances() + "\n";
        string = string + "ClassType: " + this.getClassType() + "\n";
        string = string + "# Classes: " + this.getNumClasses() + "\n";
        string = string + "Class index: " + this.getClassIndex() + "\n";
        string = string + "# Nominal: " + this.getNumNominal() + "\n";
        string = string + "# Nominal values: " + this.getNumNominalValues() + "\n";
        string = string + "# Numeric: " + this.getNumNumeric() + "\n";
        string = string + "# String: " + this.getNumString() + "\n";
        string = string + "# Date: " + this.getNumDate() + "\n";
        string = string + "# Relational: " + this.getNumRelational() + "\n";
        string = string + "# Relational Instances: " + this.getNumInstancesRelational() + "\n";
        string = string + "Multi-Instance: " + this.getMultiInstance() + "\n";
        string = string + "Words: " + this.getWords() + "\n";
        string = string + "Word separators: " + this.getWordSeparators() + "\n";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        TestInstances testInstances = new TestInstances();
        if (Utils.getFlag("h", stringArray) || Utils.getFlag("help", stringArray)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\nTest data generator options:\n\n");
            stringBuffer.append("-h|-help\n\tprints this help\n");
            Enumeration enumeration = testInstances.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + "\n" + option.description() + "\n");
            }
            System.out.println(stringBuffer);
            System.exit(0);
        }
        testInstances.setOptions(stringArray);
        System.out.println(testInstances.generate());
    }
}

