/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.rmi.Naming;
import java.util.Vector;
import javax.swing.JFrame;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Queue;
import weka.core.Utils;
import weka.experiment.Compute;
import weka.experiment.RemoteExperimentEvent;
import weka.experiment.RemoteExperimentListener;
import weka.experiment.TaskStatusInfo;
import weka.gui.boundaryvisualizer.BoundaryPanel;
import weka.gui.boundaryvisualizer.KDDataGenerator;
import weka.gui.boundaryvisualizer.RemoteBoundaryVisualizerSubTask;
import weka.gui.boundaryvisualizer.RemoteResult;

public class BoundaryPanelDistributed
extends BoundaryPanel {
    protected Vector m_listeners = new Vector();
    protected Vector m_remoteHosts = new Vector();
    private Queue m_remoteHostsQueue = new Queue();
    private int[] m_remoteHostsStatus;
    private int[] m_remoteHostFailureCounts;
    protected static final int AVAILABLE = 0;
    protected static final int IN_USE = 1;
    protected static final int CONNECTION_FAILED = 2;
    protected static final int SOME_OTHER_FAILURE = 3;
    protected static final int MAX_FAILURES = 3;
    private boolean m_plottingAborted = false;
    private int m_removedHosts;
    private int m_failedCount;
    private int m_finishedCount;
    private Queue m_subExpQueue = new Queue();
    private int m_minTaskPollTime = 1000;
    private int[] m_hostPollingTime;

    public BoundaryPanelDistributed(int n, int n2) {
        super(n, n2);
    }

    public void setRemoteHosts(Vector vector) {
        this.m_remoteHosts = vector;
    }

    public void addRemoteExperimentListener(RemoteExperimentListener remoteExperimentListener) {
        this.m_listeners.addElement(remoteExperimentListener);
    }

    protected void initialize() {
        int n;
        super.initialize();
        this.m_plottingAborted = false;
        this.m_finishedCount = 0;
        this.m_failedCount = 0;
        this.m_remoteHostsStatus = new int[this.m_remoteHosts.size()];
        this.m_remoteHostFailureCounts = new int[this.m_remoteHosts.size()];
        this.m_remoteHostsQueue = new Queue();
        if (this.m_remoteHosts.size() == 0) {
            System.err.println("No hosts specified!");
            System.exit(1);
        }
        this.m_hostPollingTime = new int[this.m_remoteHosts.size()];
        for (n = 0; n < this.m_remoteHosts.size(); ++n) {
            this.m_remoteHostsQueue.push(new Integer(n));
            this.m_hostPollingTime[n] = this.m_minTaskPollTime;
        }
        this.m_subExpQueue = new Queue();
        for (n = 0; n < this.m_panelHeight; ++n) {
            this.m_subExpQueue.push(new Integer(n));
        }
        try {
            this.m_classifier.buildClassifier(this.m_trainingData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        boolean[] blArray = new boolean[this.m_trainingData.numAttributes()];
        blArray[this.m_xAttribute] = true;
        blArray[this.m_yAttribute] = true;
        this.m_dataGenerator.setWeightingDimensions(blArray);
        try {
            this.m_dataGenerator.buildGenerator(this.m_trainingData);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void start() throws Exception {
        this.m_stopReplotting = true;
        if (this.m_trainingData == null) {
            throw new Exception("No training data set (BoundaryPanel)");
        }
        if (this.m_classifier == null) {
            throw new Exception("No classifier set (BoundaryPanel)");
        }
        if (this.m_dataGenerator == null) {
            throw new Exception("No data generator set (BoundaryPanel)");
        }
        if (this.m_trainingData.attribute(this.m_xAttribute).isNominal() || this.m_trainingData.attribute(this.m_yAttribute).isNominal()) {
            throw new Exception("Visualization dimensions must be numeric (BoundaryPanel)");
        }
        this.computeMinMaxAtts();
        this.initialize();
        int n = this.m_remoteHostsQueue.size();
        for (int i = 0; i < n; ++i) {
            this.availableHost(-1);
            Thread.sleep(70L);
        }
    }

    protected synchronized void availableHost(int n) {
        if (n >= 0) {
            if (this.m_remoteHostFailureCounts[n] < 3) {
                this.m_remoteHostsQueue.push(new Integer(n));
            } else {
                this.notifyListeners(false, true, false, "Max failures exceeded for host " + (String)this.m_remoteHosts.elementAt(n) + ". Removed from host list.");
                ++this.m_removedHosts;
            }
        }
        if (this.m_failedCount == 3 * this.m_remoteHosts.size()) {
            this.m_plottingAborted = true;
            this.notifyListeners(false, true, true, "Plotting aborted! Max failures exceeded on all remote hosts.");
            return;
        }
        if (this.m_subExpQueue.size() == 0 && this.m_remoteHosts.size() == this.m_remoteHostsQueue.size() + this.m_removedHosts) {
            if (this.m_plotTrainingData) {
                this.plotTrainingData();
            }
            this.notifyListeners(false, true, true, "Plotting completed successfully.");
            return;
        }
        if (this.checkForAllFailedHosts()) {
            return;
        }
        if (this.m_plottingAborted && this.m_remoteHostsQueue.size() + this.m_removedHosts == this.m_remoteHosts.size()) {
            this.notifyListeners(false, true, true, "Plotting aborted. All remote tasks finished.");
        }
        if (!(this.m_subExpQueue.empty() || this.m_plottingAborted || this.m_remoteHostsQueue.empty())) {
            try {
                int n2 = (Integer)this.m_remoteHostsQueue.pop();
                int n3 = (Integer)this.m_subExpQueue.pop();
                this.launchNext(n3, n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private synchronized void notifyListeners(boolean bl, boolean bl2, boolean bl3, String string) {
        if (this.m_listeners.size() > 0) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                RemoteExperimentListener remoteExperimentListener = (RemoteExperimentListener)this.m_listeners.elementAt(i);
                remoteExperimentListener.remoteExperimentStatus(new RemoteExperimentEvent(bl, bl2, bl3, string));
            }
        } else {
            System.err.println(string);
        }
    }

    private boolean checkForAllFailedHosts() {
        boolean bl = true;
        for (int i = 0; i < this.m_remoteHostsStatus.length; ++i) {
            if (this.m_remoteHostsStatus[i] == 2) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.m_plottingAborted = true;
            this.notifyListeners(false, true, true, "Plotting aborted! All connections to remote hosts failed.");
        }
        return bl;
    }

    protected synchronized void incrementFinished() {
        ++this.m_finishedCount;
    }

    protected synchronized void incrementFailed(int n) {
        ++this.m_failedCount;
        int n2 = n;
        this.m_remoteHostFailureCounts[n2] = this.m_remoteHostFailureCounts[n2] + 1;
    }

    protected synchronized void waitingTask(int n) {
        this.m_subExpQueue.push(new Integer(n));
    }

    protected void launchNext(final int n, final int n2) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[n2] = 1;
                RemoteBoundaryVisualizerSubTask remoteBoundaryVisualizerSubTask = new RemoteBoundaryVisualizerSubTask();
                remoteBoundaryVisualizerSubTask.setXAttribute(BoundaryPanelDistributed.this.m_xAttribute);
                remoteBoundaryVisualizerSubTask.setYAttribute(BoundaryPanelDistributed.this.m_yAttribute);
                remoteBoundaryVisualizerSubTask.setRowNumber(n);
                remoteBoundaryVisualizerSubTask.setPanelWidth(BoundaryPanelDistributed.this.m_panelWidth);
                remoteBoundaryVisualizerSubTask.setPanelHeight(BoundaryPanelDistributed.this.m_panelHeight);
                remoteBoundaryVisualizerSubTask.setPixHeight(BoundaryPanelDistributed.this.m_pixHeight);
                remoteBoundaryVisualizerSubTask.setPixWidth(BoundaryPanelDistributed.this.m_pixWidth);
                remoteBoundaryVisualizerSubTask.setClassifier(BoundaryPanelDistributed.this.m_classifier);
                remoteBoundaryVisualizerSubTask.setDataGenerator(BoundaryPanelDistributed.this.m_dataGenerator);
                remoteBoundaryVisualizerSubTask.setInstances(BoundaryPanelDistributed.this.m_trainingData);
                remoteBoundaryVisualizerSubTask.setMinMaxX(BoundaryPanelDistributed.this.m_minX, BoundaryPanelDistributed.this.m_maxX);
                remoteBoundaryVisualizerSubTask.setMinMaxY(BoundaryPanelDistributed.this.m_minY, BoundaryPanelDistributed.this.m_maxY);
                remoteBoundaryVisualizerSubTask.setNumSamplesPerRegion(BoundaryPanelDistributed.this.m_numOfSamplesPerRegion);
                remoteBoundaryVisualizerSubTask.setGeneratorSamplesBase(BoundaryPanelDistributed.this.m_samplesBase);
                try {
                    String string = "//" + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(n2) + "/RemoteEngine";
                    Compute compute = (Compute)Naming.lookup(string);
                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Starting row " + n + " on host " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(n2));
                    Object object = compute.executeTask(remoteBoundaryVisualizerSubTask);
                    boolean bl = false;
                    TaskStatusInfo taskStatusInfo = null;
                    long l = System.currentTimeMillis();
                    while (!bl) {
                        try {
                            Object object2;
                            Thread.sleep(Math.max(BoundaryPanelDistributed.this.m_minTaskPollTime, BoundaryPanelDistributed.this.m_hostPollingTime[n2]));
                            TaskStatusInfo taskStatusInfo2 = (TaskStatusInfo)compute.checkStatus(object);
                            if (taskStatusInfo2.getExecutionStatus() == 3) {
                                long l2 = System.currentTimeMillis() - l;
                                if ((l2 /= 4L) < 1000L) {
                                    l2 = 1000L;
                                }
                                ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[n2] = (int)l2;
                                object2 = (RemoteResult)taskStatusInfo2.getTaskResult();
                                double[][] dArray = ((RemoteResult)object2).getProbabilities();
                                for (int i = 0; i < BoundaryPanelDistributed.this.m_panelWidth; ++i) {
                                    BoundaryPanelDistributed.this.m_probabilityCache[n][i] = dArray[i];
                                    if (i < BoundaryPanelDistributed.this.m_panelWidth - 1) {
                                        BoundaryPanelDistributed.this.plotPoint(i, n, dArray[i], false);
                                        continue;
                                    }
                                    BoundaryPanelDistributed.this.plotPoint(i, n, dArray[i], true);
                                }
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[n2] = 0;
                                BoundaryPanelDistributed.this.incrementFinished();
                                BoundaryPanelDistributed.this.availableHost(n2);
                                bl = true;
                                continue;
                            }
                            if (taskStatusInfo2.getExecutionStatus() == 2) {
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[n2] = 3;
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + n + " " + taskStatusInfo2.getStatusMessage() + ". Scheduling for execution on another host.");
                                BoundaryPanelDistributed.this.incrementFailed(n2);
                                BoundaryPanelDistributed.this.waitingTask(n);
                                BoundaryPanelDistributed.this.availableHost(n2);
                                bl = true;
                                continue;
                            }
                            if (taskStatusInfo == null) {
                                taskStatusInfo = taskStatusInfo2;
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, taskStatusInfo2.getStatusMessage());
                                continue;
                            }
                            RemoteResult remoteResult = (RemoteResult)taskStatusInfo2.getTaskResult();
                            if (remoteResult != null) {
                                int n3 = remoteResult.getPercentCompleted();
                                object2 = "";
                                if (n3 > 0 && n3 < 100) {
                                    double d = (double)System.currentTimeMillis() - (double)l;
                                    double d2 = (100.0 - (double)n3) / (double)n3 * d;
                                    if (d2 < (double)BoundaryPanelDistributed.this.m_hostPollingTime[n2]) {
                                        ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[n2] = (int)d2;
                                    }
                                    String string2 = "seconds";
                                    if ((d2 /= 1000.0) > 60.0) {
                                        string2 = "minutes";
                                        d2 /= 60.0;
                                    }
                                    if (d2 > 60.0) {
                                        string2 = "hours";
                                        d2 /= 60.0;
                                    }
                                    object2 = " (approx. time remaining " + Utils.doubleToString(d2, 1) + " " + string2 + ")";
                                }
                                if (n3 < 25) {
                                    if (n3 > 0) {
                                        ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[n2] = (int)(25.0 / (double)n3 * (double)BoundaryPanelDistributed.this.m_hostPollingTime[n2]);
                                    } else {
                                        int[] nArray = BoundaryPanelDistributed.this.m_hostPollingTime;
                                        int n22 = n2;
                                        nArray[n22] = nArray[n22] * 2;
                                    }
                                    if (BoundaryPanelDistributed.this.m_hostPollingTime[n2] > 60000) {
                                        ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_hostPollingTime[n2] = 60000;
                                    }
                                }
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + n + " " + n3 + "% complete" + (String)object2 + ".");
                            } else {
                                BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Row " + n + " queued on " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(n2));
                                if (BoundaryPanelDistributed.this.m_hostPollingTime[n2] < 60000) {
                                    int[] nArray = BoundaryPanelDistributed.this.m_hostPollingTime;
                                    int n4 = n2;
                                    nArray[n4] = nArray[n4] * 2;
                                }
                            }
                            taskStatusInfo = taskStatusInfo2;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    ((BoundaryPanelDistributed)BoundaryPanelDistributed.this).m_remoteHostsStatus[n2] = 2;
                    BoundaryPanelDistributed.this.m_removedHosts++;
                    System.err.println(exception);
                    exception.printStackTrace();
                    BoundaryPanelDistributed.this.notifyListeners(false, true, false, "Connection to " + (String)BoundaryPanelDistributed.this.m_remoteHosts.elementAt(n2) + " failed. Scheduling row " + n + " for execution on another host.");
                    BoundaryPanelDistributed.this.checkForAllFailedHosts();
                    BoundaryPanelDistributed.this.waitingTask(n);
                }
                finally {
                    if (this.isInterrupted()) {
                        System.err.println("Sub exp Interupted!");
                    }
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            if (stringArray.length < 8) {
                System.err.println("Usage : BoundaryPanelDistributed <dataset> <class col> <xAtt> <yAtt> <base> <# loc/pixel> <kernel bandwidth> <display width> <display height> <classifier [classifier options]>");
                System.exit(1);
            }
            Vector<String> vector = new Vector<String>();
            try {
                object2 = new BufferedReader(new FileReader("hosts.vis"));
                object = ((BufferedReader)object2).readLine();
                while (object != null) {
                    System.out.println("Adding host " + (String)object);
                    vector.add((String)object);
                    object = ((BufferedReader)object2).readLine();
                }
                ((BufferedReader)object2).close();
            }
            catch (Exception exception) {
                System.err.println("No hosts.vis file - create this file in the current directory with one host name per line, or use BoundaryPanel instead.");
                System.exit(1);
            }
            object2 = new JFrame("Weka classification boundary visualizer");
            ((JFrame)object2).getContentPane().setLayout(new BorderLayout());
            System.err.println("Loading instances from : " + stringArray[0]);
            object = new BufferedReader(new FileReader(stringArray[0]));
            final Instances instances = new Instances((Reader)object);
            instances.setClassIndex(Integer.parseInt(stringArray[1]));
            final int n = Integer.parseInt(stringArray[2]);
            final int n2 = Integer.parseInt(stringArray[3]);
            int n3 = Integer.parseInt(stringArray[4]);
            int n4 = Integer.parseInt(stringArray[5]);
            int n5 = Integer.parseInt(stringArray[6]);
            int n6 = Integer.parseInt(stringArray[7]);
            int n7 = Integer.parseInt(stringArray[8]);
            final String string = stringArray[9];
            final BoundaryPanelDistributed boundaryPanelDistributed = new BoundaryPanelDistributed(n6, n7);
            boundaryPanelDistributed.addRemoteExperimentListener(new RemoteExperimentListener(){

                public void remoteExperimentStatus(RemoteExperimentEvent remoteExperimentEvent) {
                    if (remoteExperimentEvent.m_experimentFinished) {
                        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
                        boundaryPanelDistributed.saveImage(string2 + "_" + instances.relationName() + "_X" + n + "_Y" + n2 + ".jpg");
                    } else {
                        System.err.println(remoteExperimentEvent.m_messageString);
                    }
                }
            });
            boundaryPanelDistributed.setRemoteHosts(vector);
            ((JFrame)object2).getContentPane().add((Component)boundaryPanelDistributed, "Center");
            ((Window)object2).setSize(boundaryPanelDistributed.getMinimumSize());
            ((Window)object2).addWindowListener(new WindowAdapter((JFrame)object2){
                private final /* synthetic */ JFrame val$jf;
                {
                    this.val$jf = jFrame;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    this.val$jf.dispose();
                    System.exit(0);
                }
            });
            ((Window)object2).pack();
            ((Window)object2).setVisible(true);
            boundaryPanelDistributed.repaint();
            String[] stringArray2 = null;
            if (stringArray.length > 10) {
                stringArray2 = new String[stringArray.length - 10];
                for (int i = 10; i < stringArray.length; ++i) {
                    stringArray2[i - 10] = stringArray[i];
                }
            }
            Classifier classifier = Classifier.forName(stringArray[9], stringArray2);
            KDDataGenerator kDDataGenerator = new KDDataGenerator();
            kDDataGenerator.setKernelBandwidth(n5);
            boundaryPanelDistributed.setDataGenerator(kDDataGenerator);
            boundaryPanelDistributed.setNumSamplesPerRegion(n4);
            boundaryPanelDistributed.setGeneratorSamplesBase(n3);
            boundaryPanelDistributed.setClassifier(classifier);
            boundaryPanelDistributed.setTrainingData(instances);
            boundaryPanelDistributed.setXAttribute(n);
            boundaryPanelDistributed.setYAttribute(n2);
            try {
                FileInputStream fileInputStream = new FileInputStream("colors.ser");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                FastVector fastVector = (FastVector)objectInputStream.readObject();
                boundaryPanelDistributed.setColors(fastVector);
            }
            catch (Exception exception) {
                System.err.println("No color map file");
            }
            boundaryPanelDistributed.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

