/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.net.BayesNetGenerator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.DataGenerator;

public class BayesNet
extends ClassificationGenerator {
    protected BayesNetGenerator m_Generator;

    public BayesNet() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumArcs(this.defaultNumArcs());
        this.setCardinality(this.defaultCardinality());
    }

    public String globalInfo() {
        return "Generates random instances based on a Bayes network.";
    }

    public Enumeration listOptions() {
        Vector vector = this.enumToVector(super.listOptions());
        vector.add(new Option("\tThe number of arcs to use. (default " + this.defaultNumArcs() + ")", "A", 1, "-A <num>"));
        vector.add(new Option("\tThe cardinality of the attributes and the class. (default " + this.defaultCardinality() + ")", "C", 1, "-C <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        Vector<String> vector = new Vector<String>();
        vector.add("-N");
        vector.add("" + this.getNumAttributes());
        vector.add("-M");
        vector.add("" + this.getNumExamples());
        vector.add("-S");
        vector.add("" + this.getSeed());
        vector.add("-A");
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            vector.add(string);
        } else {
            vector.add("" + this.defaultNumArcs());
        }
        vector.add("-C");
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            vector.add(string);
        } else {
            vector.add("" + this.defaultCardinality());
        }
        this.setGeneratorOptions(vector);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.removeBlacklist(super.getOptions());
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        stringArray = this.getGenerator().getOptions();
        try {
            vector.add("-A");
            vector.add(Utils.getOption('A', stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            vector.add("-C");
            vector.add(Utils.getOption('C', stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector.toArray(new String[vector.size()]);
    }

    protected void setGeneratorOptions(BayesNetGenerator bayesNetGenerator, Vector vector) {
        try {
            bayesNetGenerator.setOptions(vector.toArray(new String[vector.size()]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected BayesNetGenerator getGenerator() {
        if (this.m_Generator == null) {
            this.m_Generator = new BayesNetGenerator();
        }
        return this.m_Generator;
    }

    protected void setGeneratorOptions(Vector vector) {
        this.setGeneratorOptions(this.getGenerator(), vector);
    }

    protected void setGeneratorOption(BayesNetGenerator bayesNetGenerator, String string, String string2) {
        try {
            String[] stringArray = bayesNetGenerator.getOptions();
            Utils.getOption(string, stringArray);
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                vector.add(stringArray[i]);
            }
            vector.add("-" + string);
            vector.add(string2);
            this.setGeneratorOptions(bayesNetGenerator, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setGeneratorOption(String string, String string2) {
        this.setGeneratorOption(this.getGenerator(), string, string2);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int n) {
        this.setGeneratorOption("N", "" + n);
    }

    public int getNumAttributes() {
        int n = -1;
        try {
            n = Integer.parseInt(Utils.getOption('N', this.getGenerator().getOptions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        return n;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain (including class attribute), ie the number of nodes in the bayesian net.";
    }

    protected int defaultCardinality() {
        return 2;
    }

    public void setCardinality(int n) {
        this.setGeneratorOption("C", "" + n);
    }

    public int getCardinality() {
        int n = -1;
        try {
            n = Integer.parseInt(Utils.getOption('C', this.getGenerator().getOptions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        return n;
    }

    public String cardinalityTipText() {
        return "The cardinality of the attributes, incl the class attribute.";
    }

    protected int defaultNumArcs() {
        return 20;
    }

    public void setNumArcs(int n) {
        int n2 = this.getNumAttributes();
        int n3 = n2 - 1;
        int n4 = n2 * (n2 - 1) / 2;
        if (n > n4) {
            throw new IllegalArgumentException("Number of arcs should be at most nodes * (nodes - 1) / 2 = " + n4 + " instead of " + n + " (nodes = numAttributes)!");
        }
        if (n < n3) {
            throw new IllegalArgumentException("Number of arcs should be at least (nodes - 1) = " + n3 + " instead of " + n + " (nodes = numAttributes)!");
        }
        this.setGeneratorOption("A", "" + n);
    }

    public int getNumArcs() {
        int n = -1;
        try {
            n = Integer.parseInt(Utils.getOption('A', this.getGenerator().getOptions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        return n;
    }

    public String numArcsTipText() {
        return "The number of arcs in the bayesian net, at most: n * (n - 1) / 2 and at least: (n - 1); with n = numAttributes";
    }

    public void setNumExamples(int n) {
        super.setNumExamples(n);
        this.setGeneratorOption("M", "" + n);
    }

    public int getNumExamples() {
        int n = -1;
        try {
            n = Integer.parseInt(Utils.getOption('M', this.getGenerator().getOptions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        return n;
    }

    public boolean getSingleModeFlag() throws Exception {
        return false;
    }

    public Instances defineDataFormat() throws Exception {
        BayesNetGenerator bayesNetGenerator = new BayesNetGenerator();
        bayesNetGenerator.setOptions(this.getGenerator().getOptions());
        this.setGeneratorOption(bayesNetGenerator, "M", "1");
        bayesNetGenerator.generateRandomNetwork();
        bayesNetGenerator.generateInstances();
        bayesNetGenerator.m_Instances.renameAttribute(0, "class");
        bayesNetGenerator.m_Instances.setRelationName(this.getRelationNameToUse());
        return bayesNetGenerator.m_Instances;
    }

    public Instance generateExample() throws Exception {
        throw new Exception("Cannot generate examples one-by-one!");
    }

    public Instances generateExamples() throws Exception {
        this.getGenerator().setOptions(this.getGenerator().getOptions());
        this.getGenerator().generateRandomNetwork();
        this.getGenerator().generateInstances();
        this.getGenerator().m_Instances.renameAttribute(0, "class");
        this.getGenerator().m_Instances.setRelationName(this.getRelationNameToUse());
        return this.getGenerator().m_Instances;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public static void main(String[] stringArray) {
        try {
            DataGenerator.makeData(new BayesNet(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

