/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.meta.nestedDichotomies.ClassBalancedND;
import weka.classifiers.meta.nestedDichotomies.DataNearBalancedND;
import weka.classifiers.meta.nestedDichotomies.ND;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class END
extends RandomizableIteratedSingleClassifierEnhancer {
    protected Hashtable m_hashtable = null;

    public END() {
        this.m_Classifier = new ND();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.meta.nestedDichotomies.ND";
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building an ensemble of nested dichotomies. For more info, check\n\nLin Dong, Eibe Frank, and Stefan Kramer (2005). Ensembles of Balanced Nested Dichotomies for Multi-Class Problems. PKDD, Porto. Springer-Verlag\n\nand\n\nEibe Frank and Stefan Kramer (2004). Ensembles of Nested Dichotomies for Multi-class Problems. Proceedings of the International Conference on Machine Learning, Banff. Morgan Kaufmann.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("END: class must be nominal!");
        }
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new Exception("No instances in training file!");
        }
        if (!(this.m_Classifier instanceof ND || this.m_Classifier instanceof ClassBalancedND || this.m_Classifier instanceof DataNearBalancedND)) {
            throw new IllegalArgumentException("END only works with ND, ClassBalancedND or DataNearBalancedND classifier");
        }
        this.m_hashtable = new Hashtable();
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, this.m_NumIterations);
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            if (this.m_Classifier instanceof ND) {
                ((ND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            } else if (this.m_Classifier instanceof ClassBalancedND) {
                ((ClassBalancedND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            } else if (this.m_Classifier instanceof DataNearBalancedND) {
                ((DataNearBalancedND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            }
            this.m_Classifiers[i].buildClassifier(instances);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "END: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new END(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

