/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.text.DecimalFormat;
import java.util.Random;
import weka.classifiers.functions.pace.ChisqMixture;
import weka.classifiers.functions.pace.NormalMixture;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;
import weka.core.matrix.Maths;
import weka.core.matrix.Matrix;

public class PaceMatrix
extends Matrix {
    public PaceMatrix(int n, int n2) {
        super(n, n2);
    }

    public PaceMatrix(int n, int n2, double d) {
        super(n, n2, d);
    }

    public PaceMatrix(double[][] dArray) {
        super(dArray);
    }

    public PaceMatrix(double[][] dArray, int n, int n2) {
        super(dArray, n, n2);
    }

    public PaceMatrix(double[] dArray, int n) {
        super(dArray, n);
    }

    public PaceMatrix(DoubleVector doubleVector) {
        this(doubleVector.size(), 1);
        this.setMatrix(0, doubleVector.size() - 1, 0, doubleVector);
    }

    public PaceMatrix(Matrix matrix) {
        super(matrix.getRowDimension(), matrix.getColumnDimension());
        this.A = matrix.getArray();
    }

    public void setRowDimension(int n) {
        this.m = n;
    }

    public void setColumnDimension(int n) {
        this.n = n;
    }

    public Object clone() {
        PaceMatrix paceMatrix = new PaceMatrix(this.m, this.n);
        double[][] dArray = paceMatrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return paceMatrix;
    }

    public void setPlus(int n, int n2, double d) {
        double[] dArray = this.A[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public void setTimes(int n, int n2, double d) {
        double[] dArray = this.A[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] * d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, double d) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    this.A[i][j] = d;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds");
        }
    }

    public void setMatrix(int n, int n2, int n3, DoubleVector doubleVector) {
        for (int i = n; i <= n2; ++i) {
            this.A[i][n3] = doubleVector.get(i - n);
        }
    }

    public void setMatrix(double[] dArray, boolean bl) {
        try {
            if (dArray.length != this.m * this.n) {
                throw new IllegalArgumentException("sizes not match.");
            }
            int n = 0;
            if (bl) {
                for (int i = 0; i < this.m; ++i) {
                    for (int j = 0; j < this.n; ++j) {
                        this.A[i][j] = dArray[n];
                        ++n;
                    }
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    for (int j = 0; j < this.m; ++j) {
                        this.A[j][i] = dArray[n];
                        ++n;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public double maxAbs() {
        double d = Math.abs(this.A[0][0]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.m; ++j) {
                d = Math.max(d, Math.abs(this.A[j][i]));
            }
        }
        return d;
    }

    public double maxAbs(int n, int n2, int n3) {
        double d = Math.abs(this.A[n][n3]);
        for (int i = n + 1; i <= n2; ++i) {
            d = Math.max(d, Math.abs(this.A[i][n3]));
        }
        return d;
    }

    public double minAbs(int n, int n2, int n3) {
        double d = Math.abs(this.A[n][n3]);
        for (int i = n + 1; i <= n2; ++i) {
            d = Math.min(d, Math.abs(this.A[i][n3]));
        }
        return d;
    }

    public boolean isEmpty() {
        if (this.m == 0 || this.n == 0) {
            return true;
        }
        return this.A == null;
    }

    public DoubleVector getColumn(int n) {
        DoubleVector doubleVector = new DoubleVector(this.m);
        double[] dArray = doubleVector.getArray();
        for (int i = 0; i < this.m; ++i) {
            dArray[i] = this.A[i][n];
        }
        return doubleVector;
    }

    public DoubleVector getColumn(int n, int n2, int n3) {
        DoubleVector doubleVector = new DoubleVector(n2 - n + 1);
        double[] dArray = doubleVector.getArray();
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            dArray[n4] = this.A[i][n3];
            ++n4;
        }
        return doubleVector;
    }

    public double times(int n, int n2, int n3, PaceMatrix paceMatrix, int n4) {
        double d = 0.0;
        for (int i = n2; i <= n3; ++i) {
            d += this.A[n][i] * paceMatrix.A[i][n4];
        }
        return d;
    }

    protected DecimalFormat[] format() {
        return this.format(0, this.m - 1, 0, this.n - 1, 7, false);
    }

    protected DecimalFormat[] format(int n) {
        return this.format(0, this.m - 1, 0, this.n - 1, n, false);
    }

    protected DecimalFormat[] format(int n, boolean bl) {
        return this.format(0, this.m - 1, 0, this.n - 1, n, bl);
    }

    protected DecimalFormat format(int n, int n2, int n3, int n4, boolean bl) {
        FlexibleDecimalFormat flexibleDecimalFormat = new FlexibleDecimalFormat(n4, bl);
        flexibleDecimalFormat.grouping(true);
        for (int i = n; i <= n2; ++i) {
            flexibleDecimalFormat.update(this.A[i][n3]);
        }
        return flexibleDecimalFormat;
    }

    protected DecimalFormat[] format(int n, int n2, int n3, int n4, int n5, boolean bl) {
        DecimalFormat[] decimalFormatArray = new DecimalFormat[n4 - n3 + 1];
        for (int i = n3; i <= n4; ++i) {
            decimalFormatArray[i] = this.format(n, n2, i, n5, bl);
        }
        return decimalFormatArray;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int n, boolean bl) {
        int n2;
        if (this.isEmpty()) {
            return "null matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat[] decimalFormatArray = this.format(n, bl);
        int n3 = 0;
        int n4 = 0;
        int n5 = 80;
        int[] nArray = new int[this.n];
        int n6 = 0;
        for (n2 = 0; n2 < this.n; ++n2) {
            int n7 = decimalFormatArray[n2].format(this.A[0][n2]).length();
            if (n4 + 1 + n7 > n5 - 1) {
                nArray[n6++] = n3;
                n4 = 0;
                n3 = 0;
            }
            n4 += 1 + n7;
            ++n3;
        }
        nArray[n6] = n3;
        n6 = 0;
        n2 = 0;
        while (n2 < this.n) {
            for (int i = 0; i < this.m; ++i) {
                for (int j = n2; j < n2 + nArray[n6]; ++j) {
                    stringBuffer.append(" " + decimalFormatArray[j].format(this.A[i][j]));
                }
                stringBuffer.append("\n");
            }
            n2 += nArray[n6];
            ++n6;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public double sum2(int n, int n2, int n3, boolean bl) {
        double d = 0.0;
        if (bl) {
            for (int i = n2; i <= n3; ++i) {
                d += this.A[i][n] * this.A[i][n];
            }
        } else {
            for (int i = n2; i <= n3; ++i) {
                d += this.A[n][i] * this.A[n][i];
            }
        }
        return d;
    }

    public double[] sum2(boolean bl) {
        int n = bl ? this.n : this.m;
        int n2 = bl ? this.m : this.n;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.sum2(i, 0, n2 - 1, bl);
        }
        return dArray;
    }

    public double[] h1(int n, int n2) {
        double[] dArray = new double[2];
        double d = this.sum2(n, n2, this.m - 1, true);
        dArray[0] = this.A[n2][n] >= 0.0 ? -Math.sqrt(d) : Math.sqrt(d);
        double[] dArray2 = this.A[n2];
        int n3 = n;
        dArray2[n3] = dArray2[n3] - dArray[0];
        dArray[1] = this.A[n2][n] * dArray[0];
        return dArray;
    }

    public void h2(int n, int n2, double d, PaceMatrix paceMatrix, int n3) {
        int n4;
        double d2 = 0.0;
        for (n4 = n2; n4 < this.m; ++n4) {
            d2 += this.A[n4][n] * paceMatrix.A[n4][n3];
        }
        double d3 = d2 / d;
        for (n4 = n2; n4 < this.m; ++n4) {
            double[] dArray = paceMatrix.A[n4];
            int n5 = n3;
            dArray[n5] = dArray[n5] + d3 * this.A[n4][n];
        }
    }

    public double[] g1(double d, double d2) {
        double[] dArray = new double[2];
        double d3 = Maths.hypot(d, d2);
        if (d3 == 0.0) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        } else {
            dArray[0] = d / d3;
            dArray[1] = d2 / d3;
        }
        return dArray;
    }

    public void g2(double[] dArray, int n, int n2, int n3) {
        double d = dArray[0] * this.A[n][n3] + dArray[1] * this.A[n2][n3];
        this.A[n2][n3] = -dArray[1] * this.A[n][n3] + dArray[0] * this.A[n2][n3];
        this.A[n][n3] = d;
    }

    public void forward(PaceMatrix paceMatrix, IntVector intVector, int n) {
        for (int i = n; i < Math.min(intVector.size(), this.m); ++i) {
            this.steplsqr(paceMatrix, intVector, i, this.mostExplainingColumn(paceMatrix, intVector, i), true);
        }
    }

    public int mostExplainingColumn(PaceMatrix paceMatrix, IntVector intVector, int n) {
        int[] nArray = intVector.getArray();
        double d = this.columnResponseExplanation(paceMatrix, intVector, n, n);
        int n2 = n;
        for (int i = n + 1; i < intVector.size(); ++i) {
            double d2 = this.columnResponseExplanation(paceMatrix, intVector, i, n);
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    public void backward(PaceMatrix paceMatrix, IntVector intVector, int n, int n2) {
        for (int i = n; i > n2; --i) {
            this.steplsqr(paceMatrix, intVector, i, this.leastExplainingColumn(paceMatrix, intVector, i, n2), false);
        }
    }

    public int leastExplainingColumn(PaceMatrix paceMatrix, IntVector intVector, int n, int n2) {
        int[] nArray = intVector.getArray();
        double d = this.columnResponseExplanation(paceMatrix, intVector, n - 1, n);
        int n3 = n - 1;
        for (int i = n2; i < n - 1; ++i) {
            double d2 = this.columnResponseExplanation(paceMatrix, intVector, i, n);
            if (!(d2 <= d)) continue;
            d = d2;
            n3 = i;
        }
        return n3;
    }

    public double columnResponseExplanation(PaceMatrix paceMatrix, IntVector intVector, int n, int n2) {
        double d;
        double[] dArray = new double[this.n];
        int[] nArray = intVector.getArray();
        if (n == n2 - 1) {
            d = paceMatrix.A[n][0];
        } else if (n > n2 - 1) {
            int n3 = Math.min(this.n - 1, n);
            DoubleVector doubleVector = this.getColumn(n2, n3, nArray[n]);
            DoubleVector doubleVector2 = paceMatrix.getColumn(n2, n3, 0);
            d = doubleVector2.innerProduct(doubleVector) / doubleVector.norm2();
        } else {
            int n4;
            for (n4 = n + 1; n4 < n2; ++n4) {
                dArray[n4] = this.A[n][nArray[n4]];
            }
            d = paceMatrix.A[n][0];
            for (n4 = n + 1; n4 < n2; ++n4) {
                double[] dArray2 = this.g1(dArray[n4], this.A[n4][nArray[n4]]);
                for (int i = n4 + 1; i < n2; ++i) {
                    dArray[i] = -dArray2[1] * dArray[i] + dArray2[0] * this.A[n4][nArray[i]];
                }
                d = -dArray2[1] * d + dArray2[0] * paceMatrix.A[n4][0];
            }
        }
        return d * d;
    }

    public void lsqr(PaceMatrix paceMatrix, IntVector intVector, int n) {
        int n2;
        int[] nArray = intVector.getArray();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (this.sum2(nArray[n2], n3, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(paceMatrix, intVector, n3, n2, true);
                ++n3;
                continue;
            }
            intVector.shiftToEnd(n2);
            intVector.setSize(intVector.size() - 1);
            --n;
            --n2;
        }
        for (n2 = n; n2 < Math.min(intVector.size(), this.m); ++n2) {
            if (this.sum2(nArray[n2], n3, this.m - 1, true) > 1.0E-15) {
                this.steplsqr(paceMatrix, intVector, n3, n2, true);
                ++n3;
                continue;
            }
            intVector.shiftToEnd(n2);
            intVector.setSize(intVector.size() - 1);
            --n2;
        }
        paceMatrix.m = this.m = n3;
        intVector.setSize(n3);
    }

    public void lsqrSelection(PaceMatrix paceMatrix, IntVector intVector, int n) {
        int n2 = this.m;
        int n3 = intVector.size();
        this.lsqr(paceMatrix, intVector, n);
        if (n3 > 200 || n3 > n2) {
            this.forward(paceMatrix, intVector, n);
        }
        this.backward(paceMatrix, intVector, intVector.size(), n);
    }

    public void positiveDiagonal(PaceMatrix paceMatrix, IntVector intVector) {
        int[] nArray = intVector.getArray();
        for (int i = 0; i < intVector.size(); ++i) {
            if (!(this.A[i][nArray[i]] < 0.0)) continue;
            for (int j = i; j < intVector.size(); ++j) {
                this.A[i][nArray[j]] = -this.A[i][nArray[j]];
            }
            paceMatrix.A[i][0] = -paceMatrix.A[i][0];
        }
    }

    public void steplsqr(PaceMatrix paceMatrix, IntVector intVector, int n, int n2, boolean bl) {
        int n3 = intVector.size();
        int[] nArray = intVector.getArray();
        if (bl) {
            int n4;
            int n5 = nArray[n2];
            intVector.swap(n, n2);
            double[] dArray = this.h1(n5, n);
            for (n4 = n + 1; n4 < n3; ++n4) {
                int n6 = nArray[n4];
                this.h2(n5, n, dArray[1], this, n6);
            }
            this.h2(n5, n, dArray[1], paceMatrix, 0);
            this.A[n][n5] = dArray[0];
            for (n4 = n + 1; n4 < this.m; ++n4) {
                this.A[n4][n5] = 0.0;
            }
        } else {
            int n7 = nArray[n2];
            for (int i = n2; i < n - 1; ++i) {
                nArray[i] = nArray[i + 1];
            }
            nArray[n - 1] = n7;
            for (int i = n2; i < n - 1; ++i) {
                int n8;
                double[] dArray = this.g1(this.A[i][nArray[i]], this.A[i + 1][nArray[i]]);
                for (n8 = i; n8 < n3; ++n8) {
                    this.g2(dArray, i, i + 1, nArray[n8]);
                }
                for (n8 = 0; n8 < paceMatrix.n; ++n8) {
                    paceMatrix.g2(dArray, i, i + 1, n8);
                }
            }
        }
    }

    public void rsolve(PaceMatrix paceMatrix, IntVector intVector, int n) {
        if (n == 0) {
            paceMatrix.m = 0;
        }
        int[] nArray = intVector.getArray();
        double[][] dArray = paceMatrix.getArray();
        for (int i = 0; i < paceMatrix.n; ++i) {
            double[] dArray2 = dArray[n - 1];
            int n2 = i;
            dArray2[n2] = dArray2[n2] / this.A[n - 1][nArray[n - 1]];
            for (int j = n - 2; j >= 0; --j) {
                double d = 0.0;
                for (int k = j + 1; k < n; ++k) {
                    d += this.A[j][nArray[k]] * dArray[k][i];
                }
                double[] dArray3 = dArray[j];
                int n3 = i;
                dArray3[n3] = dArray3[n3] - d;
                double[] dArray4 = dArray[j];
                int n4 = i;
                dArray4[n4] = dArray4[n4] / this.A[j][nArray[j]];
            }
        }
        paceMatrix.m = n;
    }

    public PaceMatrix rbind(PaceMatrix paceMatrix) {
        if (this.n != paceMatrix.n) {
            throw new IllegalArgumentException("unequal numbers of rows.");
        }
        PaceMatrix paceMatrix2 = new PaceMatrix(this.m + paceMatrix.m, this.n);
        paceMatrix2.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        paceMatrix2.setMatrix(this.m, this.m + paceMatrix.m - 1, 0, this.n - 1, paceMatrix);
        return paceMatrix2;
    }

    public PaceMatrix cbind(PaceMatrix paceMatrix) {
        if (this.m != paceMatrix.m) {
            throw new IllegalArgumentException("unequal numbers of rows: " + this.m + " and " + paceMatrix.m);
        }
        PaceMatrix paceMatrix2 = new PaceMatrix(this.m, this.n + paceMatrix.n);
        paceMatrix2.setMatrix(0, this.m - 1, 0, this.n - 1, this);
        paceMatrix2.setMatrix(0, this.m - 1, this.n, this.n + paceMatrix.n - 1, paceMatrix);
        return paceMatrix2;
    }

    /*
     * Exception decompiling
     */
    public DoubleVector nnls(PaceMatrix var1_1, IntVector var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DoubleVector nnlse(PaceMatrix paceMatrix, PaceMatrix paceMatrix2, PaceMatrix paceMatrix3, IntVector intVector) {
        double d = 1.0E-10 * Math.max(paceMatrix2.maxAbs(), paceMatrix3.maxAbs()) / Math.max(this.maxAbs(), paceMatrix.maxAbs());
        PaceMatrix paceMatrix4 = paceMatrix2.rbind(new PaceMatrix(this.times(d)));
        PaceMatrix paceMatrix5 = paceMatrix3.rbind(new PaceMatrix(paceMatrix.times(d)));
        return paceMatrix4.nnls(paceMatrix5, intVector);
    }

    public DoubleVector nnlse1(PaceMatrix paceMatrix, IntVector intVector) {
        PaceMatrix paceMatrix2 = new PaceMatrix(1, this.n, 1.0);
        PaceMatrix paceMatrix3 = new PaceMatrix(1, paceMatrix.n, 1.0);
        return this.nnlse(paceMatrix, paceMatrix2, paceMatrix3, intVector);
    }

    public static Matrix randomNormal(int n, int n2) {
        Random random = new Random();
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = random.nextGaussian();
            }
        }
        return matrix;
    }

    public static void main(String[] stringArray) {
        System.out.println("===========================================================");
        System.out.println("To test the pace estimators of linear model\ncoefficients.\n");
        double d = 2.0;
        int n = 200;
        double d2 = 100.0;
        int n2 = 20;
        double d3 = 0.0;
        int n3 = 20;
        double d4 = 5.0;
        int n4 = 1 + n2 + n3;
        DoubleVector doubleVector = new DoubleVector(1 + n2 + n3);
        doubleVector.set(0, d2);
        doubleVector.set(1, n2, d3);
        doubleVector.set(n2 + 1, n2 + n3, d4);
        System.out.println("The data set contains " + n + " observations plus " + (n2 + n3) + " variables.\n\nThe coefficients of the true model" + " are:\n\n" + doubleVector);
        System.out.println("\nThe standard deviation of the error term is " + d);
        System.out.println("===========================================================");
        PaceMatrix paceMatrix = new PaceMatrix(n, n2 + n3 + 1);
        paceMatrix.setMatrix(0, n - 1, 0, 0, 1.0);
        paceMatrix.setMatrix(0, n - 1, 1, n2 + n3, PaceMatrix.random(n, n2 + n3));
        PaceMatrix paceMatrix2 = new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector)).plusEquals(PaceMatrix.randomNormal(n, 1).times(d)));
        IntVector intVector = IntVector.seq(0, n2 + n3);
        paceMatrix.lsqrSelection(paceMatrix2, intVector, 1);
        paceMatrix.positiveDiagonal(paceMatrix2, intVector);
        PaceMatrix paceMatrix3 = (PaceMatrix)paceMatrix2.clone();
        paceMatrix.rsolve(paceMatrix3, intVector, intVector.size());
        DoubleVector doubleVector2 = paceMatrix3.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe OLS estimate (through lsqr()) is: \n\n" + doubleVector2);
        System.out.println("\nQuadratic loss of the OLS estimate (||X b - X bHat||^2) = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector2)))).getColumn(0).sum2());
        System.out.println("===========================================================");
        System.out.println("             *** Pace estimation *** \n");
        DoubleVector doubleVector3 = paceMatrix2.getColumn(intVector.size(), n - 1, 0);
        double d5 = Math.sqrt(doubleVector3.sum2() / (double)doubleVector3.size());
        System.out.println("Estimated standard deviation = " + d5);
        DoubleVector doubleVector4 = paceMatrix2.getColumn(0, intVector.size() - 1, 0).times(1.0 / d5);
        System.out.println("\naHat = \n" + doubleVector4);
        System.out.println("\n========= Based on chi-square mixture ============");
        ChisqMixture chisqMixture = new ChisqMixture();
        int n5 = 1;
        DoubleVector doubleVector5 = doubleVector4.square();
        chisqMixture.fit(doubleVector5, n5);
        System.out.println("\nEstimated mixing distribution is:\n" + chisqMixture);
        DoubleVector doubleVector6 = chisqMixture.pace2(doubleVector5);
        DoubleVector doubleVector7 = doubleVector6.sqrt().times(doubleVector4.sign());
        PaceMatrix paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        DoubleVector doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe pace2 estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
        doubleVector6 = chisqMixture.pace4(doubleVector5);
        doubleVector7 = doubleVector6.sqrt().times(doubleVector4.sign());
        paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe pace4 estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
        doubleVector6 = chisqMixture.pace6(doubleVector5);
        doubleVector7 = doubleVector6.sqrt().times(doubleVector4.sign());
        paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe pace6 estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
        System.out.println("\n========= Based on normal mixture ============");
        NormalMixture normalMixture = new NormalMixture();
        normalMixture.fit(doubleVector4, n5);
        System.out.println("\nEstimated mixing distribution is:\n" + normalMixture);
        doubleVector7 = normalMixture.nestedEstimate(doubleVector4);
        paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("The nested estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
        doubleVector7 = normalMixture.subsetEstimate(doubleVector4);
        paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe subset estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
        doubleVector7 = normalMixture.empiricalBayesEstimate(doubleVector4);
        paceMatrix4 = new PaceMatrix(new PaceMatrix(doubleVector7).times(d5));
        paceMatrix.rsolve(paceMatrix4, intVector, intVector.size());
        doubleVector8 = paceMatrix4.getColumn(0).unpivoting(intVector, n4);
        System.out.println("\nThe empirical Bayes estimate of coefficients = \n" + doubleVector8);
        System.out.println("Quadratic loss = " + new PaceMatrix(paceMatrix.times(new PaceMatrix(doubleVector.minus(doubleVector8)))).getColumn(0).sum2());
    }
}

