/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.SubsetEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class WrapperSubsetEval
extends SubsetEvaluator
implements OptionHandler {
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Evaluation m_Evaluation;
    private Classifier m_BaseClassifier;
    private int m_folds;
    private int m_seed;
    private double m_threshold;

    public String globalInfo() {
        return "WrapperSubsetEval:\n\nEvaluates attribute sets by using a learning scheme. Cross validation is used to estimate the accuracy of the learning scheme for a set of attributes.\n";
    }

    public WrapperSubsetEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tclass name of base learner to use for\n\taccuracy estimation. Place any\n\tclassifier options LAST on the\n\tcommand line following a \"--\".\n\teg. -B weka.classifiers.bayes.NaiveBayes ... -- -K", "B", 1, "-B <base learner>"));
        vector.addElement(new Option("\tnumber of cross validation folds to use\n\tfor estimating accuracy.\n\t(default=5)", "F", 1, "-F <num>"));
        vector.addElement(new Option("\tSeed for cross validation accuracy \n\testimation.\n\t(default = 1)", "R", 1, "-R <seed>"));
        vector.addElement(new Option("\tthreshold by which to execute another cross validation\n\t(standard deviation---expressed as a percentage of the mean).\n\t(default=0.01(1%))", "T", 1, "-T <num>"));
        if (this.m_BaseClassifier != null && this.m_BaseClassifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific toscheme " + this.m_BaseClassifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_BaseClassifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('B', stringArray);
        if (string.length() == 0) {
            throw new Exception("A learning scheme must be specified with-B option");
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
        string = Utils.getOption('F', stringArray);
        if (string.length() != 0) {
            this.setFolds(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('T', stringArray)).length() != 0) {
            Double d = Double.valueOf(string);
            this.setThreshold(d);
        }
    }

    public String thresholdTipText() {
        return "Repeat xval if stdev of mean exceeds this value.";
    }

    public void setThreshold(double d) {
        this.m_threshold = d;
    }

    public double getThreshold() {
        return this.m_threshold;
    }

    public String foldsTipText() {
        return "Number of xval folds to use when estimating subset accuracy.";
    }

    public void setFolds(int n) {
        this.m_folds = n;
    }

    public int getFolds() {
        return this.m_folds;
    }

    public String seedTipText() {
        return "Seed to use for randomly generating xval splits.";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String classifierTipText() {
        return "Classifier to use for estimating the accuracy of subsets";
    }

    public void setClassifier(Classifier classifier) {
        this.m_BaseClassifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_BaseClassifier;
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_BaseClassifier != null && this.m_BaseClassifier instanceof OptionHandler) {
            stringArray = this.m_BaseClassifier.getOptions();
        }
        String[] stringArray2 = new String[9 + stringArray.length];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-B";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "-F";
        stringArray2[n++] = "" + this.getFolds();
        stringArray2[n++] = "-T";
        stringArray2[n++] = "" + this.getThreshold();
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.getSeed();
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_Evaluation = null;
        this.m_BaseClassifier = new ZeroR();
        this.m_folds = 5;
        this.m_seed = 1;
        this.m_threshold = 0.01;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException("Can't handle string attributes!");
        }
        this.m_trainInstances = instances;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        int n;
        double d = 0.0;
        double[] dArray = new double[5];
        boolean bl = true;
        int n2 = 0;
        Random random = new Random(this.m_seed);
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        Instances instances = new Instances(this.m_trainInstances);
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        for (n = 0; n < 5; ++n) {
            this.m_Evaluation = new Evaluation(instances);
            this.m_Evaluation.crossValidateModel(this.m_BaseClassifier, instances, this.m_folds, random);
            dArray[n] = this.m_Evaluation.errorRate();
            if (this.repeat(dArray, n + 1)) continue;
            ++n;
            break;
        }
        for (n3 = 0; n3 < n; ++n3) {
            d += dArray[n3];
        }
        this.m_Evaluation = null;
        return -(d /= (double)n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainInstances == null) {
            stringBuffer.append("\tWrapper subset evaluator has not been built yet\n");
        } else {
            stringBuffer.append("\tWrapper Subset Evaluator\n");
            stringBuffer.append("\tLearning scheme: " + this.getClassifier().getClass().getName() + "\n");
            stringBuffer.append("\tScheme options: ");
            String[] stringArray = new String[]{};
            if (this.m_BaseClassifier instanceof OptionHandler) {
                stringArray = this.m_BaseClassifier.getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
            }
            stringBuffer.append("\n");
            if (this.m_trainInstances.attribute(this.m_classIndex).isNumeric()) {
                stringBuffer.append("\tAccuracy estimation: RMSE\n");
            } else {
                stringBuffer.append("\tAccuracy estimation: classification error\n");
            }
            stringBuffer.append("\tNumber of folds for accuracy estimation: " + this.m_folds + "\n");
        }
        return stringBuffer.toString();
    }

    private boolean repeat(double[] dArray, int n) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        if (n == 1) {
            return true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            d += dArray[n2];
        }
        d /= (double)n;
        for (n2 = 0; n2 < n; ++n2) {
            d2 += (dArray[n2] - d) * (dArray[n2] - d);
        }
        if ((d2 /= (double)n) > 0.0) {
            d2 = Math.sqrt(d2);
        }
        return d2 / d > this.m_threshold;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(AttributeSelection.SelectAttributes(new WrapperSubsetEval(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
    }
}

