/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.StreamableFilter;

public class MultiFilter
extends SimpleStreamFilter {
    private static final long serialVersionUID = -6293720886005713120L;
    protected Filter[] m_Filters = new Filter[]{new AllFilter()};
    protected boolean m_Streamable = false;
    protected boolean m_StreamableChecked = false;

    public String globalInfo() {
        return "Applies several filters successively. In case all supplied filters are StreamableFilters, it will act as a streamable one, too.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tA filter to apply (can be specified multiple times).", "F", 1, "-F <classname [options]>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        super.setOptions(stringArray);
        Vector<Object> vector = new Vector<Object>();
        while ((string = Utils.getOption("F", stringArray)).length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            vector.add(Utils.forName(Filter.class, string2, stringArray2));
        }
        if (vector.size() == 0) {
            vector.add(new AllFilter());
        }
        this.setFilters(vector.toArray(new Filter[vector.size()]));
    }

    public String[] getOptions() {
        int n;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        for (n = 0; n < this.getFilters().length; ++n) {
            vector.add("-F");
            vector.add(this.getFilterSpec(this.getFilter(n)));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        if (this.getFilters().length == 0) {
            return super.getCapabilities();
        }
        return this.getFilters()[0].getCapabilities();
    }

    protected void reset() {
        super.reset();
        this.m_StreamableChecked = false;
    }

    public void setFilters(Filter[] filterArray) {
        this.m_Filters = filterArray;
        this.reset();
    }

    public Filter[] getFilters() {
        return this.m_Filters;
    }

    public String filtersTipText() {
        return "The base filters to be used.";
    }

    public Filter getFilter(int n) {
        return this.m_Filters[n];
    }

    protected String getFilterSpec(Filter filter) {
        String string;
        if (filter == null) {
            string = "";
        } else {
            string = filter.getClass().getName();
            if (filter instanceof OptionHandler) {
                string = string + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
            }
        }
        return string;
    }

    public boolean isStreamableFilter() {
        if (!this.m_StreamableChecked) {
            this.m_Streamable = true;
            this.m_StreamableChecked = true;
            for (int i = 0; i < this.getFilters().length; ++i) {
                this.m_Streamable = this.getFilter(i) instanceof MultiFilter ? ((MultiFilter)this.getFilter(i)).isStreamableFilter() : this.getFilter(i) instanceof StreamableFilter;
                if (!this.m_Streamable) break;
            }
            if (this.getDebug()) {
                System.out.println("Streamable: " + this.m_Streamable);
            }
        }
        return this.m_Streamable;
    }

    protected boolean hasImmediateOutputFormat() {
        return this.isStreamableFilter();
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        Instances instances2 = this.getInputFormat();
        for (int i = 0; i < this.getFilters().length; ++i) {
            if (!this.isFirstBatchDone()) {
                this.getFilter(i).setInputFormat(instances2);
            }
            instances2 = this.getFilter(i).getOutputFormat();
        }
        return instances2;
    }

    protected Instance process(Instance instance) throws Exception {
        Instance instance2 = (Instance)instance.copy();
        for (int i = 0; i < this.getFilters().length; ++i) {
            this.getFilter(i).input(instance2);
            instance2 = this.getFilter(i).output();
        }
        return instance2;
    }

    protected Instances process(Instances instances) throws Exception {
        Instances instances2 = instances;
        for (int i = 0; i < this.getFilters().length; ++i) {
            if (!this.isFirstBatchDone()) {
                this.getFilter(i).setInputFormat(instances2);
            }
            instances2 = Filter.useFilter(instances2, this.getFilter(i));
        }
        return instances2;
    }

    public static void main(String[] stringArray) {
        MultiFilter.runFilter(new MultiFilter(), stringArray);
    }
}

