/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import weka.core.Instances;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ViewerDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTableCellRenderer;

public class ArffTable
extends JTable {
    static final long serialVersionUID = -2016200506908637967L;
    private String searchString;
    private HashSet changeListeners;

    public ArffTable() {
        this(new ArffSortedTableModel(""));
    }

    public ArffTable(TableModel tableModel) {
        super(tableModel);
        this.setAutoResizeMode(0);
    }

    public void setModel(TableModel tableModel) {
        this.searchString = null;
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet();
        }
        super.setModel(tableModel);
        if (tableModel == null) {
            return;
        }
        if (!(tableModel instanceof ArffSortedTableModel)) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)tableModel;
        arffSortedTableModel.addMouseListenerToHeader(this);
        arffSortedTableModel.addTableModelListener(this);
        arffSortedTableModel.sort(0);
        this.setLayout();
        this.setSelectedColumn(0);
        if (this.getTableHeader() != null) {
            this.getTableHeader().setReorderingAllowed(false);
        }
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableCellEditor tableCellEditor = this.getModel() instanceof ArffSortedTableModel && ((ArffSortedTableModel)this.getModel()).getType(n2) == 4 ? new RelationalCellEditor(n, n2) : super.getCellEditor(n, n2);
        return tableCellEditor;
    }

    private void setLayout() {
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.getModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            JTableHelper.setOptimalHeaderWidth(this, i);
            this.getColumnModel().getColumn(i).setCellRenderer(new ArffTableCellRenderer());
            if (i <= 0) continue;
            if (arffSortedTableModel.getType(i) == 1) {
                JComboBox jComboBox = new JComboBox();
                jComboBox.addItem(null);
                Enumeration enumeration = arffSortedTableModel.getInstances().attribute(i - 1).enumerateValues();
                while (enumeration.hasMoreElements()) {
                    jComboBox.addItem(enumeration.nextElement());
                }
                this.getColumnModel().getColumn(i).setCellEditor(new DefaultCellEditor(jComboBox));
                continue;
            }
            this.getColumnModel().getColumn(i).setCellEditor(null);
        }
    }

    public String getPlainColumnName(int n) {
        String string = "";
        if (this.getModel() == null) {
            return string;
        }
        if (!(this.getModel() instanceof ArffSortedTableModel)) {
            return string;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.getModel();
        if (n >= 0 && n < this.getColumnCount()) {
            string = n == 0 ? "No." : arffSortedTableModel.getAttributeAt(n).name();
        }
        return string;
    }

    public StringSelection getStringSelection() {
        int n;
        int[] nArray;
        StringSelection stringSelection = null;
        if (this.getSelectedRow() == -1) {
            if (ComponentHelper.showMessageBox(this.getParent(), "Question...", "Do you really want to copy the whole table?", 0, 3) != 0) {
                return stringSelection;
            }
            nArray = new int[this.getRowCount()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
        } else {
            nArray = this.getSelectedRows();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(this.getPlainColumnName(n));
        }
        stringBuffer.append("\n");
        for (n = 0; n < nArray.length; ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (i > 0) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(this.getValueAt(nArray[n], i).toString());
            }
            stringBuffer.append("\n");
        }
        stringSelection = new StringSelection(stringBuffer.toString());
        return stringSelection;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.repaint();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSelectedColumn(int n) {
        this.getColumnModel().getSelectionModel().clearSelection();
        this.getColumnModel().getSelectionModel().setSelectionInterval(n, n);
        this.resizeAndRepaint();
        if (this.getTableHeader() != null) {
            this.getTableHeader().resizeAndRepaint();
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.setLayout();
        this.notifyListener();
    }

    private void notifyListener() {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected class RelationalCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 657969163293205963L;
        protected JButton m_Button;
        protected Instances m_CurrentInst;
        protected int m_RowIndex;
        protected int m_ColumnIndex;

        public RelationalCellEditor(int n, int n2) {
            this.m_CurrentInst = this.getInstancesAt(n, n2);
            this.m_RowIndex = n;
            this.m_ColumnIndex = n2;
            this.m_Button = new JButton("...");
            this.m_Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ViewerDialog viewerDialog = new ViewerDialog(null);
                    viewerDialog.setTitle("Relational attribute Viewer - " + ((ArffSortedTableModel)ArffTable.this.getModel()).getInstances().attribute(RelationalCellEditor.this.m_ColumnIndex - 1).name());
                    int n = viewerDialog.showDialog(RelationalCellEditor.this.m_CurrentInst);
                    if (n == 0) {
                        RelationalCellEditor.this.m_CurrentInst = viewerDialog.getInstances();
                        RelationalCellEditor.this.fireEditingStopped();
                    } else {
                        RelationalCellEditor.this.fireEditingCanceled();
                    }
                }
            });
        }

        protected Instances getInstancesAt(int n, int n2) {
            ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)ArffTable.this.getModel();
            double d = arffSortedTableModel.getInstancesValueAt(n, n2);
            Instances instances = arffSortedTableModel.getInstances().attribute(n2 - 1).relation((int)d);
            return instances;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.m_Button;
        }

        public Object getCellEditorValue() {
            return this.m_CurrentInst;
        }
    }
}

