% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_characters.R
\name{rx_alpha}
\alias{rx_alpha}
\title{Match alphabetic characters.}
\usage{
rx_alpha(.data = NULL, inverse = FALSE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{inverse}{Invert match behavior, defaults to \code{FALSE} (match
alphabetic characters). Use \code{TRUE} to \emph{not} match alphabetic
characters.}
}
\description{
Matches letters (case insensitive) only.
}
\examples{
rx_alpha()
rx_alpha(inverse = TRUE)

# create an expression
x <- rx_alpha()

# create input
string <- "Apple 1!"

# extract match
regmatches(string, gregexpr(x, string))
}
