% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special_characters.R
\name{rx_alnum}
\alias{rx_alnum}
\title{Match alphanumeric characters.}
\usage{
rx_alnum(.data = NULL, inverse = FALSE)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{inverse}{Invert match behavior, defaults to \code{FALSE} (match
alphanumeric characters). Use \code{TRUE} to \emph{not} match alphanumeric
characters.}
}
\description{
Matches both letters (case insensitive) and numbers (a through
z and 0 through 9).
}
\examples{
rx_alnum()
rx_alnum(inverse = TRUE)

# create an expression
x <- rx_alnum()

# create input
string <- "Apple 1!"

# extract match
regmatches(string, gregexpr(x, string))
}
