% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R, R/package-RVenn.R
\docType{methods}
\name{ggvenn,Venn-method}
\alias{ggvenn,Venn-method}
\alias{ggvenn}
\title{Draw the Venn diagram}
\usage{
\S4method{ggvenn}{Venn}(venn = "Venn", slice = "all",
  fill = c("gold", "dodgerblue3", "deeppink"), alpha = 0.5,
  thickness = 1.5)
}
\arguments{
\item{venn}{(Required) A \code{Venn} object.}

\item{slice}{(Optional) A character or numeric vector to pick 2 or 3 sets.
Default is "all", which is for the cases the \code{Venn} object only
contains 2 or 3 sets. If you have 4 or more sets, this argument is
required.}

\item{fill}{(Optional) Fill color of the sets.}

\item{alpha}{(Optional) Opacity of the fill colors. Default is 0.5 in the
range of (0, 1).}

\item{thickness}{(Optional) Stroke size of the sets.}
}
\value{
The function returns the plot in ggplot2 style.
}
\description{
Draw the Venn diagram for 2 or 3 sets
}
\details{
This function is based on the packages \code{ggplot} and \code{ggforce}. It
has been designed for 2 or 3 sets because Venn diagrams are terrible for
showing the interactions of 4 or more sets. If you need to visualize such
interactions, consider using \href{http://caleydo.org/tools/upset/}{UpSet}.
}
\examples{
venn = construct(list(letters[1:10], letters[3:12], letters[6:15]))
ggvenn(venn)
ggvenn(venn, slice = c(1, 2), thickness = 0, alpha = 0.3)
}
