% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Preparation.hap.perm.R
\name{Preparation.hap.perm}
\alias{Preparation.hap.perm}
\title{Prepare for the haplotype permutation}
\usage{
Preparation.hap.perm(pedigree, generation.id, indices.haplotypes1,
  indices.haplotypes2)
}
\arguments{
\item{pedigree}{data frame with pedigree information in linkage
format (four columns: family ID, individual ID, father ID, mother
ID). For example the first for columns of a Plink \code{.ped} file
or a Plink \code{.bim} file.}

\item{generation.id}{a vector of length(sample size) which
indicates if the subject is founder (\code{generation.id=0}),
a child from first generation (\code{generation.id=1}), a
child from second generation (\code{generation.id=2}), etc.
This vector can be calculated by the
\code{kinship2::kindepth()} function.}
}
\value{
a list of vectors with indices of various parts of the
pedigree.
}
\description{
This functions prepares for running the \code{\link{perm.hap}}
function. The output of this function can be passed to that one.
}
\author{
Karim Oualkacha

M'Hamed Lajmi Lakhal-Chaieb
}
\seealso{
\code{\link{read.pedigree}}
}
\keyword{internal}

