plotresid <-
function (model,shapiro=FALSE) {
  if ("lm"%in%class(model)) {
    if (!"glm"%in%class(model)) {
	model.residuals <- residuals(model)
	res.lab <- "Residuals"
    } else {
	if ("negbin"%in%class(model)) {
	  model.residuals <- qresiduals(model)
	  res.lab <- "Quantile residuals"
	} else {
	  laws <- c("poisson","quasipoisson","binomial","quasibinomial")
	  if (model$family[1]%in%laws) {
	    model.residuals <- qresiduals(model)
	    res.lab <- "Quantile residuals"
	  } else {
	    model.residuals <- residuals(model)
	    res.lab <- "Residuals"
	  }
	}
    }
  } else if ("mer"%in%class(model)) {
    model.residuals <- model@resid
    res.lab <- "Residuals"
  } else if ("glmmadmb"%in%class(model)) {
    model.residuals <- model$resid
    res.lab <- "Residuals"
  } else if (any(c("survreg","least.rect","lme","nls")%in%class(model))) {
    model.residuals <- residuals(model)
    res.lab <- "Residuals"
  } else {
    stop("model not recognized")
  }
  fit <- if (any(c("lm","least.rect","glmmadmb","lme","nls")%in%class(model))) {
    fitted(model)
  } else if ("mer"%in%class(model)) {
    model@X%*%lme4:::fixef(model)
  } else if ("survreg"%in%class(model)) {
    predict(model)
  }
  opar <- par(no.readonly=TRUE)
  on.exit(par(opar))
  par(mfrow=c(1,2))
  plot(fit,model.residuals,xlab="Fitted values",ylab=res.lab,main=paste(res.lab,"vs fitted"))
  abline(h=0,col="grey",lty=3)
  panel.smooth(fit,model.residuals)
  qqPlot(model.residuals,lwd=1,grid=FALSE,xlab="Theoretical quantiles",ylab="Sample quantiles")
  if (shapiro) {
    shapiro.test(model.residuals)
  }
}
