% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pathway.R
\name{cal.pathway.scores}
\alias{cal.pathway.scores}
\title{calculate pathway scores}
\usage{
cal.pathway.scores(
  data,
  pathway.db,
  gene.id.type,
  FCflag,
  FDRflag,
  FC.cutoff,
  FDR.cutoff,
  OUT.Directional = NULL,
  IS.list = FALSE,
  customized.pathways,
  ...
)
}
\arguments{
\item{data}{A summary statistics table (data.frame) or \code{data.list} generated by DE analysis software like limma or DEseq2}

\item{pathway.db}{pathway database used}

\item{gene.id.type}{gene.id.type}

\item{FCflag}{The column name (character) of fold change information, assuming the FC is log2 transformed. Default = "logFC".}

\item{FDRflag}{The column name (character) of adjusted p value or FDR. Default = "adj.P.Val".}

\item{FC.cutoff}{The fold change cutoff (numeric) selected to subset summary statistics table. Default = 1.5.}

\item{FDR.cutoff}{The FDR cutoff selected (numeric) to subset summary statistics table. Default = 0.05.}

\item{OUT.Directional}{logical, whether output directional or non-directional pathway analysis result, default: NULL.}

\item{IS.list}{logical, whether the input is a list, default: NULL}

\item{customized.pathways}{the customized pathways in the format of two column dataframe to be used in analysis}

\item{...}{pass over parameters}
}
\value{
Returns a dataframe.
}
\description{
Calculate pathway scores
}
\references{
Xingpeng Li & Siddhartha Pachhai RVA - RNAseq Visualization Automation tool.
}
