% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundaries.R
\name{boundaries}
\alias{boundaries}
\title{Boundaries for group sequential designs}
\usage{
boundaries(
  timing,
  alpha = 0.05,
  beta = 0.1,
  side = 2,
  futility = "none",
  es_alpha = "esOF",
  es_beta = NULL,
  type = "design",
  design_R = NULL,
  tol = 1e-09
)
}
\arguments{
\item{timing}{Expected timings of interim analyses and final analysis as a vector consisting of values from 0 to 1.}

\item{alpha}{The level of type I error as a percentage, the default is 0.05 corresponding to 5\%.}

\item{beta}{The level of type II error as a percentage, the default is 0.1 corresponding to 10\%.}

\item{side}{Whether a 1- or 2-sided hypothesis test is used. Defaults to 2. Options are 1 or 2.}

\item{futility}{Futility boundaries added to design. Options are: none, non-binding and binding. Default is "none".}

\item{es_alpha}{The error spending function for alpha-spending. Options are: "esOF" (Lan & DeMets version of O'Brien-Fleming boundaries), "esPoc" (Lan & DeMets version of Pocock boundaries), "HSDC" (Hwang Sihi and DeCani) and "rho" (rho family). Defaults to "esOF".}

\item{es_beta}{The error spending function for beta-spending. For options see es_alpha. Defaults to NULL.}

\item{type}{Whether the boundaries are used for design or analysis. We recommend only to use the boundaries() function with type equal to design. Defaults to design.}

\item{design_R}{If type is analysis, a scalar for achieving the right amount of power is required. It is recommended not to use the boundaires() function with the setting type equal to analysis. Defaults to NULL.}

\item{tol}{Tolerance level for numerical integration. Defaults to 1e-09.}
}
\value{
A \code{boundaries} object which includes:
\item{inf_frac}{Timing of interim analyses and final analysis. Potentially modified if \code{type = "analysis"}.}
\item{org_inf_frac}{Original timing. If \code{type = "design"}.}
\item{alpha_ubound}{Upper alpha-spending boundaries}
\item{alpha_lbound}{Lower alpha-spending boundaries}
\item{alpha}{As input}
\item{alpha_spend}{List of cumulative and incremental spending}
\item{delta}{Drift parameter}
\item{design_R}{If \code{type = "analysis"} it is the scalar for correct power in the design. Else NULL.}
\item{info}{List of the information as the squareroot of the information increments and the squareroot of the cumulative information}
\item{beta_ubound}{Upper beta-spending boundaries}
\item{beta_lbound}{Lower beta-spending boundaries}
\item{root}{Scalar for achieving correct power}
\item{beta_spend}{List of cumulative and incremental spending}
\item{pwr}{List of probabilities for rejecting the null under the sample size settings being true at each analysis and the sum.}
\item{tIe}{List of probabilities for type-I-error at each analysis and the sum}
\item{side}{As input}
\item{beta}{As input}
\item{es_alpha}{As input}
\item{es_beta}{As input}
\item{type}{As input}
\item{futility}{As input}
}
\description{
Calculates alpha- and potentially beta-spending boundaries for group sequential designs for meta-analysis. Should be used for exploring how the different arguments affect the sequential design. The function is not intended to be used individually for Trial Sequential Analysis. For this purpose, we recommend RTSA().
}
\examples{
boundaries(timing = c(0.25, 0.5, 0.75, 1), alpha = 0.05, beta = 0.1,
 side = 2, futility = "non-binding", es_alpha = "esOF", es_beta = "esOF")

}
