% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EditData.R
\name{EditData}
\alias{EditData}
\title{GUI: Data Editor}
\usage{
EditData(d, col.names = names(d), row.names = NULL, col.formats = NULL,
  read.only = FALSE, changelog = NULL, win.title = "Data",
  parent = NULL)
}
\arguments{
\item{d}{list, matrix, or data.frame.
Data used to populate the data table.}

\item{col.names}{character.
Vector of column names}

\item{row.names}{character.
Vector of row names}

\item{col.formats}{character.
Vector of format conversion specification strings, see \code{\link{sprintf}} and \code{\link{strftime}}.}

\item{read.only}{logical.
Specifies whether the data table is in read only mode.}

\item{changelog}{data.frame.
History of all data table edits, see \sQuote{Value} section.}

\item{win.title}{character.
String to display as the title of the dialog box.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns \code{NULL} if no edits were made; otherwise,
  new values of \code{d} and \code{changelog} are returned as components in a \code{list}.
  The \code{changelog} data table contains the following variables:
    \item{timestamp}{a date-time value that identifies when the edit event occurred.}
    \item{record}{row name}
    \item{variable}{column name}
    \item{old}{value before editing}
    \item{new}{value after editing}
}
\description{
A graphical user interface (\acronym{GUI}) for viewing and editing table formatted data.
}
\details{
Row titles are taken from the row names attribute of argument \code{d}.
  Pattern searches are performed using \code{\link{grep}}.
  Edits are reflected in the \code{changelog}.
}
\note{
Requires the Tcl package \href{http://tktable.sourceforge.net/}{Tktable}.
}
\examples{
\dontrun{
  tcltk::tclRequire("Tktable", warn = TRUE)

  n <- 1000L
  V1 <- sample(c(1:9, NA), n, replace = TRUE)
  V2 <- sample(LETTERS, n, replace = TRUE)
  V3 <- as.POSIXct(rnorm(n, mean = 0, sd = 1e6), origin = "2010-01-01")
  V4 <- sample(V1 * pi, n)
  d <- data.frame(V1, V2, V3, V4)
  col.names <- c("Integers", "Letters", "DateTime", "Numeric")
  col.formats <- c("\%d", "\%s", "\%m/\%d/\%Y \%H:\%M", "")
  obj <- EditData(d, col.names, col.formats)
  str(obj)

  rownames(d) <- paste0(sample(LETTERS, n, replace = TRUE), seq_len(n))
  EditData(d, read.only = TRUE)

  colnames(d) <- NULL
  rownames(d) <- NULL
  EditData(d, read.only = TRUE)
}

}
\seealso{
\code{\link{BuildHistogram}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
