% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_based_functions.R
\name{epi.calc}
\alias{epi.calc}
\title{Effective probability of infection (EPI)}
\usage{
epi.calc(pstar, rr, ppr)
}
\arguments{
\item{pstar}{design prevalence (scalar)}

\item{rr}{relative risk values (vector of values corresponding to 
the number of risk strata)}

\item{ppr}{population proportions corresponding to rr values 
(vector of equal length to rr)}
}
\value{
list of 2 elements, a vector of EPI values and a vector of corresponding
  adjusted risks (in corresponding order to rr)
}
\description{
Calculates effective probability of infection (adjusted design prevalence)
  for each risk group for risk-based surveillance activities
}
\examples{
# examples for epi.calc
epi.calc(0.1, c(5, 1), c(0.1, 0.9))
epi.calc(0.02, c(5, 3, 1), c(0.1, 0.1, 0.8))
}
\keyword{methods}

