% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_api_tmpl.R
\name{tmpl_start}
\alias{tmpl_start}
\title{Creates a new template with the specified name, in the specified path.}
\usage{
tmpl_start(name, path = getwd(), add_prj = TRUE, add_pkg = TRUE,
  base_tmpl = "builtin")
}
\arguments{
\item{name}{name of the template being created. (type: character(1))}

\item{path}{path to the directory where the template should be created. If
NULL will use the folder with user template. (type: character(1), default: getwd())}

\item{add_prj}{if TRUE include project template to the template directory}

\item{add_pkg}{if TRUE include package template in the template directory}

\item{base_tmpl}{name of the package and/or project template (or path to it) to use for
template creation. (type: character(1); default: builtin).}
}
\description{
Creates a new template with the specified name, in the specified path.
}
\details{
Project templates are required to include a PARAMETERS file
whereas package templates are required to include a DESCRIPTION file

If there is no path argument provided. The function will create the
template in working directory.
}
\examples{
tmpl_dir <- tempfile("templ_")
tmpl_start(basename(tmpl_dir), path = tempdir())

}
\seealso{
Other in templates management: \code{\link{tmpl_list_registered}}
}
\concept{in templates management}
