% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_api_pkgzip.R
\name{pkgzip_build_package_files}
\alias{pkgzip_build_package_files}
\title{Builds PKGZIP out of passed package files.}
\usage{
pkgzip_build_package_files(files, path = getwd())
}
\arguments{
\item{files}{vector of files to upload. (type: character)}

\item{path}{folder path to put output zip into. The folder must exist.
(type: character: default:  \code{getwd()})}
}
\value{
created pkgzip file path (invisible).
}
\description{
Builds PKGZIP out of passed package files.
}
\details{
Logs all messages onto rsuite logger. Use  \code{logging::setLevel} to control logs
verbosity.
}
\examples{
\donttest{
  # download logging package
  pkg_fpath <- utils::download.packages("logging",
                                        repos = "https://cloud.r-project.org/",
                                        destdir = tempdir())[1,2]

  # build PKGZIP
  pkgzip_fpath <- pkgzip_build_package_files(files = pkg_fpath, path = tempdir())

  # list content of pkgzip created
  unzip(pkgzip_fpath, list = TRUE)
}

}
\seealso{
Other in PKGZIP building: \code{\link{pkgzip_build_bioc_package}},
  \code{\link{pkgzip_build_ext_packages}},
  \code{\link{pkgzip_build_github_package}},
  \code{\link{pkgzip_build_prj_packages}}
}
