% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_rc_adapter.R
\name{rc_adapter_get_version}
\alias{rc_adapter_get_version}
\title{Retrieves current RC version number for working copy at directory passed.}
\usage{
rc_adapter_get_version(rc_adapter, dir)
}
\arguments{
\item{rc_adapter}{rc adapter object}

\item{dir}{path to directory to get version for. Folder must exist (type: character)}
}
\value{
named list with following entries:
\describe{
  \item{has_changes}{TRUE if changes detected by RC in the directory. (type: logical)}
  \item{revision}{revision reported by RC. (type: character)}
  \item{latest}{latest revision reported by RC at repository. (type: character)}
}
}
\description{
Retrieves current RC version number for working copy at directory passed.
}
\examples{
# create you own RC adapter
rc_adapter_create_own <- function() {
  result <- rc_adapter_create_base("Own")
  class(result) <- c("rc_adapter_own", class(result))
  return(result)
}

#' @export
rc_adapter_get_version.rc_adapter_own <- function(rc_adapter, dir) {
  # ... detect if working copy is consistent with repository state ...
  return(list(has_changes = TRUE,
              revision = "0.0",
              latest = FALSE))
}

}
\seealso{
Other in extending RSuite with RC adapter: \code{\link{rc_adapter_create_base}},
  \code{\link{rc_adapter_is_under_control}},
  \code{\link{rc_adapter_pkg_struct_add}},
  \code{\link{rc_adapter_prj_struct_add}},
  \code{\link{rc_adapter_remove_admins}}
}
