% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-raster.R
\name{fortify.raster}
\alias{fortify.RasterBrick}
\alias{fortify.RasterLayer}
\alias{fortify.RasterStack}
\alias{fortify.raster}
\title{Fortify method for classes from the raster package.}
\usage{
\method{fortify}{RasterLayer}(x, maxpixels = 50000)

\method{fortify}{RasterBrick}(...)

\method{fortify}{RasterStack}(...)
}
\arguments{
\item{x}{\code{Raster*} object to convert into a dataframe.}

\item{maxpixels}{Integer. Maximum number of pixels to sample}

\item{...}{not used by this method}
}
\value{
Returns a data.frame with coordinates (x,y) and corresponding raster values.
}
\description{
Fortify method for classes from the raster package.
}
\examples{
library(ggplot2)
data(rlogo)
r_df <- fortify(rlogo)
head(r_df)

}

