\name{PackageSum2}
\alias{PackageSum2}
\title{
  Add Info from Installed Packages to PackageSummary
}
\description{
  Given a \code{data.frame} with a column \code{Packages}, add other
  columns from \code{attributes} of \code{packageDescription}.
}
\usage{
PackageSum2(x,
        fields=c("Title", "Version", "Author", "Maintainer", "Packaged"),
            lib.loc=NULL )
}
\arguments{
  \item{x}{
    a data.frame with columns \code{Package} and \code{Score}.
  }
  \item{fields}{
    character vector of names to look for in components of
    \code{packageDescription(x$Package[i])} and return as additional
    columns of \code{x} if found.

    Component 'Packaged' receives special treatment.  If present, only
    the portion preceding ';' will be retained.  This seems to be a time
    stamp automatically generated by something like \code{R CMD build}.
    It is absent for packages automatically loaded when R is started.
    In such cases, the third component of \code{strsplit(
    packageDescription( x$Package[i])$Built, ..., ';')} will be stored
    as 'Packaged'.  This seems to be a time stamp automatically
    generated by something like \code{R CMD INSTALL --build}.
  }
  \item{lib.loc}{
    an optional \code{lib.loc} argument passed to
    \code{packageDescription}.
  }
}
%\details{}
\value{
  a data.frame with additional \code{fields} columns appended to
  \code{x}.
}
\seealso{
  \code{\link{RSiteSearch.function}}
  \code{\link{PackageSummary}}
}
\examples{
tstdf <- data.frame(Package=c('fda', 'base'))
PackageSum2(tstdf)
}
\keyword{package}
