% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/QueueFallout.R
\name{QueueFallout}
\alias{QueueFallout}
\title{Run a Fallout Report}
\usage{
QueueFallout(reportsuite.id, date.from, date.to, metrics, element, checkpoints,
  segment.id = "", expedite = FALSE, interval.seconds = 5,
  max.attempts = 120)
}
\arguments{
\item{reportsuite.id}{Report suite id}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{metrics}{List of metrics to include in the report}

\item{element}{Single pathed element (usually 'page')}

\item{checkpoints}{Character vector of checkpoints in the fallout path (e.g. c("Home","Contact","Thank You"))}

\item{segment.id}{Id of Adobe Analytics segment to retrieve the report for}

\item{expedite}{Set to TRUE to expedite the processing of this report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}
}
\value{
Data frame
}
\description{
A QueueFallout Report is a report that shows how visitors drop out
as part of a specified path.
}
\details{
Because of the Reporting API structure, this function first
requests the report, then checks the reporting queue to see if the report
is completed, and when the report returns as "done" pulls the report from the
API. This checking process will occur up to the specified number of times
(default 120), with a delay between status checks (default 5 seconds). If the
report does not return as "done" after the number of tries have completed, the
function will return an error message.
}
\examples{
\dontrun{

falloutpattern <- c("Home Page","Contact Page","Login Page")
queue_fallout_pages <- QueueFallout("your_report_suite",
                                    "2014-04-01",
                                    "2014-04-20",
                                    metric="pageviews",
                                    element="page",
                                    falloutpattern
                                    )

}
}

