% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scelestial.R
\name{as.ten.state.matrix.from.node.seq}
\alias{as.ten.state.matrix.from.node.seq}
\title{Generates 10-state sequence matrix from name/10-char string
matrix.}
\usage{
as.ten.state.matrix.from.node.seq(n.seq)
}
\arguments{
\item{n.seq}{A two column data frame. First column is the name of a node
and the second column is a string representation of the sequencing result.
Each element of the sequencing result is from a 10-state representation in which
each state represented as a character according to the following encoding:
 \tabular{cc}{
   One character representation \tab 10-state representation  \cr
   "A" \tab "A/A",    \cr
   "T" \tab "T/T", \cr
   "C" \tab "C/C", \cr
   "G" \tab "G/G", \cr
   "K" \tab "A/C", \cr
   "L" \tab "A/G", \cr
   "M" \tab "C/T", \cr
   "N" \tab "C/G", \cr
   "O" \tab "T/G", \cr
   "P" \tab "T/A", \cr
   "X" \tab "./."
 }}
}
\value{
A 10-state sequence data frame with samples as columns
  and loci as rows. Elements of \code{n.seq} are translated
  to their 10-state representations.
}
\description{
This function is used for conversion of results of internal
scelestial result to 10-state sequence matrices.
}
\examples{
## A node sequence data framce
n.seq = data.frame("node" = c("C1", "C2"), "seq" = c("AKLTCXAAC", "AKKOCXAPC"), 
          stringsAsFactors = TRUE)
## Convert it to ten state matrix
as.ten.state.matrix.from.node.seq(n.seq)
#     V1  V2  V3  V4  V5  V6  V7  V8  V9
# C1 A/A A/C A/G T/T C/C ./. A/A A/A C/C
# C2 A/A A/C A/C T/G C/C ./. A/A T/A C/C

}
