% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_update_model.R
\name{update_model}
\alias{update_model}
\title{Update model}
\usage{
update_model(RSTr_obj, iterations = 6000, show_plots = TRUE, verbose = TRUE)
}
\arguments{
\item{RSTr_obj}{The \code{RSTr} model object to generate samples for.}

\item{iterations}{Number of iterations to run.}

\item{show_plots}{If set to \code{FALSE}, hides traceplots.}

\item{verbose}{If set to \code{FALSE}, hides progress bar and other messages.}
}
\value{
An \code{RSTr} model object.
}
\description{
\code{update_model()} generates additional samples for model \code{RSTr_obj}.
}
\examples{
data_min <- lapply(miheart, \(x) x[1:2, 1:3, 1:3])
adj_min <- list(2, 1)
mod_mst <- mstcar("test", data_min, adj_min, tempdir(), show_plots = FALSE, verbose = FALSE)
mod_mst <- update_model(mod_mst, iterations = 1000, show_plots = FALSE, verbose = FALSE)
\dontshow{
unlink(paste0(tempdir(), "\\\\test"), recursive = TRUE)
}
}
