# This script scans the vdbe.c source file and uses information found
# there to generate C code that maps opcode numbers into strings
# containing the names of the opcodes and pointers to functions that
# implement the opcode
#
BEGIN {
  print "/* This code is automatically generated by \"mkopcodec.awk\" */"
  print "static const struct {"
  print "  int opcode;"
  print "  const char *zOpName;"
  print "  int (*xFunc)(Vdbe *p, Opcode *pOp);"
  print "} aOpTable[] = {"
  print "  { 0, 0, 0 },"
  seenop = 0;
}
/^.. Opcode: / {
  op[seenop] = $3
  seenop++;
}
/_[a-zA-Z].*{/ {
  if( seenop ){
    i = index($0,"_")
    name = substr($0,i+1);
    gsub(/[^a-zA-Z].*/,"",name)
    for(i=0; i<seenop; i++){
      ox = "OP_" op[i] ","
      nx = "\"" op[i] "\","
      fx = "opcode_" name
      printf "  { %-20s %-20s %-30s },\n", ox, nx, fx
    }
    seenop = 0;
  }
}
END {
  print "};"
}
