% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi-classes.R, R/dbi-methods.R
\docType{class}
\name{SQLServerPreResult-class}
\alias{SQLServerPreResult-class}
\alias{SQLServerResult-class}
\alias{SQLServerUpdateResult-class}
\alias{dbIsValid,SQLServerResult-method}
\alias{dbFetch,SQLServerPreResult,numeric-method}
\alias{fetch,SQLServerPreResult,numeric-method}
\alias{fetch,SQLServerUpdateResult,numeric-method}
\alias{dbBind,SQLServerPreResult-method}
\alias{dbFetch,SQLServerResult,numeric-method}
\alias{fetch,SQLServerResult,numeric-method}
\alias{dbColumnInfo,SQLServerResult-method}
\alias{dbClearResult,SQLServerResult-method}
\alias{dbGetStatement,SQLServerResult-method}
\alias{dbGetRowCount,SQLServerResult-method}
\alias{dbGetRowsAffected,SQLServerResult-method}
\alias{dbGetRowsAffected,SQLServerUpdateResult-method}
\alias{dbHasCompleted,SQLServerResult-method}
\alias{dbHasCompleted,SQLServerUpdateResult-method}
\title{SQL Server Result classes}
\usage{
\S4method{dbIsValid}{SQLServerResult}(dbObj)

\S4method{dbFetch}{SQLServerPreResult,numeric}(res, n = -1, ...)

\S4method{fetch}{SQLServerPreResult,numeric}(res, n = -1, ...)

\S4method{fetch}{SQLServerUpdateResult,numeric}(res, n = -1, ...)

\S4method{dbBind}{SQLServerPreResult}(res, params, ..., batch = FALSE)

\S4method{dbFetch}{SQLServerResult,numeric}(res, n = -1, ...)

\S4method{fetch}{SQLServerResult,numeric}(res, n = -1, block = 2048L, ...)

\S4method{dbColumnInfo}{SQLServerResult}(res, ...)

\S4method{dbClearResult}{SQLServerResult}(res, ...)

\S4method{dbGetStatement}{SQLServerResult}(res, ...)

\S4method{dbGetRowCount}{SQLServerResult}(res, ...)

\S4method{dbGetRowsAffected}{SQLServerResult}(res, ...)

\S4method{dbGetRowsAffected}{SQLServerUpdateResult}(res, ...)

\S4method{dbHasCompleted}{SQLServerResult}(res, ...)

\S4method{dbHasCompleted}{SQLServerUpdateResult}(res, ...)
}
\arguments{
\item{batch}{logical, indicates whether uploads (e.g., 'INSERT' or
'UPDATE') should be uploaded in batches, potentially much faster
than by individual rows (the default). (Setting it here enabled
binding the variables in batches, the actual batched upload is
done in \code{\link{dbSendStatement}} or
\code{\link{dbExecute}}.)}
}
\description{
The \code{SQLServerPreResult} class extends the \code{DBIResult} class, the
\code{SQLServerResult} class extends the \code{SQLServerPreResult} class,
while the \code{SQLServerUpdateResult} class extends the
\code{SQLServerResult} class. The \code{SQLServerUpdateResult} class is
created by a call to \code{dbSendStatement} as the JDBC API does not return a
ResultSet but rather an integer value for non-query statements. The
\code{dbGetRowsAffected} called on \code{SQLServerUpdateResult} returns the
value produced by the JDBC API. The \code{SQLServerPreResult} class wraps a
JDBC PreparedStatement that has yet to be executed and is necessary for
\code{dbBind} to function per the DBI spec (taking a DBIResult as an input
and returning another as output). This contrasts to the JDBC interface where
binding occurs on Statement classes and not on ResultSet classes.
}
\keyword{internal}
