% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rsnnsObjectFactory}
\alias{rsnns}
\alias{rsnnsObjectFactory}
\title{Object factory for generating rsnns objects}
\usage{
rsnnsObjectFactory(subclass, nInputs, maxit, initFunc, initFuncParams,
  learnFunc, learnFuncParams, updateFunc, updateFuncParams,
  shufflePatterns = TRUE, computeIterativeError = TRUE, pruneFunc = NULL,
  pruneFuncParams = NULL)
}
\arguments{
\item{subclass}{the subclass of rsnns to generate (vector of strings)}

\item{nInputs}{the number of inputs the network will have}

\item{maxit}{maximum of iterations to learn}

\item{initFunc}{the initialization function to use}

\item{initFuncParams}{the parameters for the initialization function}

\item{learnFunc}{the learning function to use}

\item{learnFuncParams}{the parameters for the learning function}

\item{updateFunc}{the update function to use}

\item{updateFuncParams}{the parameters for the update function}

\item{shufflePatterns}{should the patterns be shuffled?}

\item{computeIterativeError}{should the error be computed in every iteration?}

\item{pruneFunc}{the pruning function to use}

\item{pruneFuncParams}{the parameters for the pruning function. Unlike the other functions,
these have to be given in a named list. See the pruning demos for further explanation.}
}
\value{
a partly initialized \code{rsnns} object
}
\description{
The object factory generates an \code{rsnns} object and initializes its
member variables with the values given as parameters. Furthermore, it
generates an object of \code{\link{SnnsR-class}}. Later, this information is
to be used to train the network.
}
\details{
The typical procedure implemented in \code{rsnns} subclasses is the following:
\itemize{
\item generate the \code{rsnns} object with this object factory
\item generate the network according to the architecture needed
\item train the network (with \code{\link{train}})
}

In every \code{rsnns} object, the iterative error is the summed squared error
(SSE) of all patterns. If the SSE is computed on the test set, then it is
weighted to take care of the different amount of patterns in the sets.
}
\seealso{
\code{\link{mlp}}, \code{\link{dlvq}}, \code{\link{rbf}}, \code{\link{rbfDDA}}, \code{\link{elman}},
\code{\link{jordan}}, \code{\link{som}}, \code{\link{art1}}, \code{\link{art2}}, \code{\link{artmap}}, \code{\link{assoz}}
}

