/************************************************************************************

   This file is part of SnnsCLib, a fork of the kernel and parts of the gui of 
   the Stuttgart Neural Network Simulator (SNNS), version 4.3.

   The file's original version is part of SNNS 4.3. It's source code can be found at

   http://www.ra.cs.uni-tuebingen.de/SNNS/

   SNNS 4.3 is under the license LGPL v2. We note that source code files of SNNS 4.3 
   state as version "4.2". Base of this fork is SNNS 4.3 with a reverse-applied 
   python patch (see http://developer.berlios.de/projects/snns-dev/).

   SnnsCLib was developed in 2010 by Christoph Bergmeir under supervision of 
   José M. Benítez, both affiliated to DiCITS Lab, Sci2s group, DECSAI, 
   University of Granada

   Changes done to the original code were performed with the objective to
   port it from C to C++ and to encapsulate all code in one class named SnnsCLib.

   Changes in header files mainly include:
   * removed all static keywords
   * moved initializations of variables to the constructor of SnnsCLib

   Changes in cpp code files mainly include:
   * changed file ending from .c to .cpp
   * removed all SNNS internal includes and only include SnnsCLib   
   * static variables within functions were turned into member variables of SnnsCLib
   * function declarations were changed to method declarations, i.e. "SnnsCLib::.."
     was added
   * calls to the function table are now "C++-style", using the "this"-pointer

   License of SnnsCLib:
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

************************************************************************************/


/*****************************************************************************
  FILE           : $Source: /projects/higgs1/SNNS/CVS/SNNS/kernel/sources/sigmoid.tbl,v $
  SHORTNAME      : 
  SNNS VERSION   : 4.2

  PURPOSE        : SNNS-Kernel: Approximation Table for the Sigmoid Function
  NOTES          :

  AUTHOR         : Niels Mache 
  DATE           : 08.12.91 

  CHANGED BY     : Sven Doering
  RCS VERSION    : $Revision: 2.2 $
  LAST CHANGE    : $Date: 1997/11/12 17:37:07 $

    Copyright (c) 1990-1998  SNNS Group, IPVR, Univ. Stuttgart, Germany

******************************************************************************/

/*
No. of Approx.: 1000
Min. x: -12
Max. x: 12
Minus inf. border: -13
Plus inf. border : 13
Error in [-100,+100]: 7.42501e-05
*/

#define NO_OF_APPROX 1000
#define INDEX_OFFSET 500
#define MINUS_INFINITE_FUNC_VALUE 0.000000000
#define PLUS_INFINITE_FUNC_VALUE 1.000000000
#define SCALE_FACTOR 41.66666667
#define MIN_INDEX -41
#define MAX_INDEX 1041

//static float m[] = {
float m[] = {
3.8838503e-06f,  /*  minus infinite border  */
6.218459e-06f, 6.3695054e-06f, 6.5242207e-06f, 6.6826939e-06f, 6.8450165e-06f, 7.0112818e-06f, 7.1815856e-06f, 7.356026e-06f, 7.5347035e-06f, 7.7177211e-06f,
7.905184e-06f, 8.0972003e-06f, 8.2938806e-06f, 8.4953382e-06f, 8.7016891e-06f, 8.9130521e-06f, 9.129549e-06f, 9.3513045e-06f, 9.5784463e-06f, 9.8111053e-06f,
1.0049415e-05f, 1.0293514e-05f, 1.0543541e-05f, 1.0799642e-05f, 1.1061963e-05f, 1.1330655e-05f, 1.1605874e-05f, 1.1887778e-05f, 1.2176528e-05f, 1.2472293e-05f,
1.2775241e-05f, 1.3085548e-05f, 1.3403391e-05f, 1.3728955e-05f, 1.4062426e-05f, 1.4403997e-05f, 1.4753864e-05f, 1.511223e-05f, 1.5479299e-05f, 1.5855284e-05f,
1.6240402e-05f, 1.6634873e-05f, 1.7038926e-05f, 1.7452792e-05f, 1.7876711e-05f, 1.8310926e-05f, 1.8755688e-05f, 1.9211252e-05f, 1.9677881e-05f, 2.0155843e-05f,
2.0645415e-05f, 2.1146878e-05f, 2.166052e-05f, 2.2186637e-05f, 2.2725533e-05f, 2.3277518e-05f, 2.3842909e-05f, 2.4422033e-05f, 2.5015222e-05f, 2.5622819e-05f,
2.6245172e-05f, 2.6882642e-05f, 2.7535594e-05f, 2.8204404e-05f, 2.8889458e-05f, 2.9591151e-05f, 3.0309886e-05f, 3.1046077e-05f, 3.1800148e-05f, 3.2572534e-05f,
3.3363678e-05f, 3.4174037e-05f, 3.5004077e-05f, 3.5854276e-05f, 3.6725124e-05f, 3.7617122e-05f, 3.8530783e-05f, 3.9466634e-05f, 4.0425214e-05f, 4.1407074e-05f,
4.241278e-05f, 4.344291e-05f, 4.4498058e-05f, 4.5578832e-05f, 4.6685852e-05f, 4.7819758e-05f, 4.8981202e-05f, 5.0170851e-05f, 5.1389392e-05f, 5.2637525e-05f,
5.3915969e-05f, 5.5225461e-05f, 5.6566753e-05f, 5.7940618e-05f, 5.9347847e-05f, 6.078925e-05f, 6.2265656e-05f, 6.3777916e-05f, 6.5326899e-05f, 6.6913498e-05f,
6.8538625e-05f, 7.0203216e-05f, 7.190823e-05f, 7.3654646e-05f, 7.5443471e-05f, 7.7275734e-05f, 7.9152488e-05f, 8.1074816e-05f, 8.3043822e-05f, 8.5060639e-05f,
8.7126429e-05f, 8.924238e-05f, 9.140971e-05f, 9.3629665e-05f, 9.5903523e-05f, 9.8232592e-05f, 0.00010061821f, 0.00010306176f, 0.00010556463f, 0.00010812828f,
0.00011075416f, 0.00011344381f, 0.00011619875f, 0.00011902058f, 0.00012191093f, 0.00012487144f, 0.00012790383f, 0.00013100984f, 0.00013419126f, 0.00013744991f,
0.00014078768f, 0.00014420647f, 0.00014770825f, 0.00015129505f, 0.00015496891f, 0.00015873196f, 0.00016258636f, 0.00016653432f, 0.00017057811f, 0.00017472006f,
0.00017896254f, 0.000183308f, 0.00018775894f, 0.00019231791f, 0.00019698753f, 0.00020177049f, 0.00020666954f, 0.00021168748f, 0.0002168272f, 0.00022209166f,
0.00022748389f, 0.00023300697f, 0.00023866408f, 0.00024445847f, 0.00025039347f, 0.00025647248f, 0.00026269901f, 0.00026907662f, 0.00027560897f, 0.00028229982f,
0.000289153f, 0.00029617246f, 0.00030336222f, 0.0003107264f, 0.00031826924f, 0.00032599506f, 0.00033390829f, 0.00034201348f, 0.00035031527f, 0.00035881843f,
0.00036752784f, 0.00037644848f, 0.00038558548f, 0.00039494407f, 0.00040452962f, 0.00041434763f, 0.00042440372f, 0.00043470365f, 0.00044525334f, 0.00045605881f,
0.00046712627f, 0.00047846205f, 0.00049007265f, 0.00050196471f, 0.00051414505f, 0.00052662064f, 0.00053939861f, 0.00055248629f, 0.00056589116f, 0.00057962089f,
0.00059368334f, 0.00060808654f, 0.00062283875f, 0.00063794838f, 0.00065342409f, 0.00066927471f, 0.0006855093f, 0.00070213714f, 0.00071916772f, 0.00073661078f,
0.00075447627f, 0.00077277439f, 0.00079151558f, 0.00081071055f, 0.00083037023f, 0.00085050585f, 0.00087112888f, 0.00089225108f, 0.00091388449f, 0.00093604144f,
0.00095873454f, 0.00098197673f, 0.0010057812f, 0.0010301616f, 0.0010551317f, 0.0010807057f, 0.0011068982f, 0.0011337241f, 0.0011611986f, 0.0011893373f,
0.0012181562f, 0.0012476716f, 0.0012779004f, 0.0013088597f, 0.0013405669f, 0.0013730402f, 0.0014062978f, 0.0014403587f, 0.0014752421f, 0.0015109677f,
0.0015475558f, 0.0015850271f, 0.0016234027f, 0.0016627043f, 0.0017029541f, 0.0017441749f, 0.0017863898f, 0.0018296227f, 0.0018738979f, 0.0019192405f,
0.0019656758f, 0.00201323f, 0.0020619299f, 0.0021118029f, 0.0021628768f, 0.0022151805f, 0.0022687433f, 0.0023235951f, 0.0023797666f, 0.0024372895f,
0.0024961957f, 0.0025565182f, 0.0026182908f, 0.002681548f, 0.0027463248f, 0.0028126576f, 0.0028805832f, 0.0029501394f, 0.0030213649f, 0.0030942992f,
0.0031689828f, 0.0032454572f, 0.0033237645f, 0.0034039483f, 0.0034860528f, 0.0035701233f, 0.0036562063f, 0.0037443491f, 0.0038346003f, 0.0039270096f,
0.0040216275f, 0.0041185061f, 0.0042176985f, 0.0043192589f, 0.0044232428f, 0.0045297069f, 0.0046387094f, 0.0047503095f, 0.0048645679f, 0.0049815467f,
0.0051013091f, 0.0052239201f, 0.0053494459f, 0.0054779542f, 0.0056095142f, 0.0057441966f, 0.0058820738f, 0.0060232196f, 0.0061677096f, 0.0063156208f,
0.0064670321f, 0.006622024f, 0.0067806788f, 0.0069430805f, 0.007109315f, 0.0072794699f, 0.0074536348f, 0.0076319011f, 0.0078143622f, 0.0080011136f,
0.0081922525f, 0.0083878784f, 0.0085880927f, 0.008792999f, 0.009002703f, 0.0092173127f, 0.0094369381f, 0.0096616915f, 0.0098916877f, 0.010127044f,
0.010367878f, 0.010614314f, 0.010866474f, 0.011124485f, 0.011388476f, 0.011658579f, 0.011934928f, 0.012217659f, 0.012506912f, 0.012802829f,
0.013105554f, 0.013415234f, 0.013732019f, 0.014056063f, 0.01438752f, 0.01472655f, 0.015073312f, 0.015427972f, 0.015790696f, 0.016161654f,
0.016541018f, 0.016928965f, 0.017325672f, 0.017731322f, 0.018146099f, 0.01857019f, 0.019003786f, 0.01944708f, 0.019900269f, 0.020363552f,
0.020837132f, 0.021321213f, 0.021816004f, 0.022321717f, 0.022838565f, 0.023366766f, 0.023906539f, 0.024458107f, 0.025021696f, 0.025597534f,
0.026185852f, 0.026786883f, 0.027400863f, 0.028028032f, 0.02866863f, 0.029322901f, 0.02999109f, 0.030673446f, 0.031370218f, 0.032081658f,
0.03280802f, 0.033549559f, 0.034306534f, 0.035079201f, 0.035867821f, 0.036672654f, 0.037493963f, 0.03833201f, 0.039187058f, 0.04005937f,
0.04094921f, 0.041856842f, 0.042782528f, 0.04372653f, 0.044689111f, 0.045670531f, 0.046671047f, 0.047690918f, 0.048730398f, 0.049789739f,
0.050869192f, 0.051969001f, 0.053089409f, 0.054230656f, 0.055392975f, 0.056576595f, 0.05778174f, 0.059008627f, 0.060257469f, 0.061528469f,
0.062821825f, 0.064137726f, 0.065476352f, 0.066837874f, 0.068222455f, 0.069630246f, 0.071061385f, 0.072516003f, 0.073994215f, 0.075496123f,
0.077021817f, 0.078571372f, 0.080144846f, 0.081742283f, 0.083363708f, 0.085009132f, 0.086678544f, 0.088371914f, 0.090089194f, 0.091830314f,
0.093595181f, 0.095383681f, 0.097195677f, 0.099031006f, 0.10088948f, 0.10277088f, 0.10467498f, 0.1066015f, 0.10855014f, 0.11052059f,
0.11251247f, 0.11452541f, 0.11655898f, 0.11861273f, 0.12068618f, 0.1227788f, 0.12489004f, 0.12701931f, 0.12916597f, 0.13132938f,
0.13350881f, 0.13570354f, 0.13791279f, 0.14013574f, 0.14237153f, 0.14461927f, 0.14687803f, 0.14914683f, 0.15142465f, 0.15371044f,
0.15600312f, 0.15830153f, 0.16060452f, 0.16291087f, 0.16521933f, 0.16752861f, 0.16983738f, 0.1721443f, 0.17444794f, 0.17674689f,
0.17903968f, 0.18132482f, 0.18360076f, 0.18586595f, 0.1881188f, 0.19035771f, 0.19258102f, 0.19478709f, 0.19697422f, 0.19914072f,
0.20128486f, 0.20340492f, 0.20549916f, 0.20756581f, 0.20960312f, 0.21160933f, 0.21358267f, 0.21552138f, 0.2174237f, 0.21928788f,
0.22111218f, 0.22289487f, 0.22463425f, 0.22632863f, 0.22797635f, 0.22957576f, 0.23112526f, 0.23262328f, 0.23406827f, 0.23545874f,
0.23679324f, 0.23807035f, 0.23928871f, 0.24044703f, 0.24154403f, 0.24257854f, 0.24354941f, 0.24445557f, 0.24529602f, 0.24606982f,
0.2467761f, 0.24741406f, 0.24798298f, 0.24848222f, 0.24891121f, 0.24926945f, 0.24955654f, 0.24977214f, 0.24991602f, 0.249988f,
0.249988f, 0.24991602f, 0.24977214f, 0.24955654f, 0.24926945f, 0.24891121f, 0.24848222f, 0.24798298f, 0.24741406f, 0.2467761f,
0.24606982f, 0.24529602f, 0.24445557f, 0.24354941f, 0.24257854f, 0.24154403f, 0.24044703f, 0.23928871f, 0.23807035f, 0.23679324f,
0.23545874f, 0.23406827f, 0.23262328f, 0.23112526f, 0.22957576f, 0.22797635f, 0.22632863f, 0.22463425f, 0.22289487f, 0.22111218f,
0.21928788f, 0.2174237f, 0.21552138f, 0.21358267f, 0.21160933f, 0.20960312f, 0.20756581f, 0.20549916f, 0.20340492f, 0.20128486f,
0.19914072f, 0.19697422f, 0.19478709f, 0.19258102f, 0.19035771f, 0.1881188f, 0.18586595f, 0.18360076f, 0.18132482f, 0.17903968f,
0.17674689f, 0.17444794f, 0.1721443f, 0.16983738f, 0.16752861f, 0.16521933f, 0.16291087f, 0.16060452f, 0.15830153f, 0.15600312f,
0.15371044f, 0.15142465f, 0.14914683f, 0.14687803f, 0.14461927f, 0.14237153f, 0.14013574f, 0.13791279f, 0.13570354f, 0.13350881f,
0.13132938f, 0.12916597f, 0.12701931f, 0.12489004f, 0.1227788f, 0.12068618f, 0.11861273f, 0.11655898f, 0.11452541f, 0.11251247f,
0.11052059f, 0.10855014f, 0.1066015f, 0.10467498f, 0.10277088f, 0.10088948f, 0.099031006f, 0.097195677f, 0.095383681f, 0.093595181f,
0.091830314f, 0.090089194f, 0.088371914f, 0.086678544f, 0.085009132f, 0.083363708f, 0.081742283f, 0.080144846f, 0.078571372f, 0.077021817f,
0.075496123f, 0.073994215f, 0.072516003f, 0.071061385f, 0.069630246f, 0.068222455f, 0.066837874f, 0.065476352f, 0.064137726f, 0.062821825f,
0.061528469f, 0.060257469f, 0.059008627f, 0.05778174f, 0.056576595f, 0.055392975f, 0.054230656f, 0.053089409f, 0.051969001f, 0.050869192f,
0.049789739f, 0.048730398f, 0.047690918f, 0.046671047f, 0.045670531f, 0.044689111f, 0.04372653f, 0.042782528f, 0.041856842f, 0.04094921f,
0.04005937f, 0.039187058f, 0.03833201f, 0.037493963f, 0.036672654f, 0.035867821f, 0.035079201f, 0.034306534f, 0.033549559f, 0.03280802f,
0.032081658f, 0.031370218f, 0.030673446f, 0.02999109f, 0.029322901f, 0.02866863f, 0.028028032f, 0.027400863f, 0.026786883f, 0.026185852f,
0.025597534f, 0.025021696f, 0.024458107f, 0.023906539f, 0.023366766f, 0.022838565f, 0.022321717f, 0.021816004f, 0.021321213f, 0.020837132f,
0.020363552f, 0.019900269f, 0.01944708f, 0.019003786f, 0.01857019f, 0.018146099f, 0.017731322f, 0.017325672f, 0.016928965f, 0.016541018f,
0.016161654f, 0.015790696f, 0.015427972f, 0.015073312f, 0.01472655f, 0.01438752f, 0.014056063f, 0.013732019f, 0.013415234f, 0.013105554f,
0.012802829f, 0.012506912f, 0.012217659f, 0.011934928f, 0.011658579f, 0.011388476f, 0.011124485f, 0.010866474f, 0.010614314f, 0.010367878f,
0.010127044f, 0.0098916877f, 0.0096616915f, 0.0094369381f, 0.0092173127f, 0.009002703f, 0.008792999f, 0.0085880927f, 0.0083878784f, 0.0081922525f,
0.0080011136f, 0.0078143622f, 0.0076319011f, 0.0074536348f, 0.0072794699f, 0.007109315f, 0.0069430805f, 0.0067806788f, 0.006622024f, 0.0064670321f,
0.0063156208f, 0.0061677096f, 0.0060232196f, 0.0058820738f, 0.0057441966f, 0.0056095142f, 0.0054779542f, 0.0053494459f, 0.0052239201f, 0.0051013091f,
0.0049815467f, 0.0048645679f, 0.0047503095f, 0.0046387094f, 0.0045297069f, 0.0044232428f, 0.0043192589f, 0.0042176985f, 0.0041185061f, 0.0040216275f,
0.0039270096f, 0.0038346003f, 0.0037443491f, 0.0036562063f, 0.0035701233f, 0.0034860528f, 0.0034039483f, 0.0033237645f, 0.0032454572f, 0.0031689828f,
0.0030942992f, 0.0030213649f, 0.0029501394f, 0.0028805832f, 0.0028126576f, 0.0027463248f, 0.002681548f, 0.0026182908f, 0.0025565182f, 0.0024961957f,
0.0024372895f, 0.0023797666f, 0.0023235951f, 0.0022687433f, 0.0022151805f, 0.0021628768f, 0.0021118029f, 0.0020619299f, 0.00201323f, 0.0019656758f,
0.0019192405f, 0.0018738979f, 0.0018296227f, 0.0017863898f, 0.0017441749f, 0.0017029541f, 0.0016627043f, 0.0016234027f, 0.0015850271f, 0.0015475558f,
0.0015109677f, 0.0014752421f, 0.0014403587f, 0.0014062978f, 0.0013730402f, 0.0013405669f, 0.0013088597f, 0.0012779004f, 0.0012476716f, 0.0012181562f,
0.0011893373f, 0.0011611986f, 0.0011337241f, 0.0011068982f, 0.0010807057f, 0.0010551317f, 0.0010301616f, 0.0010057812f, 0.00098197673f, 0.00095873454f,
0.00093604144f, 0.00091388449f, 0.00089225108f, 0.00087112888f, 0.00085050585f, 0.00083037023f, 0.00081071055f, 0.00079151558f, 0.00077277439f, 0.00075447627f,
0.00073661078f, 0.00071916772f, 0.00070213714f, 0.0006855093f, 0.00066927471f, 0.00065342409f, 0.00063794838f, 0.00062283875f, 0.00060808654f, 0.00059368334f,
0.00057962089f, 0.00056589116f, 0.00055248629f, 0.00053939861f, 0.00052662064f, 0.00051414505f, 0.00050196471f, 0.00049007265f, 0.00047846205f, 0.00046712627f,
0.00045605881f, 0.00044525334f, 0.00043470365f, 0.00042440372f, 0.00041434763f, 0.00040452962f, 0.00039494407f, 0.00038558548f, 0.00037644848f, 0.00036752784f,
0.00035881843f, 0.00035031527f, 0.00034201348f, 0.00033390829f, 0.00032599506f, 0.00031826924f, 0.0003107264f, 0.00030336222f, 0.00029617246f, 0.000289153f,
0.00028229982f, 0.00027560897f, 0.00026907662f, 0.00026269901f, 0.00025647248f, 0.00025039347f, 0.00024445847f, 0.00023866408f, 0.00023300697f, 0.00022748389f,
0.00022209166f, 0.0002168272f, 0.00021168748f, 0.00020666954f, 0.00020177049f, 0.00019698753f, 0.00019231791f, 0.00018775894f, 0.000183308f, 0.00017896254f,
0.00017472006f, 0.00017057811f, 0.00016653432f, 0.00016258636f, 0.00015873196f, 0.00015496891f, 0.00015129505f, 0.00014770825f, 0.00014420647f, 0.00014078768f,
0.00013744991f, 0.00013419126f, 0.00013100984f, 0.00012790383f, 0.00012487144f, 0.00012191093f, 0.00011902058f, 0.00011619875f, 0.00011344381f, 0.00011075416f,
0.00010812828f, 0.00010556463f, 0.00010306176f, 0.00010061821f, 9.8232592e-05f, 9.5903523e-05f, 9.3629665e-05f, 9.140971e-05f, 8.924238e-05f, 8.7126429e-05f,
8.5060639e-05f, 8.3043822e-05f, 8.1074816e-05f, 7.9152488e-05f, 7.7275734e-05f, 7.5443471e-05f, 7.3654646e-05f, 7.190823e-05f, 7.0203216e-05f, 6.8538625e-05f,
6.6913498e-05f, 6.5326899e-05f, 6.3777916e-05f, 6.2265656e-05f, 6.078925e-05f, 5.9347847e-05f, 5.7940618e-05f, 5.6566753e-05f, 5.5225461e-05f, 5.3915969e-05f,
5.2637525e-05f, 5.1389392e-05f, 5.0170851e-05f, 4.8981202e-05f, 4.7819758e-05f, 4.6685852e-05f, 4.5578832e-05f, 4.4498058e-05f, 4.344291e-05f, 4.241278e-05f,
4.1407074e-05f, 4.0425214e-05f, 3.9466634e-05f, 3.8530783e-05f, 3.7617122e-05f, 3.6725124e-05f, 3.5854276e-05f, 3.5004077e-05f, 3.4174037e-05f, 3.3363678e-05f,
3.2572534e-05f, 3.1800148e-05f, 3.1046077e-05f, 3.0309886e-05f, 2.9591151e-05f, 2.8889458e-05f, 2.8204404e-05f, 2.7535594e-05f, 2.6882642e-05f, 2.6245172e-05f,
2.5622819e-05f, 2.5015222e-05f, 2.4422033e-05f, 2.3842909e-05f, 2.3277518e-05f, 2.2725533e-05f, 2.2186637e-05f, 2.166052e-05f, 2.1146878e-05f, 2.0645415e-05f,
2.0155843e-05f, 1.9677881e-05f, 1.9211252e-05f, 1.8755688e-05f, 1.8310926e-05f, 1.7876711e-05f, 1.7452792e-05f, 1.7038926e-05f, 1.6634873e-05f, 1.6240402e-05f,
1.5855284e-05f, 1.5479299e-05f, 1.511223e-05f, 1.4753864e-05f, 1.4403997e-05f, 1.4062426e-05f, 1.3728955e-05f, 1.3403391e-05f, 1.3085548e-05f, 1.2775241e-05f,
1.2472293e-05f, 1.2176528e-05f, 1.1887778e-05f, 1.1605874e-05f, 1.1330655e-05f, 1.1061963e-05f, 1.0799642e-05f, 1.0543541e-05f, 1.0293514e-05f, 1.0049415e-05f,
9.8111053e-06f, 9.5784463e-06f, 9.3513045e-06f, 9.129549e-06f, 8.9130521e-06f, 8.7016891e-06f, 8.4953382e-06f, 8.2938806e-06f, 8.0972003e-06f, 7.905184e-06f,
7.7177211e-06f, 7.5347035e-06f, 7.356026e-06f, 7.1815856e-06f, 7.0112818e-06f, 6.8450165e-06f, 6.6826939e-06f, 6.5242207e-06f, 6.3695054e-06f, 
3.8838503e-06f  };  /*  plus infinite border  */

//static float b[] = {
float b[] = {
5.2750378e-05f,  /*  minus infinite border  */
8.0765682e-05f, 8.2574614e-05f, 8.4423771e-05f, 8.631404e-05f, 8.8246328e-05f, 9.022156e-05f, 9.2240682e-05f, 9.4304661e-05f, 9.6414485e-05f, 9.8571163e-05f,
0.00010077573f, 0.00010302923f, 0.00010533275f, 0.00010768739f, 0.00011009426f, 0.00011255453f, 0.00011506936f, 0.00011763995f, 0.00012026752f, 0.00012295334f,
0.00012569867f, 0.00012850483f, 0.00013137314f, 0.00013430498f, 0.00013730173f, 0.00014036483f, 0.00014349572f, 0.00014669589f, 0.00014996686f, 0.00015331018f,
0.00015672743f, 0.00016022024f, 0.00016379026f, 0.00016743918f, 0.00017116872f, 0.00017498066f, 0.00017887678f, 0.00018285893f, 0.000186929f, 0.0001910889f,
0.0001953406f, 0.00019968609f, 0.00020412744f, 0.00020866673f, 0.00021330609f, 0.00021804772f, 0.00022289384f, 0.00022784674f, 0.00023290873f, 0.0002380822f,
0.00024336957f, 0.00024877333f, 0.00025429601f, 0.0002599402f, 0.00026570854f, 0.00027160374f, 0.00027762855f, 0.00028378579f, 0.00029007834f, 0.00029650914f,
0.0003030812f, 0.00030979758f, 0.00031666141f, 0.00032367589f, 0.0003308443f, 0.00033816997f, 0.00034565631f, 0.00035330681f, 0.00036112502f, 0.00036911458f,
0.00037727918f, 0.00038562264f, 0.00039414881f, 0.00040286165f, 0.0004117652f, 0.00042086358f, 0.000430161f, 0.00043966176f, 0.00044937025f, 0.00045929097f,
0.00046942848f, 0.00047978747f, 0.00049037272f, 0.0005011891f, 0.00051224159f, 0.0005235353f, 0.0005350754f, 0.0005468672f, 0.00055891613f, 0.00057122772f,
0.00058380761f, 0.00059666158f, 0.00060979551f, 0.00062321543f, 0.00063692747f, 0.0006509379f, 0.00066525314f, 0.00067987971f, 0.0006948243f, 0.00071009373f,
0.00072569495f, 0.00074163508f, 0.00075792136f, 0.00077456122f, 0.00079156221f, 0.00080893206f, 0.00082667866f, 0.00084481005f, 0.00086333445f, 0.00088226027f,
0.00090159606f, 0.00092135058f, 0.00094153275f, 0.0009621517f, 0.00098321672f, 0.0010047373f, 0.0010267232f, 0.0010491842f, 0.0010721306f, 0.0010955726f,
0.0011195207f, 0.0011439857f, 0.0011689785f, 0.0011945105f, 0.0012205929f, 0.0012472376f, 0.0012744563f, 0.0013022613f, 0.001330665f, 0.00135968f,
0.0013893194f, 0.0014195962f, 0.001450524f, 0.0014821164f, 0.0015143877f, 0.001547352f, 0.001581024f, 0.0016154186f, 0.001650551f, 0.0016864369f,
0.001723092f, 0.0017605325f, 0.0017987749f, 0.0018378362f, 0.0018777334f, 0.0019184842f, 0.0019601065f, 0.0020026185f, 0.0020460389f, 0.0020903868f,
0.0021356814f, 0.0021819427f, 0.0022291909f, 0.0022774466f, 0.0023267309f, 0.0023770651f, 0.0024284713f, 0.0024809718f, 0.0025345893f, 0.0025893472f,
0.0026452692f, 0.0027023795f, 0.0027607028f, 0.0028202643f, 0.0028810898f, 0.0029432054f, 0.0030066378f, 0.0030714145f, 0.0031375632f, 0.0032051123f,
0.0032740908f, 0.0033445282f, 0.0034164546f, 0.0034899009f, 0.0035648982f, 0.0036414787f, 0.0037196748f, 0.0037995199f, 0.0038810479f, 0.0039642932f,
0.0040492913f, 0.0041360781f, 0.0042246902f, 0.004315165f, 0.0044075406f, 0.0045018561f, 0.0045981509f, 0.0046964655f, 0.0047968412f, 0.0048993199f,
0.0050039445f, 0.0051107587f, 0.005219807f, 0.0053311348f, 0.0054447884f, 0.0055608149f, 0.0056792625f, 0.0058001801f, 0.0059236178f, 0.0060496264f,
0.006178258f, 0.0063095653f, 0.0064436023f, 0.006580424f, 0.0067200864f, 0.0068626466f, 0.0070081627f, 0.007156694f, 0.007308301f, 0.0074630451f,
0.0076209891f, 0.0077821969f, 0.0079467335f, 0.0081146654f, 0.0082860601f, 0.0084609865f, 0.0086395146f, 0.0088217159f, 0.0090076632f, 0.0091974307f,
0.0093910937f, 0.0095887293f, 0.0097904158f, 0.0099962328f, 0.010206262f, 0.010420585f, 0.010639287f, 0.010862454f, 0.011090173f, 0.011322532f,
0.011559624f, 0.011801538f, 0.01204837f, 0.012300215f, 0.01255717f, 0.012819333f, 0.013086807f, 0.013359693f, 0.013638096f, 0.013922121f,
0.014211878f, 0.014507475f, 0.014809025f, 0.015116641f, 0.01543044f, 0.015750538f, 0.016077057f, 0.016410117f, 0.016749842f, 0.01709636f,
0.017449797f, 0.017810285f, 0.018177955f, 0.018552944f, 0.018935386f, 0.019325423f, 0.019723195f, 0.020128847f, 0.020542525f, 0.020964377f,
0.021394554f, 0.021833211f, 0.022280503f, 0.022736588f, 0.023201628f, 0.023675786f, 0.024159228f, 0.024652122f, 0.025154641f, 0.025666958f,
0.026189249f, 0.026721694f, 0.027264474f, 0.027817776f, 0.028381784f, 0.028956691f, 0.029542688f, 0.030139972f, 0.03074874f, 0.031369196f,
0.032001542f, 0.032645985f, 0.033302736f, 0.033972007f, 0.034654014f, 0.035348975f, 0.036057112f, 0.03677865f, 0.037513815f, 0.038262837f,
0.03902595f, 0.03980339f, 0.040595394f, 0.041402206f, 0.042224069f, 0.043061231f, 0.043913943f, 0.044782456f, 0.045667028f, 0.046567916f,
0.047485383f, 0.048419692f, 0.049371111f, 0.050339908f, 0.051326356f, 0.052330729f, 0.053353304f, 0.054394362f, 0.055454185f, 0.056533056f,
0.057631262f, 0.058749093f, 0.059886839f, 0.061044793f, 0.06222325f, 0.063422508f, 0.064642864f, 0.06588462f, 0.067148077f, 0.068433539f,
0.06974131f, 0.071071696f, 0.072425004f, 0.073801541f, 0.075201617f, 0.07662554f, 0.078073621f, 0.079546168f, 0.081043493f, 0.082565904f,
0.08411371f, 0.085687222f, 0.087286747f, 0.088912592f, 0.090565062f, 0.092244463f, 0.093951096f, 0.095685263f, 0.097447262f, 0.099237387f,
0.10105593f, 0.10290319f, 0.10477944f, 0.10668496f, 0.10862004f, 0.11058495f, 0.11257995f, 0.11460531f, 0.11666128f, 0.11874812f,
0.12086606f, 0.12301535f, 0.1251962f, 0.12740886f, 0.12965351f, 0.13193037f, 0.13423964f, 0.13658148f, 0.13895608f, 0.14136359f,
0.14380417f, 0.14627795f, 0.14878504f, 0.15132557f, 0.15389963f, 0.15650729f, 0.15914862f, 0.16182366f, 0.16453246f, 0.16727501f,
0.17005131f, 0.17286134f, 0.17570504f, 0.17858236f, 0.18149321f, 0.18443746f, 0.187415f, 0.19042566f, 0.19346926f, 0.19654559f,
0.19965441f, 0.20279546f, 0.20596846f, 0.20917308f, 0.21240898f, 0.21567577f, 0.21897304f, 0.22230036f, 0.22565725f, 0.22904319f,
0.23245765f, 0.23590005f, 0.23936977f, 0.24286616f, 0.24638853f, 0.24993616f, 0.25350829f, 0.2571041f, 0.26072276f, 0.26436339f,
0.26802506f, 0.2717068f, 0.27540761f, 0.27912644f, 0.28286221f, 0.28661377f, 0.29037997f, 0.29415957f, 0.29795132f, 0.30175393f,
0.30556604f, 0.30938628f, 0.31321321f, 0.31704538f, 0.32088127f, 0.32471934f, 0.32855799f, 0.33239562f, 0.33623055f, 0.34006109f,
0.34388551f, 0.34770204f, 0.35150889f, 0.35530422f, 0.35908619f, 0.36285291f, 0.36660247f, 0.37033294f, 0.37404238f, 0.37772882f,
0.38139027f, 0.38502475f, 0.38863024f, 0.39220474f, 0.39574624f, 0.39925272f, 0.40272217f, 0.40615259f, 0.40954199f, 0.41288839f,
0.41618984f, 0.4194444f, 0.42265015f, 0.42580524f, 0.42890781f, 0.43195606f, 0.43494823f, 0.43788262f, 0.44075757f, 0.44357149f,
0.44632284f, 0.44901015f, 0.45163204f, 0.45418717f, 0.45667432f, 0.45909234f, 0.46144016f, 0.46371682f, 0.46592145f, 0.46805328f,
0.47011166f, 0.47209604f, 0.47400598f, 0.47584117f, 0.47760141f, 0.47928662f, 0.48089687f, 0.48243232f, 0.4838933f, 0.48528025f,
0.48659375f, 0.4878345f, 0.48900337f, 0.49010133f, 0.4911295f, 0.49208915f, 0.49298166f, 0.49380857f, 0.49457152f, 0.49527232f,
0.49591288f, 0.49649524f, 0.49702158f, 0.49749417f, 0.49791542f, 0.49828784f, 0.49861405f, 0.49889678f, 0.49913882f, 0.49934311f,
0.49951261f, 0.49965041f, 0.49975965f, 0.49984352f, 0.49990529f, 0.49994828f, 0.49997584f, 0.49999137f, 0.49999827f, 0.5f,
0.5f, 0.50000173f, 0.50000863f, 0.50002416f, 0.50005172f, 0.50009471f, 0.50015648f, 0.50024035f, 0.50034959f, 0.50048739f,
0.50065689f, 0.50086118f, 0.50110322f, 0.50138595f, 0.50171216f, 0.50208458f, 0.50250583f, 0.50297842f, 0.50350476f, 0.50408712f,
0.50472768f, 0.50542848f, 0.50619143f, 0.50701834f, 0.50791085f, 0.5088705f, 0.50989867f, 0.51099663f, 0.51216549f, 0.51340625f,
0.51471974f, 0.51610669f, 0.51756768f, 0.51910313f, 0.52071338f, 0.52239859f, 0.52415883f, 0.52599402f, 0.52790396f, 0.52988834f,
0.53194672f, 0.53407855f, 0.53628318f, 0.53855984f, 0.54090766f, 0.54332568f, 0.54581283f, 0.54836796f, 0.55098985f, 0.55367716f,
0.55642851f, 0.55924243f, 0.56211738f, 0.56505177f, 0.56804394f, 0.57109219f, 0.57419476f, 0.57734984f, 0.5805556f, 0.58381016f,
0.58711161f, 0.59045801f, 0.59384741f, 0.59727783f, 0.60074728f, 0.60425376f, 0.60779526f, 0.61136976f, 0.61497525f, 0.61860972f,
0.62227118f, 0.62595762f, 0.62966706f, 0.63339753f, 0.63714709f, 0.64091381f, 0.64469578f, 0.64849111f, 0.65229796f, 0.65611449f,
0.65993891f, 0.66376945f, 0.66760438f, 0.671442f, 0.67528066f, 0.67911873f, 0.68295462f, 0.68678678f, 0.69061372f, 0.69443396f,
0.69824607f, 0.70204868f, 0.70584043f, 0.70962003f, 0.71338622f, 0.71713779f, 0.72087356f, 0.72459239f, 0.7282932f, 0.73197494f,
0.73563661f, 0.73927723f, 0.7428959f, 0.74649171f, 0.75006384f, 0.75361147f, 0.75713384f, 0.76063023f, 0.76409995f, 0.76754235f,
0.7709568f, 0.77434275f, 0.77769964f, 0.78102696f, 0.78432423f, 0.78759102f, 0.79082692f, 0.79403154f, 0.79720454f, 0.80034559f,
0.80345441f, 0.80653074f, 0.80957434f, 0.812585f, 0.81556253f, 0.81850679f, 0.82141764f, 0.82429496f, 0.82713866f, 0.82994869f,
0.83272499f, 0.83546754f, 0.83817633f, 0.84085138f, 0.84349271f, 0.84610037f, 0.84867442f, 0.85121496f, 0.85372205f, 0.85619583f,
0.85863641f, 0.86104392f, 0.86341852f, 0.86576036f, 0.86806962f, 0.87034649f, 0.87259114f, 0.87480379f, 0.87698465f, 0.87913394f,
0.88125188f, 0.88333872f, 0.88539469f, 0.88742005f, 0.88941505f, 0.89137996f, 0.89331504f, 0.89522056f, 0.89709681f, 0.89894407f,
0.90076261f, 0.90255274f, 0.90431474f, 0.9060489f, 0.90775554f, 0.90943494f, 0.91108741f, 0.91271325f, 0.91431278f, 0.91588629f,
0.9174341f, 0.91895651f, 0.92045383f, 0.92192638f, 0.92337446f, 0.92479838f, 0.92619846f, 0.927575f, 0.9289283f, 0.93025869f,
0.93156646f, 0.93285192f, 0.93411538f, 0.93535714f, 0.93657749f, 0.93777675f, 0.93895521f, 0.94011316f, 0.94125091f, 0.94236874f,
0.94346694f, 0.94454582f, 0.94560564f, 0.9466467f, 0.94766927f, 0.94867364f, 0.94966009f, 0.95062889f, 0.95158031f, 0.95251462f,
0.95343208f, 0.95433297f, 0.95521754f, 0.95608606f, 0.95693877f, 0.95777593f, 0.95859779f, 0.9594046f, 0.96019661f, 0.96097405f,
0.96173716f, 0.96248618f, 0.96322135f, 0.96394289f, 0.96465102f, 0.96534599f, 0.96602799f, 0.96669726f, 0.96735402f, 0.96799846f,
0.9686308f, 0.96925126f, 0.96986003f, 0.97045731f, 0.97104331f, 0.97161822f, 0.97218222f, 0.97273552f, 0.97327831f, 0.97381075f,
0.97433304f, 0.97484536f, 0.97534788f, 0.97584077f, 0.97632421f, 0.97679837f, 0.97726341f, 0.9777195f, 0.97816679f, 0.97860544f,
0.97903562f, 0.97945748f, 0.97987115f, 0.9802768f, 0.98067458f, 0.98106461f, 0.98144706f, 0.98182204f, 0.98218972f, 0.9825502f,
0.98290364f, 0.98325016f, 0.98358988f, 0.98392294f, 0.98424946f, 0.98456956f, 0.98488336f, 0.98519098f, 0.98549252f, 0.98578812f,
0.98607788f, 0.9863619f, 0.98664031f, 0.98691319f, 0.98718067f, 0.98744283f, 0.98769978f, 0.98795163f, 0.98819846f, 0.98844038f,
0.98867747f, 0.98890983f, 0.98913754f, 0.98936071f, 0.98957941f, 0.98979374f, 0.99000377f, 0.99020958f, 0.99041127f, 0.99060891f,
0.99080257f, 0.99099234f, 0.99117828f, 0.99136048f, 0.99153901f, 0.99171394f, 0.99188533f, 0.99205327f, 0.9922178f, 0.99237901f,
0.99253695f, 0.9926917f, 0.9928433f, 0.99299184f, 0.99313735f, 0.99327991f, 0.99341958f, 0.9935564f, 0.99369043f, 0.99382174f,
0.99395037f, 0.99407638f, 0.99419982f, 0.99432074f, 0.99443918f, 0.99455521f, 0.99466886f, 0.99478019f, 0.99488924f, 0.99499606f,
0.99510068f, 0.99520316f, 0.99530353f, 0.99540185f, 0.99549814f, 0.99559246f, 0.99568484f, 0.99577531f, 0.99586392f, 0.99595071f,
0.99603571f, 0.99611895f, 0.99620048f, 0.99628032f, 0.99635852f, 0.9964351f, 0.9965101f, 0.99658354f, 0.99665547f, 0.99672591f,
0.99679489f, 0.99686244f, 0.99692858f, 0.99699336f, 0.99705679f, 0.99711891f, 0.99717974f, 0.9972393f, 0.99729762f, 0.99735473f,
0.99741065f, 0.99746541f, 0.99751903f, 0.99757153f, 0.99762293f, 0.99767327f, 0.99772255f, 0.99777081f, 0.99781806f, 0.99786432f,
0.99790961f, 0.99795396f, 0.99799738f, 0.99803989f, 0.99808152f, 0.99812227f, 0.99816216f, 0.99820122f, 0.99823947f, 0.99827691f,
0.99831356f, 0.99834945f, 0.99838458f, 0.99841898f, 0.99845265f, 0.99848561f, 0.99851788f, 0.99854948f, 0.9985804f, 0.99861068f,
0.99864032f, 0.99866933f, 0.99869774f, 0.99872554f, 0.99875276f, 0.99877941f, 0.99880549f, 0.99883102f, 0.99885601f, 0.99888048f,
0.99890443f, 0.99892787f, 0.99895082f, 0.99897328f, 0.99899526f, 0.99901678f, 0.99903785f, 0.99905847f, 0.99907865f, 0.9990984f,
0.99911774f, 0.99913666f, 0.99915519f, 0.99917332f, 0.99919107f, 0.99920844f, 0.99922544f, 0.99924208f, 0.99925836f, 0.9992743f,
0.99928991f, 0.99930518f, 0.99932012f, 0.99933475f, 0.99934906f, 0.99936307f, 0.99937678f, 0.9993902f, 0.99940334f, 0.99941619f,
0.99942877f, 0.99944108f, 0.99945313f, 0.99946492f, 0.99947646f, 0.99948776f, 0.99949881f, 0.99950963f, 0.99952021f, 0.99953057f,
0.99954071f, 0.99955063f, 0.99956034f, 0.99956984f, 0.99957914f, 0.99958823f, 0.99959714f, 0.99960585f, 0.99961438f, 0.99962272f,
0.99963088f, 0.99963887f, 0.99964669f, 0.99965434f, 0.99966183f, 0.99966916f, 0.99967632f, 0.99968334f, 0.9996902f, 0.99969692f,
0.99970349f, 0.99970992f, 0.99971621f, 0.99972237f, 0.9997284f, 0.99973429f, 0.99974006f, 0.9997457f, 0.99975123f, 0.99975663f,
0.99976192f, 0.99976709f, 0.99977215f, 0.99977711f, 0.99978195f, 0.99978669f, 0.99979133f, 0.99979587f, 0.99980031f, 0.99980466f,
0.99980891f, 0.99981307f, 0.99981714f, 0.99982112f, 0.99982502f, 0.99982883f, 0.99983256f, 0.99983621f, 0.99983978f, 0.99984327f,
0.99984669f, 0.99985003f, 0.9998533f, 0.9998565f, 0.99985964f, 0.9998627f, 0.9998657f, 0.99986863f, 0.9998715f, 0.9998743f,
0.99987705f, 0.99987973f, 0.99988236f, 0.99988493f, 0.99988744f, 0.9998899f, 0.99989231f, 0.99989467f, 0.99989697f, 0.99989922f,
0.99990143f, 0.99990358f, 0.9999057f, 0.99990776f, 0.99990978f, 0.99991175f, 0.99991368f, 0.99991558f, 0.99991742f, 
0.99994725f  };  /*  plus infinite border  */
