% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SnnsRObjectFactory.R
\docType{class}
\name{SnnsR-class}
\alias{SnnsR-class}
\title{The main class of the package}
\description{
An S4 class that is the main class of RSNNS. Each instance of this class 
contains a pointer to a C++ object of type SnnsCLib, i.e. an instance 
of the SNNS kernel.
}
\details{
The only slot \code{variables} holds an environment with all member variables. 
Currently, there are two members (constructed by the object factory):
\describe{
\item{snnsCLibPointer}{A pointer to the corresponding C++ object}
\item{serialization}{a serialization of the C++ object, in SNNS .net format}
}
The member variables are not directly present as slots but wrapped in an environment
to allow for changing the serialization (by call by reference). 

An object of this class is used internally by all the models in the package. 
The object is always accessible by \code{model$snnsObject$...}

To make full use of the SNNS functionalities, you might want to use this class directly.
Always use the object factory \code{\link{SnnsRObjectFactory}} to construct an object, 
and the calling mechanism \code{\link{$}} to call functions. Through the calling mechanism,
many functions of SnnsCLib are present that are not documented here, but in the SNNS User 
Manual. So, if you choose to use the low-level interface, it is highly recommended to have
a look at the demos and at the SNNS User Manual.
}
\examples{
\dontrun{demo(encoderSnnsCLib)} 
\dontrun{demo(art1_lettersSnnsR)}
\dontrun{demo(art2_tetraSnnsR)} 
\dontrun{demo(artmap_lettersSnnsR)} 
\dontrun{demo(eight_elmanSnnsR)}
\dontrun{demo(rbf_irisSnnsR)}
\dontrun{demo(rbf_sinSnnsR)}
\dontrun{demo(rbfDDA_spiralsSnnsR)}
\dontrun{demo(som_cubeSnnsR)}


#This is the demo eight_elmanSnnsR
#Here, we train an Elman network
#and save a trained and an untrained version
#to disk, as well as the used training data

basePath <- ("./")

data(snnsData)

inputs <- snnsData$eight_016.pat[,inputColumns(snnsData$eight_016.pat)]
outputs <- snnsData$eight_016.pat[,outputColumns(snnsData$eight_016.pat)]

snnsObject <- SnnsRObjectFactory()

snnsObject$setLearnFunc('JE_BP')
snnsObject$setUpdateFunc('JE_Order')
snnsObject$setUnitDefaults(1,0,1,0,1,'Act_Logistic','Out_Identity')

snnsObject$elman_createNet(c(2,8,2),c(1,1,1),FALSE)


patset <- snnsObject$createPatSet(inputs, outputs)
snnsObject$setCurrPatSet(patset$set_no)

snnsObject$initializeNet(c(1.0,  -1.0,  0.3,  1.0,  0.5) )
snnsObject$shufflePatterns(TRUE)
snnsObject$DefTrainSubPat()

\dontrun{snnsObject$saveNet(paste(basePath,"eight_elmanSnnsR_untrained.net",sep=""),
                                          "eight_elmanSnnsR_untrained")}

parameters <- c(0.2, 0, 0, 0, 0)
maxit <- 1000

error <- vector()
for(i in 1:maxit) {
  res <- snnsObject$learnAllPatterns(parameters)
  if(res[[1]] != 0) print(paste("Error at iteration ", i, " : ", res, sep=""))
  error[i] <- res[[2]]
}

error[1:500]
plot(error, type="l")

\dontrun{snnsObject$saveNet(paste(basePath,"eight_elmanSnnsR.net",sep=""),
                                             "eight_elmanSnnsR")}
\dontrun{snnsObject$saveNewPatterns(paste(basePath,"eight_elmanSnnsR.pat",sep=""), 
                                                         patset$set_no)}
}
\references{
Zell, A. et al. (1998), 'SNNS Stuttgart Neural Network Simulator User Manual, Version 4.2', IPVR, University of Stuttgart and WSI, University of Tübingen. 
\url{http://www.ra.cs.uni-tuebingen.de/SNNS/welcome.html}
}
\seealso{
\code{\link{$}}, \code{\link{SnnsRObjectFactory}}
}
