/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

public class ExposureControlData {
    private double[][] alphaArray;
    private double[][] epsilonArray;
    private int numThetaIntervals;
    private double[] thetaPoints;
    private double rMax;
    private double fadingFactor;

    public ExposureControlData() {
    }

    private ExposureControlData(double[][] alphaArray, double[][] epsilonArray, int numThetaIntervals, double[] thetaPoints, double rMax, double fadingFactor) {
        this.alphaArray = alphaArray;
        this.epsilonArray = epsilonArray;
        this.numThetaIntervals = numThetaIntervals;
        this.thetaPoints = thetaPoints;
        this.rMax = rMax;
        this.fadingFactor = fadingFactor;
    }

    public double[][] getAlphaArray() {
        return this.alphaArray;
    }

    public double[][] getEpsilonArray() {
        return this.epsilonArray;
    }

    public int getNumThetaIntervals() {
        return this.numThetaIntervals;
    }

    public double[] getThetaPoints() {
        return this.thetaPoints;
    }

    public double getRMax() {
        return this.rMax;
    }

    public double getFadingFactor() {
        return this.fadingFactor;
    }

    public void setFadingFactor(double fadingFactor) {
        this.fadingFactor = fadingFactor;
    }

    public static class Builder {
        private double[][] alphaArray;
        private double[][] epsilonArray;
        private int numThetaIntervals;
        private double[] thetaPoints;
        private double rMax;
        private double fadingFactor;

        public Builder alphaArray(double[][] newAlphaArray) {
            this.alphaArray = newAlphaArray;
            return this;
        }

        public Builder epsilonArray(double[][] newEpsilonArray) {
            this.epsilonArray = newEpsilonArray;
            return this;
        }

        public Builder numThetaIntervals(int newNumThetaIntervals) {
            this.numThetaIntervals = newNumThetaIntervals;
            return this;
        }

        public Builder thetaPoints(double[] newThetaPoints) {
            this.thetaPoints = newThetaPoints;
            return this;
        }

        public Builder rMax(double newRMax) {
            this.rMax = newRMax;
            return this;
        }

        public Builder fadingFactor(double newFadingFactor) {
            this.fadingFactor = newFadingFactor;
            return this;
        }

        public ExposureControlData build() {
            return new ExposureControlData(this.alphaArray, this.epsilonArray, this.numThetaIntervals, this.thetaPoints, this.rMax, this.fadingFactor);
        }
    }
}

