% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.import.gdal}
\alias{rsaga.import.gdal}
\title{Import Grid Files to SAGA grid format using GDAL}
\usage{
rsaga.import.gdal(in.grid, out.grid, env = rsaga.env(), ...)
}
\arguments{
\item{in.grid}{file name of a grid in a format supported by GDAL}

\item{out.grid}{output SAGA grid file name; defaults to \code{in.grid} with
the file extension being removed; file extension should not be specified,
it defaults to \code{.sgrd}}

\item{env}{RSAGA geoprocessing environment created by \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{additional arguments to be passed to \code{rsaga.geoprocessor}}
}
\description{
These functions provide simple interfaces for reading and writing grids
from/to ASCII grids and Rd files. Grids are stored in matrices, their headers
in lists.
}
\details{
The GDAL Raster Import module of SAGA imports grid data from various
file formats using the Geospatial Data Abstraction Library (GDAL) by Frank
Warmerdam. GDAL Versions are specific to SAGA versions:
\itemize{
\item SAGA 2.1.2 - 2.2.0: GDAL v.1.11.0
\item SAGA 2.2.1 - 2.2.3: GDAL v.2.1.0 dev
\item ...
\item SAGA 8.4.1: GDAL v3.3.0
More information is available at \url{https://gdal.org/}.
}

If \code{in.grid} has more than one band (e.g. RGB GEOTIFF), then output
grids with file names of the form \eqn{in.grid{\_}01.sgrd}{in.grid_01.sgrd},
\eqn{in.grid{\_}02.sgrd}{in.grid_02.sgrd} etc. are written, one for each
band.

Numerous raster formats are currently supported. For SAGA 8.4.1 see e.g.
\url{https://saga-gis.sourceforge.io/saga_tool_doc/8.4.1/io_gdal_0.html}
}
\references{
GDAL website: \url{https://gdal.org/}
}
\seealso{
\code{read.ascii.grid}, \code{rsaga.esri.to.sgrd}, \code{read.sgrd}, \code{read.Rd.grid}
}
\author{
Alexander Brenning (R interface), Olaf Conrad / Andre Ringeler (SAGA module), Frank Warmerdam (GDAL)
}
\keyword{file}
\keyword{interface}
\keyword{spatial}
