% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-core.R
\name{rsaga.geoprocessor}
\alias{rsaga.geoprocessor}
\title{Generic R interface for SAGA modules}
\usage{
rsaga.geoprocessor(lib, module = NULL, param = list(),
  show.output.on.console = TRUE, invisible = TRUE, intern = TRUE,
  prefix = NULL, flags = ifelse(show.output.on.console, "q", "s"), cores,
  env = rsaga.env(), display.command = FALSE, reduce.intern = TRUE,
  check.module.exists = TRUE, warn = options("warn")$warn, argsep = " ",
  ...)
}
\arguments{
\item{lib}{Name of the SAGA library to be called (see Details).}

\item{module}{Number (\code{>=0}) or name of the module to called within the library \code{lib} (see Details).}

\item{param}{A list of named arguments to be passed to the SAGA module (see Examples).}

\item{show.output.on.console}{a logical (default: \code{TRUE}), indicates whether to capture the output of the command and show it on the R console (see \code{\link[=system]{system()}}).}

\item{invisible}{a logical, indicates whether the command window  should be visible on the screen.}

\item{intern}{a logical, indicates whether to make the output of the command an R object}

\item{prefix}{optional character string: prefix such as \code{"-h"} used in the \code{saga_cmd} call; mostly for internal purposes; call \code{saga_cmd -h} from the command line for details; see also \code{flags}}

\item{flags}{optional character string indicating any command line flags; supported only by SAGA GIS 2.1.0 (and higher), quietly ignored otherwise: \code{"q"}: no progress report (the default for \code{show.output.on.console=TRUE}); \code{"r"}: no messages report; \code{"s"}: silent mode, i.e. no progress and no messages report  (the default for \code{show.output.on.console=FALSE}); other flag options probably not relevant within RSAGA}

\item{cores}{optional numeric argument, or \code{NA}: number of cores used by SAGA GIS; supported only by SAGA GIS 2.1.0 (and higher), ignored otherwise (with a warning); overwrites the \code{cores} setting specified in the \code{env} argument (see \code{\link[=rsaga.env]{rsaga.env()}}). Multicore-enabled SAGA GIS modules such as the one used by \code{\link[=rsaga.pisr]{rsaga.pisr()}} seem to run in multicore mode by default when this argument is not specified, therefore \code{cores} should only be specified to use a smaller number of cores than available on a machine.}

\item{env}{A SAGA geoprocessing environment, i.e. a list with information on the SAGA and SAGA modules paths and the name of the working directory in which to look for input and output files. (Defaults: see \code{\link[=rsaga.env]{rsaga.env()}}.)}

\item{display.command}{Display the DOS command line for executing the SAGA module (including all the arguments to be passed). Default: \code{FALSE}.}

\item{reduce.intern}{If \code{intern=TRUE}, reduce the text output of SAGA returned to R by eliminating redundant lines showing the progress of module execution etc. (default: \code{TRUE}).}

\item{check.module.exists}{logical (default: \code{TRUE}): call \code{\link[=rsaga.module.exists]{rsaga.module.exists()}} to determine if the specified module can be called in the current SAGA installation}

\item{warn}{logical (default: \code{TRUE}): for internal purposes - can be used to suppress warning messages generated by failed SAGA_CMD calls; currently used by \code{\link[=rsaga.get.lib.modules]{rsaga.get.lib.modules()}} and related functions; see \code{\link[=options]{options()}} argument \code{warn} for details}

\item{argsep}{character (default: \code{" "}; currently for internal use): defines the character symbol used as a separator between each argument name and argument value passed to \code{saga_cmd}. SAGA GIS 2.1.0 (RC1) seems to move toward \code{"="} as a separator, but \code{" "} still works and some modules (e.g. the used by \code{rsaga.pisr}) don't seem to work with \code{argsep="="}. Future releases of RSAGA may change the default \code{argsep} value and/or delete or ignore this argument and/or move it to \code{\link[=rsaga.env]{rsaga.env()}}.}

\item{...}{Additional arguments to be passed to \code{\link[base:system]{base::system()}}.}
}
\value{
The type of object returned depends on the \code{intern} argument passed to \code{\link[=system]{system()}}.

If \code{intern=FALSE}, a numerical error/success code is returned, where a value of \code{0} corresponds to success and a non-zero value indicates an error. Note however that the function always returns a success value of \code{0} if \code{wait=FALSE}, i.e. if it does not wait for SAGA to finish.

If \code{intern=TRUE} (default), the console output of SAGA is returned as a character vector. This character vector lists the input file names and modules arguments, and gives a more or less detailed report of the function's progress. Redundant information can be cancelled out by setting \code{reduce.intern=TRUE}.
}
\description{
This function is the workhorse of the R--SAGA interface: It calls the SAGA command line tool to run SAGA modules and pass arguments.
}
\details{
This workhorse function establishes the interface between the SAGA command line program and R by submitting a system call. This is a low-level function that may be used for directly accessing SAGA; specific functions such as \code{rsaga.hillshade} are intended to be more user-friendly interfaces to the most frequently used SAGA modules. These higher-level interfaces support default values for the arguments and perform some error checking; they should therefore be preferred if available.

A warning is issued if the RSAGA version is not one of 2.0.4-2.0.8 or 2.1.0-2.1.4
}
\note{
Existing output files will be overwritten by SAGA without prompting!

If a terrain analysis function is not directly interfaced by one of the RSAGA functions, you might still find it in the growing set of SAGA libraries and modules. The names of all libraries available in your SAGA installation can be obtained using \code{\link[=rsaga.get.libraries]{rsaga.get.libraries()}} (or by checking the directory listing of the \code{modules} folder in the SAGA directory). The names and numeric codes of all available modules (globally or within a specific library) are retrieved by \code{\link[=rsaga.get.modules]{rsaga.get.modules()}}. Full-text search in library and module names is performed by \code{\link[=rsaga.search.modules]{rsaga.search.modules()}}. For information on the usage of SAGA command line modules, see \code{\link[=rsaga.get.usage]{rsaga.get.usage()}}, or the RSAGA interface function if available.

\code{display.command=TRUE} is mainly intended for debugging purposes to check if all arguments are passed correctly to SAGA CMD.
}
\examples{
\dontrun{
rsaga.hillshade("dem","hillshade",exaggeration=2)
# using the RSAGA geoprocessor:
rsaga.geoprocessor("ta_lighting",0,list(ELEVATION="dem.sgrd",SHADE="hillshade",EXAGGERATION=2))
# equivalent DOS command line call:
# saga_cmd.exe ta_lighting 0 -ELEVATION dem.sgrd -SHADE hillshade -EXAGGERATION 2
}
}
\references{
Brenning, A., 2008. Statistical geocomputing combining R and
SAGA: The example of landslide susceptibility analysis with
generalized additive models. In J. Boehner, T. Blaschke and
L. Montanarella (eds.), SAGA - Seconds Out (= Hamburger
Beitraege zur Physischen Geographie und
Landschaftsoekologie, vol. 19), p. 23-32.
}
\seealso{
\code{\link[=rsaga.env]{rsaga.env()}}, \code{\link[=rsaga.get.libraries]{rsaga.get.libraries()}}, \code{\link[=rsaga.get.modules]{rsaga.get.modules()}}, \code{\link[=rsaga.search.modules]{rsaga.search.modules()}}, \code{\link[=rsaga.get.usage]{rsaga.get.usage()}}; \code{\link[=rsaga.esri.wrapper]{rsaga.esri.wrapper()}} for a wrapper for ESRI ASCII/binary grids; \code{\link[=rsaga.hillshade]{rsaga.hillshade()}} and other higher-level functions.
}
\author{
Alexander Brenning (R interface); Olaf Conrad and the SAGA development team (SAGA development)
}
\keyword{interface}
\keyword{spatial}
