% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.slope.asp.curv}
\alias{rsaga.slope.asp.curv}
\title{Slope, Aspect, Curvature}
\usage{
rsaga.slope.asp.curv(in.dem, out.slope, out.aspect, out.cgene, out.cprof,
  out.cplan, out.ctang, out.clong, out.ccros, out.cmini, out.cmaxi, out.ctota,
  out.croto, method = "poly2zevenbergen", unit.slope = "radians",
  unit.aspect = "radians", env = rsaga.env(), ...)
}
\arguments{
\item{in.dem}{input: digital elevation model as SAGA grid file (\code{.sgrd})}

\item{out.slope}{optional output: slope}

\item{out.aspect}{optional output: aspect}

\item{out.cgene}{optional output: general curvature}

\item{out.cprof}{optional output: profile curvature (vertical curvature; degrees)}

\item{out.cplan}{optional output: plan curvature (horizontal curvature; degrees)}

\item{out.ctang}{optional output: tangential curvature (degrees)}

\item{out.clong}{optional output: longitudinal curvature (degrees) Zevenbergen & Thorne (1987) refer to this as profile curvature}

\item{out.ccros}{optional output: cross-sectional curvature (degrees) Zevenbergen & Thorne (1987) refer to this as the plan curvature}

\item{out.cmini}{optional output: minimal curvature (degrees)}

\item{out.cmaxi}{optional output: maximal curvature (degrees)}

\item{out.ctota}{optional output: total curvature (degrees)}

\item{out.croto}{optional output: flow line curvature (degrees)}

\item{method}{character algorithm (see References):
\itemize{
\item 0 Maximum Slope - Travis et al. (1975) (\code{"maxslope"})
\item 1 Max. Triangle Slope - Tarboton (1997) (\code{"maxtriangleslope"})
\item 2 Least Squares Fit Plane - Costa-Cabral & Burgess (1996) (\code{"lsqfitplane"})
\item 3 Fit 2nd Degree Polynomial - Evans (1979) (\code{"poly2evans"})
\item 4 Fit 2nd Degree Polynomial - Heerdegen and Beran (1982) (\code{"poly2heerdegen"})
\item 5 Fit 2nd Degree Polynomial - Bauer et al. (1985) (\code{"poly2bauer"})
\item 6 default: Fit 2nd Degree Polynomial - Zevenbergen & Thorne (1987) (\code{"poly2zevenbergen"})
\item 7 Fit 3rd Degree Polynomial - Haralick (1983) (\code{"poly3haralick"})
}}

\item{unit.slope}{character or numeric (default \code{"radians"}):
\itemize{
\item 0 \code{"radians"}
\item 1 \code{"degrees"}
\item 2 \code{"percent"}
}}

\item{unit.aspect}{character or numeric (default is 0, or \code{"radians"}):
\itemize{
\item 0 \code{"radians"}
\item 1 \code{"degrees"}
}}

\item{env}{list, setting up a SAGA geoprocessing environment as created by \code{\link[=rsaga.env]{rsaga.env()}}}

\item{...}{further arguments to \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.
}
\description{
Calculates local morphometric terrain attributes (i.e. slope, aspect, and curvatures). Intended for use with SAGA v 2.1.1+. For older versions use \code{\link[=rsaga.local.morphometry]{rsaga.local.morphometry()}}.
}
\details{
Profile and plan curvature calculation (\code{out.cprof}, \code{out.cplan}) changed in SAGA GIS 2.1.1+ compared to earlier versions. See the following thread on sourceforge.net for an ongoing discussion: \url{http://sourceforge.net/p/saga-gis/discussion/354013/thread/e9d07075/#5727}
}
\examples{
\dontrun{
# Simple slope, aspect, and general curvature in degrees:
rsaga.slope.asp.curv("lican.sgrd", "slope", "aspect", "curvature",
                     method = "maxslope", unit.slope = "degrees", unit.aspect = "degrees")
# same for ASCII grids (default extension .asc):
rsaga.esri.wrapper(rsaga.slope.asp.curv,
                   in.dem="lican", out.slope="slope",
                   out.aspect = "aspect", out.cgene = "curvature",
                   method="maxslope", unit.slope = "degrees", unit.aspect = "degrees")
}
}
\references{
General references:

Jones KH (1998) A comparison of algorithms used to compute hill slope as a property of the DEM. Computers and Geosciences. 24 (4): 315-323.

References on specific methods:

Maximum Slope:

Travis, M.R., Elsner, G.H., Iverson, W.D., Johnson, C.G. (1975): VIEWIT: computation of seen areas, slope, and aspect for land-use planning. USDA F.S. Gen. Tech. Rep. PSW-11/1975, 70 p. Berkeley, California, U.S.A.

Maximum Triangle Slope:

Tarboton, D.G. (1997): A new method for the determination of flow directions and upslope areas in grid digital elevation models. Water Ressources Research, 33(2): 309-319.

Least Squares or Best Fit Plane:

Beasley, D.B., Huggins, L.F. (1982): ANSWERS: User's manual. U.S. EPA-905/9-82-001, Chicago, IL, 54 pp.

Costa-Cabral, M., Burges, S.J. (1994): Digital Elevation Model Networks (DEMON): a model of flow over hillslopes for computation of contributing and dispersal areas. Water Resources Research, 30(6): 1681-1692.

Fit 2nd Degree Polynomial:

Evans, I.S. (1979): An integrated system of terrain analysis and slope mapping. Final Report on grant DA-ERO-591-73-G0040. University of Durham, England.

Bauer, J., Rohdenburg, H., Bork, H.-R. (1985): Ein Digitales Reliefmodell als Vorraussetzung fuer ein deterministisches  Modell der Wasser- und Stoff-Fluesse. Landschaftsgenese und Landschaftsoekologie, H. 10, Parameteraufbereitung fuer deterministische Gebiets-Wassermodelle, Grundlagenarbeiten zur Analyse von Agrar-Oekosystemen, eds.: Bork, H.-R., Rohdenburg, H., p. 1-15.

Heerdegen, R.G., Beran, M.A. (1982): Quantifying source areas through land surface curvature. Journal of Hydrology, 57.

Zevenbergen, L.W., Thorne, C.R. (1987): Quantitative analysis of land surface topography. Earth Surface Processes and Landforms, 12: 47-56.

Fit 3.Degree Polynomial:

Haralick, R.M. (1983): Ridge and valley detection on digital images. Computer Vision, Graphics and Image Processing, 22(1): 28-38.

For a discussion on the calculation of slope by ArcGIS check these links:

\url{http://forums.esri.com/Thread.asp?c=93&f=1734&t=239914}

\url{http://webhelp.esri.com/arcgisdesktop/9.2/index.cfm?topicname=how_slope_works}
}
\seealso{
\code{\link[=rsaga.local.morphometry]{rsaga.local.morphometry()}}, \code{\link[=rsaga.parallel.processing]{rsaga.parallel.processing()}}, \code{\link[=rsaga.geoprocessor]{rsaga.geoprocessor()}},  \code{\link[=rsaga.env]{rsaga.env()}}
}
\author{
Alexander Brenning and Donovan Bangs (R interface), Olaf Conrad (SAGA module)
}
\keyword{interface}
\keyword{spatial}
