% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move.lineage.R
\name{move.lineage}
\alias{move.lineage}
\title{Move tips or clades}
\usage{
move.lineage(tree,focal,sister,rescale=TRUE,rootage=NULL)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and
fully dichotomous.}

\item{focal}{the lineage to be moved. It can be either a tip name/number or a
node number. If \code{tree$node.label} is not \code{NULL}, a \code{focal}
clade can be indicated as "Clade NAMEOFTHECLADE" when appropriate.
Similarly, an entire genus can be indicated as "Genus NAMEOFTHEGENUS" (see
examples below).}

\item{sister}{the sister tip/node where the \code{focal} must be attached. It
can be tip name/number or node number. If \code{tree$node.label} is not
\code{NULL}, a \code{focal} clade can be indicated as "Clade
NAMEOFTHECLADE" when appropriate. Similarly, an entire genus can be
indicated as "Genus NAMEOFTHEGENUS" (see examples below).}

\item{rescale}{logical. If the most recent common ancestor of the
\code{focal} clade is older than its new ancestor (i.e. the node right
above \code{sister}), the user can choose whether the height of the
\code{focal} clade must be rescaled on the height of the new ancestor
(\code{rescale=TRUE}), or the topology of the tree must be modified to
accommodate the height of \code{focal} as it is (rescale=FALSE, in this
case \code{\link{scaleTree}} is applied).}

\item{rootage}{the age of the tree root to be supplied if \code{focal} must
be attached to it. If \code{rootage=NULL} the total height of the tree
increases by 10\%.}
}
\value{
The phylogenetic tree with required topological changes.
}
\description{
Move a single tip or an entire clade to a different position
  within the tree.
}
\examples{
require(phytools)
DataCetaceans$tree->tree

### Case 1. Moving a single tip
# sister to a tip
move.lineage(tree,focal="Orcinus_orca",sister="Balaenoptera_musculus")
# sister to a clade
move.lineage(tree,focal="Orcinus_orca",sister=131)
# sister to a clade by using tree$node.label
move.lineage(tree,focal="Balaenoptera_musculus",sister="Clade Delphinida")
# sister to a specific genus
move.lineage(tree,focal="Orcinus_orca",sister="Genus Balaenoptera")
# sister to the tree root with and without rootage
move.lineage(tree,focal="Balaenoptera_musculus",sister=117)
move.lineage(tree,focal="Balaenoptera_musculus",sister=117,rootage=max(diag(vcv(tree))))

### Case 2. Moving a clade
# sister to a tip
move.lineage(tree,focal="Genus Mesoplodon",sister="Balaenoptera_musculus")
move.lineage(tree,focal="Clade Delphinida",sister="Balaenoptera_musculus")
move.lineage(tree,focal=159,sister="Balaenoptera_musculus")
# sister to a clade
move.lineage(tree,focal="Genus Mesoplodon",sister=131)
move.lineage(tree,focal="Clade Delphinida",sister=131)
move.lineage(tree,focal=159,sister=131)
# sister to a clade by using tree$node.label
move.lineage(tree,focal="Genus Mesoplodon",sister="Clade Plicogulae")
move.lineage(tree,focal="Clade Delphinida",sister="Clade Plicogulae")
move.lineage(tree,focal=159,sister="Clade Plicogulae")
# sister to a specific genus
move.lineage(tree,focal="Genus Mesoplodon",sister="Genus Balaenoptera")
move.lineage(tree,focal="Clade Delphinida",sister="Genus Balaenoptera")
move.lineage(tree,focal=159,sister="Genus Balaenoptera")
# sister to the tree root with and without rootage
move.lineage(tree,focal="Genus Mesoplodon",sister=117)
move.lineage(tree,focal="Clade Delphinida",sister=117)
move.lineage(tree,focal=159,sister=117)
move.lineage(tree,focal="Genus Mesoplodon",sister=117,rootage=max(diag(vcv(tree))))
move.lineage(tree,focal="Clade Delphinida",sister=117,rootage=max(diag(vcv(tree))))
move.lineage(tree,focal=159,sister=117,rootage=max(diag(vcv(tree))))
}
\author{
Silvia Castiglione, Pasquale Raia
}
