% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGLS_fossil.R
\name{PGLS_fossil}
\alias{PGLS_fossil}
\title{Phylogenetic Generalized Least Square with fossil phylogenies}
\usage{
PGLS_fossil(tree,x,y)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric and fully dichotomous.}

\item{x}{the predictor variable}

\item{y}{the response variable}
}
\value{
Fitted pgls parameters and significance.
}
\description{
The function performs pgls for non-ultrametric trees with lambda correlation.
}
\examples{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino
DataOrnithodirans$statedino->statedino
statedino[match(treedino$tip.label,names(statedino))]->statedino
massdino[match(treedino$tip.label,names(massdino))]->massdino

PGLS_fossil(tree=treedino,x=statedino,y=massdino)

}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco Carotenuto
}
