% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRphylo.R
\name{RRphylo}
\alias{RRphylo}
\title{Evolutionary rates computation along phylogenies}
\usage{
RRphylo(tree,y,cov=NULL)
}
\arguments{
\item{tree}{a phylogenetic tree. The tree needs not to be ultrametric or fully dichotomous.}

\item{y}{either a single vector variable or a multivariate dataset of class \sQuote{matrix}.}

\item{cov}{the covariate to be indicated if its effect on the rates must be accounted for. In this case residuals of the covariate versus the rates are used as rates. \code{'cov'} must be as long as the number of nodes plus the number of tips of the tree, which can be obtained by running \code{RRphylo} on the covariate as well, and taking the vector of ancestral states and tip values to form the covariate, as in the example below.}
}
\value{
\strong{tree} the tree used by \code{RRphylo}. The fully dichotomous version of the tree argument. For trees with polytomies, the tree is resolved by using \code{multi2di} function in the package \pkg{ape}. If the latter is a dichotomous tree, the two trees will be identical.

\strong{tip.path} a \eqn{n * m} matrix, where n=number of tips and m=number of branches (i.e. 2*n-1). Each row represents the branch lengths along a root-to-tip path.

\strong{node.path} a \eqn{n * n} matrix, where n=number of internal branches. Each row represents the branch lengths along a root-to-node path.

\strong{rates} single rate values computed for each branch of the tree. If \code{y} is a single vector variable, rates are equal to multiple.rates. If \code{y} is a multivariate dataset, rates are computed as the square root of the sum of squares of each row of \code{$multiple.rates}.

\strong{aces} the phenotypes reconstructed at nodes.

\strong{predicted.phenotypes} the vector of estimated tip values.

\strong{multiple.rates} a \eqn{n * m} matrix, where n= number of branches (i.e. n*2-1) and m = number of variables. For each branch, the column entries represent the evolutionary rate.

\strong{lambda} the regularization factor fitted within \code{RRphylo} inner function \code{optL}.
}
\description{
The function \code{RRphylo} (\cite{Castiglione et al. 2018}) performs the phylogenetic ridge regression. It takes a tree and a vector of tip data (phenotypes) as entries, calculates the regularization factor, produces the matrices of tip to root (\code{\link{makeL}}), and node to root distances (\code{\link{makeL1}}), the vector of ancestral state estimates, and the rates vector for all the branches of the tree. For multivariate data, rates are given as both one vector per variable, and as a multivariate vector obtained by computing the Euclidean Norm of individual rate vectors.
}
\examples{
 \donttest{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino

# Case 1. "RRphylo" without accounting for the effect of a covariate
    RRphylo(tree=treedino,y=massdino)

# Case 2. "RRphylo" accounting for the effect of a covariate
  # "RRphylo" on the covariate in order to retrieve ancestral state values
    RRphylo(tree=treedino,y=massdino)->RRcova
    c(RRcova$aces,massdino)->cov.values
    c(rownames(RRcova$aces),names(massdino))->names(cov.values)

    RRphylo(tree=treedino,y=massdino,cov=cov.values)
    }
}
\references{
Castiglione, S., Tesone, G., Piccolo, M., Melchionna, M., Mondanaro, A., Serio, C., Di Febbraro, M., & Raia, P.(2018). A new method for testing evolutionary rate variation and shifts in phenotypic evolution. \emph{Methods in Ecology and Evolution}, in press.doi:10.1111/2041-210X.12954
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco Carotenuto
}
