% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal14C.R
\name{cal14C}
\alias{cal14C}
\title{Radiocarbon Calibration of Occurrences}
\usage{
cal14C(dataset,age=NULL,uncertainty=NULL,latitude=NULL,domain=NULL,
 bounds=c(0.025,0.975), clust=0.5, save=TRUE, output.dir=NULL)
}
\arguments{
\item{dataset}{a \code{data.frame} containing all the occurrences to be
calibrated.}

\item{age}{character. Name of the column in \code{dataset} containing the
conventional radiocarbon dates.}

\item{uncertainty}{character. Name of the column in \code{dataset} containing
the uncertainty associated to conventional radiocarbon dates.}

\item{latitude}{character. Name of the column in \code{dataset} containing the
latitude (in decimal degrees) of each occurrence.}

\item{domain}{character. Name of the column in \code{dataset} indicating which
occurrences are marine radiocarbon samples. If \code{NULL}, all the
occurrences are assumed as "terrestrial" radiocarbon samples.}

\item{bounds}{numeric. An upper and lower bound (in quantiles) to define the
limits of the density probability created for each radiocarbon age (default:
95\%).}

\item{clust}{numeric. The proportion of cores used to train \code{cal14C}. If
\code{NULL}, parallel computing is disabled.}

\item{save, output.dir}{if \code{save = TRUE}, \code{cal14C} outputs are saved
in \code{output.dir}.}
}
\value{
The initial \code{dataset} with additional
 columns providing detailed calibration information for each occurrence. The
 new columns indicate the calibration curve used for each occurrence
 ("curve"), the calibrated radiocarbon ages ("cal_age"), and the values
 corresponding to the specified confidence limits derived from the density
 estimate of the calibrated radiocarbon ages. If \code{save=TRUE},
 the dataframe is saved as xlsx file in \code{output.dir}.
}
\description{
The function is meant to automatically apply the calibration
 process to conventional radiocarbon ages, relying on the package Bchron
 (Haslett & Parnell 2008). Specifically, the function internally selects the
 appropriate calibration curve based on the latitude associated with each
 occurrence and the nature of the sample (i.e marine or terrestrial samples).
}
\details{
If \code{dataset} includes marine samples, the user should indicate
 it in the domain column by indicating "marine" for the corresponding
 occurrences. In this case, the function uses the marine20 curve to calibrate the
 related radiocarbon ages accordingly.
}
\examples{
\donttest{

library(RRgeo)

## Create an example dataset with 100 random radiocarbon ages and errors
set.seed(2025)
data.frame(age=round(runif(100,20000,50000),0),
           uncertain=round(runif(100,20,300),0),
           latitude=round(runif(100,-90,90),2))->data
data$domain<-"domain"
rep("marine",5)-> data[sample(nrow(data),5),"domain"]

cal14C(dataset=data,
       age="age",
       uncertainty = "uncertain",
       latitude = "latitude",
       domain<-"domain",
       clust=NULL,
       save= FALSE)->res

}
}
\seealso{
\link[Bchron]{BchronCalibrate}
}
\author{
Alessandro Mondanaro, Silvia Castiglione, Pasquale Raia
}
