% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENphylo_prediction.R
\name{ENphylo_prediction}
\alias{ENphylo_prediction}
\title{Project the ENFA and ENphylo models into new geographical space and
 time interval}
\usage{
ENphylo_prediction(object, newdata,
 convert.to.suitability=FALSE,output.dir,proj_name="outputs")
}
\arguments{
\item{object}{a \code{list} of ENFA and ENphylo models.  Each element of the
list must be named using the names of the modelled species.}

\item{newdata}{a \code{SpatRaster} object including explanatory variables onto
which ENFA or ENphylo models are to be projected. The list of variables must
match the list used to model the species.}

\item{convert.to.suitability}{logical. If \code{TRUE},
\code{ENphylo_prediction} projects ENFA or ENphylo model predictions in
different geographical areas and timescales.}

\item{output.dir}{the file path wherein \code{ENphylo_prediction} creates an
"ENphylo_prediction" folder to store prediction outputs for each species.}

\item{proj_name}{name of the subfolder created within the individual species
folders to contain the \code{ENphylo_prediction} outputs.}
}
\value{
The function stores all the results in a number of nested subfolders
 all contained in the "ENphylo_prediction" folder created in
 \code{output.dir}. This contains a subfolder for each individual species in
 \code{object}, in which a subfolder named according to \code{proj_name}
 contains all the outputs. Specifically, the function saves the predictions
 for marginality and specificity (more than one depending on the number of
 significant axes selected by \code{\link{ENphylo_modeling}}) in the new
 geographical areas along with the suitability and binarized maps. The latter
 are calculated by using the three different predefined thresholds:
 MaxSensSpec (i.e. maximize TSS), SensSpec (i.e. equalize sensitivity and
 specificity) and 10th percentile of predicted probability.
}
\description{
The function projects species marginality and specialization
 factors in different geographical areas and timescales. The function is able
 to convert marginality and specialization factors in habitat suitability
 values by using the Mahalanobis distances method.
}
\details{
If \code{convert.to.suitability} is set as \code{TRUE},
 \code{ENphylo_prediction} uses the function
 \code{\link[adehabitatHS]{mahasuhab}} from the \pkg{adehabitatHS} R package
 (\cite{Calenge, 2006}) to compute the habitat suitability map of the species
 over a given area. The conversion of Mahalanobis distances into
 probabilities follows the chi-squared distribution. Specifically, we set the
 degree of freedom equal to \emph{n} rather than \emph{n-1} following
 \cite{Etherington (2019)}. To convert habitat suitability values into binary
 presence/absence values, \code{ENphylo_prediction} relies on three different
 thresholding methods available in the function
 \code{\link[PresenceAbsence]{optimal.thresholds}} (\cite{Freeman &
 Moisen, 2008}).
}
\examples{
\donttest{
library(ape)
library(terra)
library(sf)
library(RRgeo)

newwd<-tempdir()
# newwd<-"YOUR_DIRECTORY"

latesturl<-RRgeo:::get_latest_version("12734585")
curl::curl_download(url = paste0(latesturl,"/files/dat.Rda?download=1"),
                    destfile = file.path(newwd,"dat.Rda"), quiet = FALSE)
load(file.path(newwd,"dat.Rda"))
read.tree(system.file("exdata/Eucopdata_tree.txt", package="RRgeo"))->tree
tree$tip.label<-gsub("_"," ",tree$tip.label)
curl::curl_download(paste0(latesturl,"/files/X35kya.tif?download=1"),
                    destfile = file.path(newwd,"X35kya.tif"), quiet = FALSE)
rast(file.path(newwd,"X35kya.tif"))->map35
project(map35,st_crs(dat[[1]])$proj4string,res = 50000)->map

ENphylo_modeling(input_data=dat[c(1,11)],
                 tree=tree,
                 input_mask=map[[1]],
                 obs_col="OBS",
                 time_col="age",
                 min_occ_enfa=15,
                 boot_test_perc=20,
                 boot_reps=10,
                 swap.args=list(nsim=5,si=0.2,si2=0.2),
                 eval.args=list(eval_metric_for_imputation="AUC",
                                eval_threshold=0.7,
                                output_options="best"),
                 clust=NULL,
                 output.dir=newwd)


getENphylo_results(input.dir =newwd,
                   mods="all",
                   species_name=names(dat)[c(1,11)])->mod


library(rnaturalearth)
ne_countries(returnclass = "sf")->globalmap
subset(globalmap,continent=="North America")->ame_map

map35[[c("bio1","bio4","bio11","bio19")]]->newmap
crop(newmap,ext(ame_map))->newmap
project(newmap,st_crs(dat[[1]])$proj4string,res = 50000)->newmap

ENphylo_prediction(object = mod,
                   newdata = newmap,
                   convert.to.suitability = TRUE,
                   output.dir=newwd,
                   proj_name="proj_example")
}
}
\references{
Calenge, C. (2006) The package adehabitat for the R software: a
 tool for the analysis of space and habitat use by animals. \emph{Ecological
 Modelling}, 197, 516-519.

Etherington, T. R. (2019). Mahalanobis distances and ecological
 niche modelling: correcting a chi-squared probability error. \emph{PeerJ},
 7, e6678.

Freeman, E. A. & Moisen, G. (2008). PresenceAbsence: An R Package
 for Presence-Absence Model Analysis. \emph{Journal of Statistical Software},
 23(11):1-31.

Mondanaro, A., Di Febbraro, M., Castiglione, S., Melchionna, M.,
 Serio, C., Girardi, G., Blefiore, A.M., & Raia, P. (2023). ENphylo: A new
 method to model the distribution of extremely rare species. \emph{Methods in
 Ecology and Evolution}, 14: 911-922. doi:10.1111/2041-210X.14066
}
\seealso{
\code{vignette("ENphylo", package = "RRgeo")}

\link{getENphylo_results}; \href{../doc/ENphylo.html}{\code{ENphylo} vignette}
}
\author{
Alessandro Mondanaro, Mirko Di Febbraro, Silvia Castiglione, Carmela
 Serio, Marina Melchionna, Pasquale Raia
}
