% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRRR.R
\name{RRRR}
\alias{RRRR}
\title{Robust Reduced-Rank Regression using Majorisation-Minimisation}
\usage{
RRRR(
  y,
  x,
  z = NULL,
  mu = TRUE,
  r = 1,
  itr = 100,
  earlystop = 1e-04,
  initial_A = matrix(rnorm(P * r), ncol = r),
  initial_B = matrix(rnorm(Q * r), ncol = r),
  initial_D = matrix(rnorm(P * R), ncol = R),
  initial_mu = matrix(rnorm(P)),
  initial_Sigma = diag(P),
  return_data = TRUE
)
}
\arguments{
\item{y}{Matrix of dimension N*P. The matrix for the response variables. See \code{Detail}.}

\item{x}{Matrix of dimension N*Q. The matrix for the explanatory variables to be projected. See \code{Detail}.}

\item{z}{Matrix of dimension N*R. The matrix for the explanatory variables not to be projected. See \code{Detail}.}

\item{mu}{Logical. Indicating if a constant term is included.}

\item{r}{Integer. The rank for the reduced-rank matrix \eqn{AB'}. See \code{Detail}.}

\item{itr}{Integer. The maximum number of iteration.}

\item{earlystop}{Scalar. The criteria to stop the algorithm early. The algorithm will stop if the improvement
on objective function is small than \eqn{earlystop * objective_from_last_iteration}.}

\item{initial_A}{Matrix of dimension P*r. The initial value for matrix \eqn{A}. See \code{Detail}.}

\item{initial_B}{Matrix of dimension Q*r. The initial value for matrix \eqn{B}. See \code{Detail}.}

\item{initial_D}{Matrix of dimension P*R. The initial value for matrix \eqn{D}. See \code{Detail}.}

\item{initial_mu}{Matrix of dimension P*1. The initial value for the constant \eqn{mu}. See \code{Detail}.}

\item{initial_Sigma}{Matrix of dimension P*P. The initial value for matrix Sigma. See \code{Detail}.}

\item{return_data}{Logical. Indicating if the data used is return in the output.
If set to \code{TRUE}, \code{update.RRRR} can update the model by simply provide new data.
Set to \code{FALSE} to save output size.}
}
\value{
A list of the estimated parameters of class \code{RRRR}.
\describe{
\item{spec}{The input specifications. \eqn{N} is the sample size.}
\item{history}{The path of all the parameters during optimization and the path of the objective value.}
\item{mu}{The estimated constant vector. Can be \code{NULL}.}
\item{A}{The estimated exposure matrix.}
\item{B}{The estimated factor matrix.}
\item{D}{The estimated coefficient matrix of \code{z}.}
\item{Sigma}{The estimated covariance matrix of the innovation distribution.}
\item{obj}{The final objective value.}
\item{data}{The data used in estimation if \code{return_data} is set to \code{TRUE}. \code{NULL} otherwise.}
}
}
\description{
Majorisation-Minimisation based Estimation for Reduced-Rank Regression with a Cauchy Distribution Assumption.
This method is robust in the sense that it assumes a heavy-tailed Cauchy distribution
for the innovations. This method is an iterative optimization algorithm. See \code{References} for a similar setting.
}
\details{
The formulation of the reduced-rank regression is as follow:
\deqn{y = \mu +AB'  x + D z+innov,}
where for each realization \eqn{y} is a vector of dimension \eqn{P} for the \eqn{P} response variables,
\eqn{x} is a vector of dimension \eqn{Q} for the \eqn{Q} explanatory variables that will be projected to
reduce the rank,
\eqn{z} is a vector of dimension \eqn{R} for the \eqn{R} explanatory variables
that will not be projected,
\eqn{\mu} is the constant vector of dimension \eqn{P},
\eqn{innov} is the innovation vector of dimension \eqn{P},
\eqn{D} is a coefficient matrix for \eqn{z} with dimension \eqn{P*R},
\eqn{A} is the so called exposure matrix with dimension \eqn{P*r}, and
\eqn{B} is the so called factor matrix with dimension \eqn{Q*r}.
The matrix resulted from \eqn{AB'} will be a reduced rank coefficient matrix with rank of \eqn{r}.
The function estimates parameters \eqn{\mu}, \eqn{A}, \eqn{B}, \eqn{D}, and \eqn{Sigma}, the covariance matrix of
the innovation's distribution, assuming the innovation has a Cauchy distribution.
}
\examples{
set.seed(2222)
data <- RRR_sim()
res <- RRRR(y=data$y, x=data$x, z = data$z)
res

}
\references{
Z. Zhao and D. P. Palomar, "Robust maximum likelihood estimation of sparse vector error correction model," in2017 IEEE Global Conferenceon Signal and Information Processing (GlobalSIP),  pp. 913--917,IEEE, 2017.
}
\author{
Yangzhuoran Yang
}
