% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.tree.r
\name{add.tree}
\alias{add.tree}
\title{Plot tool to add phylogenetic trees to ordination plots}
\usage{
add.tree(
  OP,
  tree,
  edge.col = 1,
  edge.lty = 1,
  edge.lwd = 1,
  anc.pts = FALSE,
  return.ancs = FALSE,
  ...
)
}
\arguments{
\item{OP}{An object with class \code{\link{plot.ordinate}}.}

\item{tree}{An object of class phylo.}

\item{edge.col}{A single value or vector equal to the number of edges for edge colors.}

\item{edge.lty}{A single value or vector equal to the number of edges for edge line type}

\item{edge.lwd}{A single value or vector equal to the number of edges for edge line weight.}

\item{anc.pts}{A logical value for whether to add points for ancestral values.}

\item{return.ancs}{A logical value for whether ancestral values should be printed.}

\item{...}{Arguments passed onto \code{\link{points}}, used only for ancestral points.}
}
\description{
Function adds a tree based on a description of edges from a class phylo object 
to an existing plot made from an ordinate object.
}
\details{
With some \code{\link{ordinate}} plots, it might be desirable to add a tree connecting points
in a prescribed way, which would be tedious using \code{\link{points}} or \code{\link{lines}}.
This function will project a tree from an object of class phylo into a plot with class, 
\code{\link{plot.ordinate}}.  Using an edges matrix from a phylo object, this function will 
systematically connect plot points with lines that pass through estimated ancestral character 
points in the same plot space.  Ancestral states are estimated assuming a Brownian motion model 
of evolutionary divergence.
}
\examples{

# Examples use residuals from a regression of salamander morphological 
# traits against body size (snout to vent length, SVL).
# Observations are species means and a phylogenetic covariance matrix
# describes the relatedness among observations.

data("PlethMorph")
Y <- as.data.frame(PlethMorph[c("TailLength", "HeadLength", 
"Snout.eye", "BodyWidth", 
"Forelimb", "Hindlimb")])
Y <- as.matrix(Y)
R <- lm.rrpp(Y ~ SVL, data = PlethMorph, 
iter = 0, print.progress = FALSE)$LM$residuals

PCA <- ordinate(R, scale. = TRUE)
pc.plot <- plot(PCA, pch = 19, col = "blue")

add.tree(pc.plot, tree = PlethMorph$tree, anc.pts = TRUE, 
pch = 19, cex = 0.5, col = "red")

}
\seealso{
\code{\link{lines}} and \code{\link{points}}
}
\author{
Michael Collyer
}
\keyword{graphics}
