% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{get_args}
\alias{get_args}
\title{Automatically retrieve GIS function arguments}
\usage{
get_args(alg = NULL, qgis_env = set_env())
}
\arguments{
\item{alg}{A character specifying the GIS algorithm whose arguments you want
to retrieve.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}
}
\value{
The function returns a list whose names correspond to the function 
  arguments you need to specify. Later on, the specified function arguments 
  can serve as input for \code{\link{run_qgis}}'s params argument.
}
\description{
\code{get_args} uses \code{\link{get_usage}} to retrieve 
  function arguments of a GIS function.
}
\examples{
\dontrun{
get_args(alg = "qgis:addfieldtoattributestable")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

