% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pushes.R
\name{pbPost}
\alias{pbPost}
\title{Post a message via Pushbullet}
\usage{
pbPost(type = c("note", "link", "file"), title = "", body = "",
  url = "", filetype = "text/plain", recipients, email, channel, deviceind,
  apikey = .getKey(), devices = .getDevices(), verbose = FALSE,
  debug = FALSE)
}
\arguments{
\item{type}{The type of post: one of \sQuote{note}, \sQuote{link}, or \sQuote{file}.}

\item{title}{The title of the note being posted.}

\item{body}{The body of the note or the (optional) body when the \code{type}
is \sQuote{link}.}

\item{url}{The URL of \code{type} is \sQuote{link}, or the local
path of a file to be sent if \code{type} is \sQuote{file}.}

\item{filetype}{The MIME type for the file at \code{url} (if
\code{type} is \sQuote{file}) such as \dQuote{text/plain} or \dQuote{image/jpeg},
 defaults to \dQuote{text/plain}.}

\item{recipients}{A character or numeric vector indicating the
devices this post should go to. If missing, the default device
is looked up from an optional setting, and if none has been set
the push is sent to all devices.}

\item{email}{An alternative way to specify a recipient is to specify
an email address. If both \code{recipients} and \code{email} are
present, \code{recipients} is used.}

\item{channel}{A channel tag used to specify the name of the channel
as the recipient. If either \code{recipients} or \code{email} are present,
they will take precedence over \code{channel}.}

\item{deviceind}{(Deprecated) The index (or a vector/list of indices) of the
device(s) in the list of devices.}

\item{apikey}{The API key used to access the service. It can be
supplied as an argument here, via the global option
\code{rpushbullet.key}, or via the file \code{~/.rpushbullet.json}
which is read at package initialization (and, if found, also sets
the global option).}

\item{devices}{The device to which this post is pushed. It can be
supplied as an argument here, or via the file
\code{~/.rpushbullet.json} which is read at package
initialization.}

\item{verbose}{Boolean switch to add additional output}

\item{debug}{Boolean switch to add even more debugging output}
}
\value{
A JSON result record is return invisibly
}
\description{
This function posts a message to Pushbullet. Different types of
messages are supported: \sQuote{note}, \sQuote{link},
\sQuote{address}, or \sQuote{file}.
}
\details{
This function invokes the \sQuote{pushes} functionality of
the Pushbullet API; see \url{https://docs.pushbullet.com/v2/pushes} for more
details.

When a \sQuote{note} is pushed, the recipient receives the
title and body of the note.  If a \sQuote{link} is pushed, the recipient's web
browser is opened at the given URL.  If an \sQuote{address} is
pushed, the recipient's web browser is opened in map mode at the
given address.

If \sQuote{recipients} argument is missing, the post is pushed to
\emph{all} devices in accordance with the API definition. If
\sQuote{recipients} is text vector, it matched against the device
names (from either the config file or a corresponding
option). Lastly, if \sQuote{recipients} is a numeric vector, the
post is pushed the corresponding elements in the devices vector.

In other words, the default of value of no specified recipients results
in sending to all devices. If you want a particular subset of
devices you have to specify it name or index. A default device can be set
in the configuration file, or as a global option. If none is set, zero
is used as a code to imply \sQuote{all} devices.

The earlier argument \code{deviceind} is now deprecated and will
be removed in a later release.
}
\examples{
\dontrun{
# A note
pbPost("note", "A Simple Test", "We think this should work.\\nWe really do.")

# A URL -- should open browser
pbPost(type="link", title="Some title", body="Some URL",
       url="http://cran.r-project.org/package=RPushbullet")

# A file
pbPost(type="file", url=system.file("DESCRIPTION", package="RPushbullet"))
}
}
\author{
Dirk Eddelbuettel
}
