% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.AbstractDist.R
\name{AbstractDist}
\alias{AbstractDist}
\title{AbstractDist}
\description{
Base class for OOP statistical distribution
}
\details{
This class is only used to be herited
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ddist}}{[function] density function}

\item{\code{pdist}}{[function] distribution function}

\item{\code{qdist}}{[function] quantile function}

\item{\code{rdist}}{[function] random generator function}

\item{\code{ks.test}}{[ks.test] Goodness of fit with ks.test}

\item{\code{fit_success}}{[bool] TRUE only if the fit is a success and is occurred}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{[string] name of the distribution}

\item{\code{opt}}{[stats::optim result] Result of the MLE to find parameters}

\item{\code{cov}}{[matrix] Covariance matrix of parameters, inverse of hessian}

\item{\code{coef}}{[vector] Vector of coefficients}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AbstractDist-new}{\code{AbstractDist$new()}}
\item \href{#method-AbstractDist-rvs}{\code{AbstractDist$rvs()}}
\item \href{#method-AbstractDist-density}{\code{AbstractDist$density()}}
\item \href{#method-AbstractDist-logdensity}{\code{AbstractDist$logdensity()}}
\item \href{#method-AbstractDist-cdf}{\code{AbstractDist$cdf()}}
\item \href{#method-AbstractDist-sf}{\code{AbstractDist$sf()}}
\item \href{#method-AbstractDist-icdf}{\code{AbstractDist$icdf()}}
\item \href{#method-AbstractDist-isf}{\code{AbstractDist$isf()}}
\item \href{#method-AbstractDist-fit}{\code{AbstractDist$fit()}}
\item \href{#method-AbstractDist-qgradient}{\code{AbstractDist$qgradient()}}
\item \href{#method-AbstractDist-qdeltaCI}{\code{AbstractDist$qdeltaCI()}}
\item \href{#method-AbstractDist-pdeltaCI}{\code{AbstractDist$pdeltaCI()}}
\item \href{#method-AbstractDist-diagnostic}{\code{AbstractDist$diagnostic()}}
\item \href{#method-AbstractDist-clone}{\code{AbstractDist$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-new"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-new}{}}}
\subsection{Method \code{new()}}{
Create a new AbstractDist object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$new(ddist, pdist, qdist, rdist, name, has_gr_nlll)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ddist}}{[function] Density function, e.g. dnorm}

\item{\code{pdist}}{[function] Distribution function, e.g. pnorm}

\item{\code{qdist}}{[function] Quantile function, e.g. qnorm}

\item{\code{rdist}}{[function] Random generator function, e.g. rnorm}

\item{\code{name}}{[str]      name of the distribution}

\item{\code{has_gr_nlll}}{[bool] If the derived class has defined the gradient
of the negative log-likelihood}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `AbstractDist` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-rvs"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-rvs}{}}}
\subsection{Method \code{rvs()}}{
Generation sample from the histogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$rvs(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{[integer] Number of samples drawn}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] A vector of samples
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-density"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-density}{}}}
\subsection{Method \code{density()}}{
Density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$density(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-logdensity"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-logdensity}{}}}
\subsection{Method \code{logdensity()}}{
Log density function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$logdensity(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Values to compute the log-density}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] log of density
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-cdf"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-cdf}{}}}
\subsection{Method \code{cdf()}}{
Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$cdf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] cdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-sf"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-sf}{}}}
\subsection{Method \code{sf()}}{
Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$sf(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{[vector] Quantiles to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] sf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-icdf"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-icdf}{}}}
\subsection{Method \code{icdf()}}{
Inverse of Cumulative Distribution Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$icdf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the CDF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] icdf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-isf"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-isf}{}}}
\subsection{Method \code{isf()}}{
Inverse of Survival Function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$isf(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities to compute the SF}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] isf values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-fit"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-fit}{}}}
\subsection{Method \code{fit()}}{
Fit method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$fit(Y, n_max_try = 100)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] Dataset to infer the histogram}

\item{\code{n_max_try}}{[integer] Because the optim function can fails, the fit
is retry n_try times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
`self`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-qgradient"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-qgradient}{}}}
\subsection{Method \code{qgradient()}}{
Gradient of the quantile function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$qgradient(p, lower.tail = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities}

\item{\code{lower.tail}}{[bool] If CDF or SF.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[vector] gradient
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-qdeltaCI"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-qdeltaCI}{}}}
\subsection{Method \code{qdeltaCI()}}{
Confidence interval of the quantile function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$qdeltaCI(p, Rt = FALSE, alpha = 0.05)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Probabilities}

\item{\code{Rt}}{[bool] if Probabilities or return times}

\item{\code{alpha}}{[double] level of confidence interval}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[list] Quantiles, and confidence interval
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-pdeltaCI"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-pdeltaCI}{}}}
\subsection{Method \code{pdeltaCI()}}{
Confidence interval of the CDF function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$pdeltaCI(x, Rt = FALSE, alpha = 0.05)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{[vector] Quantiles}

\item{\code{Rt}}{[bool] if Probabilities or return times}

\item{\code{alpha}}{[double] level of confidence interval}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[list] CDF, and confidence interval
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-diagnostic"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-diagnostic}{}}}
\subsection{Method \code{diagnostic()}}{
Diagnostic of the fitted law
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$diagnostic(Y, alpha = 0.05)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y}}{[vector] data to check}

\item{\code{alpha}}{[double] level of confidence interval}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[NULL]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractDist-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractDist-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractDist$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
