% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocCI.R
\name{ciROC.rocit}
\alias{ciROC.rocit}
\title{Confidence Interval of ROC curve}
\usage{
\method{ciROC}{rocit}(object, level = 0.95, nboot = 500, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{"rocit"}, returned by
\code{\link{rocit}}. Supports \code{"empirical"} and \code{"binormal"}
ROC curve.}

\item{level}{Level of confidence, must be within the range (0 1).
Default is 0.95.}

\item{nboot}{Number of bootstrap samples, used to estimate \code{var(A)},
\code{var(B)}, \code{cov(A,B)}. Only used for \code{method = "binomial"}.
See 'Details'.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
A list of class \code{"rocci"}, having following elements:
\item{`ROC estimation method``}{The method applied to estimate ROC curve in the
\code{rocit} object.}

\item{`Confidence level`}{Level of confidence as supplied as argument.}
\item{FPR}{An array containing all the FPR values,
for which TPR and confidence
interval of TPR were estimated.}

\item{TPR}{Array containing the TPR values associated with the FPR values.}

\item{LowerTPR}{Lower limits of the TPR values. Forced to zero for
\code{type = "empirical"}, where empirical TPR is zero.}

\item{UpperTPR}{Upper limits of the TPR values. Forced to one for
\code{type = "empirical"}, where empirical TPR is one.}
}
\description{
\code{ciROC} constructs confidence interval
of receiver operating characteristic (ROC)
curve. This is an S3 method defined for object of class \code{"rocit"}.
}
\details{
For large values of \eqn{n_Y} and \eqn{n_{\bar{Y}}},
the distribution of \eqn{TPR(c)} at
\eqn{FPR(c)} can be approximated as a normal distribution
with following mean and variance:
\deqn{\mu_{TPR(c)}=\sum_{i=1}^{n_Y}I(D_{Y_i}\geq c)/n_Y}
\deqn{V ( TPR(c) )=	\frac{  TPR(c) ( 1-  TPR(c))  }{n_Y}
+ ( \frac{g(c^*)}{f(c^*) } )^2 * K }
where \eqn{K=\frac{ FPR(c) (1-FPR(c))}{n_{\bar{Y}} } }, \eqn{g}
and \eqn{f} are the probability distribution functions  of
the diagnostic variable in positive and negative groups
(with corresponding cumulative distribution functions \eqn{G} and \eqn{F}),
\eqn{c^*=S^{-1}_{D_{\bar{ Y}}}( FPR(c) )}, and \eqn{S} is the survival
function given by: \eqn{S(t)=P(T>t)=1-F(t)}. \code{density} and
\code{approxfun} were used to approximate PDF and CDF
of the diagnostic score in the two groups and the inverse survival
of the diagnostic in the negative responses.


For \code{"binomial"} type, variance of \eqn{A+BZ_x} is given by
\eqn{V(A)+Z_x^2V(B)+2Z_xCov(A, B)}. Bootstrap method was used to estimate
\eqn{V(A)}, \eqn{V(B)} and \eqn{Cov{A,B}}. The lower and upper limit of
\eqn{A+BZ_x} are inverse probit transformed to obtain the confidence interval
of the ROC curve.
}
\examples{
data("Loan")
score <- Loan$Score
class <- ifelse(Loan$Status == "CO", 1, 0)
rocit_emp <- rocit(score = score, class = class, method = "emp")
# ------------------------------------------------
ciROC_emp90 <- ciROC(rocit_emp, level = 0.9)
plot(ciROC_emp90, egend = TRUE)

}
\references{
Pepe, Margaret Sullivan. \emph{The statistical evaluation
of medical tests for classification and prediction.} Medicine, 2003.
}
\seealso{
\code{\link{plot.rocci}}, \code{\link{rocit}}, \code{\link{ciAUC.rocit}}
}
